/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.WebsiteImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebsiteRepositoryImpl
extends EntityRepositoryImpl<Website>
implements WebsiteRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.url w_url, w.registration_date w_registrationDate, w.preview_hints w_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM websites as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.url w_url, w.registration_date w_registrationDate, w.preview_hints w_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM websites as w LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid";

    @Autowired
    public WebsiteRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM websites";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Website> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(WebsiteImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebsiteImpl website = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebsiteImpl)rowView.getRow(WebsiteImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                website.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Website findOne(UUID uuid) {
        String query = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.url w_url, w.registration_date w_registrationDate, w.preview_hints w_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM websites as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE w.uuid = :uuid";
        WebsiteImpl result = (WebsiteImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(WebsiteImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebsiteImpl website = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebsiteImpl)rowView.getRow(WebsiteImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                website.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                website.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        if (result != null) {
            result.setRootPages(this.getRootPages((Website)result));
        }
        return result;
    }

    @Override
    public Website findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.url w_url, w.registration_date w_registrationDate, w.preview_hints w_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM websites as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(WebsiteImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebsiteImpl website = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebsiteImpl)rowView.getRow(WebsiteImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                website.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                website.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        Website website = result.orElse(null);
        if (website != null) {
            website.setRootPages(this.getRootPages(website));
        }
        return website;
    }

    @Override
    public Website save(Website website) {
        website.setUuid(UUID.randomUUID());
        website.setCreated(LocalDateTime.now());
        website.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = website.getPreviewImage() == null ? null : website.getPreviewImage().getUuid();
        String query = "INSERT INTO websites(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified, url, registration_date) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified, :url, :registrationDate)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)website)).execute());
        Set identifiers = website.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)website);
        Website result = this.findOne(website.getUuid());
        return result;
    }

    @Override
    public Website update(Website website) {
        website.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = website.getPreviewImage() == null ? null : website.getPreviewImage().getUuid();
        String query = "UPDATE websites SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, url=:url, registration_date=:registrationDate WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)website)).execute());
        this.deleteIdentifiers((Identifiable)website);
        Set identifiers = website.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)website);
        Website result = this.findOne(website.getUuid());
        return result;
    }

    public List<Webpage> getRootPages(Website website) {
        UUID uuid = website.getUuid();
        return this.getRootPages(uuid);
    }

    public List<Webpage> getRootPages(UUID uuid) {
        String sql = "SELECT uuid, created, description, label, last_modified FROM webpages INNER JOIN website_webpages ww ON uuid = ww.webpage_uuid WHERE ww.website_uuid = :uuid ORDER BY ww.sortIndex ASC";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", (Object)uuid)).mapToBean(WebpageImpl.class).list());
        return list.stream().map(WebpageImpl.class::cast).collect(Collectors.toList());
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId", "url"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "w.created";
            }
            case "lastModified": {
                return "w.last_modified";
            }
            case "refId": {
                return "w.refid";
            }
            case "url": {
                return "w.url";
            }
        }
        return null;
    }
}

