/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database.migration;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V1_4_0__DML_Refactor_localized_content
extends BaseJavaMigration {
    private static final Logger LOGGER = LoggerFactory.getLogger(V1_4_0__DML_Refactor_localized_content.class);

    public void migrate(Context context) throws Exception {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(new SingleConnectionDataSource(context.getConnection(), true).getConnection());
        this.migrateLocalizedStructuredContent(jdbcTemplate, "description", "identifiables");
        this.migrateLocalizedStructuredContent(jdbcTemplate, "text", "articles");
        this.migrateLocalizedStructuredContent(jdbcTemplate, "text", "webpages");
        this.migrateLocalizedText(jdbcTemplate);
    }

    private String convertLocalizedStructuredContent(String currentJson) {
        JSONObject localizedStructuredContent = new JSONObject(currentJson).getJSONObject("localizedStructuredContent");
        JSONObject result = new JSONObject();
        localizedStructuredContent.keySet().forEach(locale -> result.put(locale, localizedStructuredContent.get(locale)));
        return result.toString();
    }

    private void migrateLocalizedStructuredContent(JdbcTemplate jdbcTemplate, String tableField, String tableName) throws SQLException {
        String selectQuery = String.format("SELECT uuid,%s FROM %s", tableField, tableName);
        String updateQuery = String.format("UPDATE %s SET %s=?::JSONB WHERE uuid=?::uuid", tableName, tableField);
        LOGGER.info("Migrating from select: " + selectQuery + " to update: " + updateQuery);
        List identifiables = jdbcTemplate.queryForList(selectQuery, new Object[0]);
        for (Map identifiable : identifiables) {
            LOGGER.info("Migrating " + tableField + " of identifiable: " + (String)identifiable.get("uuid"));
            String currentJson = (String)identifiable.get(tableField);
            if (currentJson == null) continue;
            jdbcTemplate.update(updateQuery, new Object[]{this.convertLocalizedStructuredContent(currentJson), identifiable.get("uuid")});
        }
    }

    private String convertLocalizedText(String currentJson) {
        JSONArray labelTranslations = new JSONObject(currentJson).getJSONArray("translations");
        JSONObject result = new JSONObject();
        labelTranslations.forEach(translation -> {
            JSONObject currentTranslation = (JSONObject)translation;
            if (currentTranslation.has("text")) {
                result.put((String)currentTranslation.get("locale"), currentTranslation.get("text"));
            }
        });
        return result.toString();
    }

    private void migrateLocalizedText(JdbcTemplate jdbcTemplate) throws SQLException {
        String selectQuery = "SELECT label,uuid FROM identifiables";
        String updateQuery = "UPDATE identifiables SET label=?::JSONB WHERE uuid=?::uuid";
        List identifiables = jdbcTemplate.queryForList(selectQuery, new Object[0]);
        for (Map identifiable : identifiables) {
            LOGGER.info("Migrating label of identifiable: " + (String)identifiable.get("uuid"));
            String currentJson = (String)identifiable.get("label");
            if (currentJson == null) continue;
            jdbcTemplate.update(updateQuery, new Object[]{this.convertLocalizedText(currentJson), identifiable.get("uuid")});
        }
    }
}

