/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ProjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.identifiable.entity.ProjectImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectRepositoryImpl
extends EntityRepositoryImpl<Project>
implements ProjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT p.uuid p_uuid, p.refid p_refId, p.label p_label, p.description p_description, p.identifiable_type p_type, p.entity_type p_entityType, p.created p_created, p.last_modified p_lastModified, p.text p_text, p.start_date p_startDate, p.end_date p_endDate, p.preview_hints p_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM projects as p LEFT JOIN identifiers as id on p.uuid = id.identifiable LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT p.uuid p_uuid, p.refid p_refId, p.label p_label, p.description p_description, p.identifiable_type p_type, p.entity_type p_entityType, p.created p_created, p.last_modified p_lastModified, p.start_date p_startDate, p.end_date p_endDate, p.preview_hints p_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM projects as p LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid";

    @Autowired
    public ProjectRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM projects";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Project> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(ProjectImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ProjectImpl project = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), fn -> (ProjectImpl)rowView.getRow(ProjectImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                project.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Project findOne(UUID uuid) {
        String query = "SELECT p.uuid p_uuid, p.refid p_refId, p.label p_label, p.description p_description, p.identifiable_type p_type, p.entity_type p_entityType, p.created p_created, p.last_modified p_lastModified, p.text p_text, p.start_date p_startDate, p.end_date p_endDate, p.preview_hints p_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM projects as p LEFT JOIN identifiers as id on p.uuid = id.identifiable LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid WHERE p.uuid = :uuid";
        ProjectImpl result = (ProjectImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(ProjectImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ProjectImpl project = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), fn -> (ProjectImpl)rowView.getRow(ProjectImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                project.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                project.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    @Override
    public Project findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        String query = "SELECT p.uuid p_uuid, p.refid p_refId, p.label p_label, p.description p_description, p.identifiable_type p_type, p.entity_type p_entityType, p.created p_created, p.last_modified p_lastModified, p.text p_text, p.start_date p_startDate, p.end_date p_endDate, p.preview_hints p_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.iiif_base_url f_iiifBaseUrl FROM projects as p LEFT JOIN identifiers as id on p.uuid = id.identifiable LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(ProjectImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ProjectImpl project = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), fn -> (ProjectImpl)rowView.getRow(ProjectImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                project.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                project.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    public PageResponse<DigitalObject> getDigitalObjects(UUID projectUuid, PageRequest pageRequest) {
        String baseQuery = "SELECT d.uuid d_uuid, d.label d_label, d.created d_created, d.last_modified d_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM digitalobjects as d LEFT JOIN identifiers as id on d.uuid = id.identifiable LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid LEFT JOIN project_digitalobjects as pd on d.uuid = pd.digitalobject_uuid WHERE pd.project_uuid = :uuid ORDER BY pd.sortIndex ASC";
        StringBuilder query = new StringBuilder("SELECT d.uuid d_uuid, d.label d_label, d.created d_created, d.last_modified d_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.iiif_base_url pf_iiifBaseUrl FROM digitalobjects as d LEFT JOIN identifiers as id on d.uuid = id.identifiable LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid LEFT JOIN project_digitalobjects as pd on d.uuid = pd.digitalobject_uuid WHERE pd.project_uuid = :uuid ORDER BY pd.sortIndex ASC");
        pageRequest.setSorting(null);
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)projectUuid)).registerRowMapper(BeanMapper.factory(DigitalObjectImpl.class, (String)"d"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            DigitalObjectImpl digitalObject = map.computeIfAbsent((UUID)rowView.getColumn("d_uuid", UUID.class), fn -> (DigitalObjectImpl)rowView.getRow(DigitalObjectImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                digitalObject.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                digitalObject.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(DigitalObject.class::cast).collect(Collectors.toList()));
        String countQuery = "SELECT count(*) FROM digitalobjects as d LEFT JOIN project_digitalobjects as pd on d.uuid = pd.digitalobject_uuid WHERE pd.project_uuid = :uuid";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery).bind("uuid", (Object)projectUuid)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Project save(Project project) {
        project.setUuid(UUID.randomUUID());
        project.setCreated(LocalDateTime.now());
        project.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = project.getPreviewImage() == null ? null : project.getPreviewImage().getUuid();
        String query = "INSERT INTO projects(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified, text, start_date, end_date) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified, :text::JSONB, :startDate, :endDate)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)project)).execute());
        Set identifiers = project.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)project);
        Project result = this.findOne(project.getUuid());
        return result;
    }

    public boolean saveDigitalObjects(UUID projectUuid, List<DigitalObject> digitalObjects) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM project_digitalobjects WHERE project_uuid = :uuid").bind("uuid", (Object)projectUuid)).execute());
        if (digitalObjects != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO project_digitalobjects(project_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex)");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)projectUuid)).bind("digitalObjectUuid", (Object)digitalObject.getUuid())).bind("sortIndex", this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public boolean addDigitalObjects(UUID projectUuid, List<DigitalObject> digitalObjects) {
        if (projectUuid != null && digitalObjects != null) {
            Integer nextSortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "project_digitalobjects", "project_uuid", projectUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO project_digitalobjects(project_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex) ON CONFLICT (project_uuid, digitalobject_uuid) DO NOTHING");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)projectUuid)).bind("digitalObjectUuid", (Object)digitalObject.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    @Override
    public Project update(Project project) {
        project.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = project.getPreviewImage() == null ? null : project.getPreviewImage().getUuid();
        String query = "UPDATE projects SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, text=:text::JSONB, start_date=:startDate, end_date=:endDate WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)project)).execute());
        this.deleteIdentifiers((Identifiable)project);
        Set identifiers = project.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)project);
        Project result = this.findOne(project.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "p.created";
            }
            case "lastModified": {
                return "p.last_modified";
            }
            case "refId": {
                return "p.refid";
            }
        }
        return null;
    }

    public boolean removeDigitalObject(UUID projectUuid, UUID digitalObjectUuid) {
        if (projectUuid != null && digitalObjectUuid != null) {
            String query = "DELETE FROM project_digitalobjects WHERE project_uuid=:projectUuid AND digitalobject_uuid=:digitalObjectUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("projectUuid", (Object)projectUuid)).bind("digitalObjectUuid", (Object)digitalObjectUuid)).execute());
            return true;
        }
        return false;
    }
}

