/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.agent.CorporateBodyRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.CorporateBodyImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CorporateBodyRepositoryImpl
extends EntityRepositoryImpl<CorporateBody>
implements CorporateBodyRepository {
    private static final String FIND_ONE_BASE_SQL = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.homepage_url c_homepageUrl, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM corporatebodies as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM corporatebodies as c LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid";

    @Autowired
    public CorporateBodyRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM corporatebodies";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<CorporateBody> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(CorporateBodyImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CorporateBodyImpl corporateBody = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CorporateBodyImpl)rowView.getRow(CorporateBodyImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                corporateBody.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public CorporateBody findOne(UUID uuid) {
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.homepage_url c_homepageUrl, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM corporatebodies as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid WHERE c.uuid = :uuid";
        CorporateBodyImpl result = (CorporateBodyImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CorporateBodyImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CorporateBodyImpl corporateBody = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CorporateBodyImpl)rowView.getRow(CorporateBodyImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                corporateBody.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                corporateBody.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        return result;
    }

    @Override
    public CorporateBody findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.homepage_url c_homepageUrl, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM corporatebodies as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(CorporateBodyImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CorporateBodyImpl corporateBody = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CorporateBodyImpl)rowView.getRow(CorporateBodyImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                corporateBody.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                corporateBody.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "c.created";
            }
            case "lastModified": {
                return "c.last_modified";
            }
            case "refId": {
                return "c.refid";
            }
        }
        return null;
    }

    @Override
    public CorporateBody save(CorporateBody corporateBody) {
        corporateBody.setUuid(UUID.randomUUID());
        corporateBody.setCreated(LocalDateTime.now());
        corporateBody.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = corporateBody.getPreviewImage() == null ? null : corporateBody.getPreviewImage().getUuid();
        String query = "INSERT INTO corporatebodies(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified, text, homepage_url) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified, :text::JSONB, :homepageUrl)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)corporateBody)).execute());
        Set identifiers = corporateBody.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)corporateBody);
        CorporateBody result = this.findOne(corporateBody.getUuid());
        return result;
    }

    @Override
    public CorporateBody update(CorporateBody corporateBody) {
        corporateBody.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = corporateBody.getPreviewImage() == null ? null : corporateBody.getPreviewImage().getUuid();
        String query = "UPDATE corporatebodies SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, text=:text::JSONB, homepage_url=:homepageUrl WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)corporateBody)).execute());
        this.deleteIdentifiers((Identifiable)corporateBody);
        Set identifiers = corporateBody.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)corporateBody);
        CorporateBody result = this.findOne(corporateBody.getUuid());
        return result;
    }
}

