/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.filter.enums.FilterOperation;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.NodeImpl;
import de.digitalcollections.model.impl.identifiable.entity.WebsiteImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.view.BreadcrumbNavigationImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl<E extends Entity, C extends Comparable<C>>
extends EntityPartRepositoryImpl<Webpage, E>
implements WebpageRepository<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.text w_text, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid";
    private static final String BASE_CHILDREN_QUERY = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w INNER JOIN webpage_webpages ww ON w.uuid = ww.child_webpage_uuid LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE ww.parent_webpage_uuid = :uuid";
    private static final String BREADCRUMB_QUERY = "WITH recursive breadcrumb (uuid,label,parent_uuid,depth) AS (        SELECT w.uuid as uuid, w.label as label, ww.parent_webpage_uuid as parent_uuid,99 as depth        FROM webpages w, webpage_webpages ww        WHERE uuid= :uuid and ww.child_webpage_uuid = w.uuid        UNION ALL        SELECT w.uuid as uuid, w.label as label, ww.parent_webpage_uuid as parent_uuid, depth-1 as depth        FROM webpages w,             webpage_webpages ww,             breadcrumb b        WHERE b.uuid = ww.child_webpage_uuid and ww.parent_webpage_uuid = w.uuid AND ww.parent_webpage_uuid is not null    ) SELECT * from breadcrumb UNION SELECT null as uuid, w.label as label, null as parent_uuid, 0 as depth FROM websites w, website_webpages ww, breadcrumb b WHERE ww.webpage_uuid = b.parent_uuid and w.uuid = ww.website_uuid ORDER BY depth ASC";
    private static final String BREADCRUMB_WITHOUT_PARENT_QUERY = "SELECT w.uuid as uuid, w.label as label        FROM webpages w        WHERE uuid= :uuid";

    @Autowired
    public WebpageRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM webpages";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Webpage> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(WebpageImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebpageImpl webpage = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebpageImpl)rowView.getRow(WebpageImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                webpage.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Webpage findOne(UUID uuid) {
        String query = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.text w_text, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE w.uuid = :uuid";
        WebpageImpl result = (WebpageImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(WebpageImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebpageImpl webpage = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebpageImpl)rowView.getRow(WebpageImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                webpage.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                webpage.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        if (result != null) {
            result.setChildren(this.getChildren((Webpage)result));
        }
        return result;
    }

    @Override
    public Webpage findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.text w_text, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(WebpageImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebpageImpl webpage = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebpageImpl)rowView.getRow(WebpageImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                webpage.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                webpage.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        Webpage webpage = result.orElse(null);
        if (webpage != null) {
            webpage.setChildren(this.getChildren(webpage));
        }
        return webpage;
    }

    public Webpage findOne(UUID uuid, Filtering filtering) {
        String finalQuery;
        WebpageImpl result;
        String filterClauses;
        Object query = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.text w_text, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE w.uuid = :uuid";
        if (filtering != null && !(filterClauses = this.getFilterClauses(filtering)).isEmpty()) {
            query = (String)query + " AND " + filterClauses;
        }
        if ((result = (WebpageImpl)((LinkedHashMap)this.dbi.withHandle(arg_0 -> WebpageRepositoryImpl.lambda$findOne$12(finalQuery = query, uuid, arg_0))).get(uuid)) != null) {
            result.setChildren(this.getChildren((Webpage)result));
        }
        return result;
    }

    public List<Webpage> getChildren(Webpage webpage) {
        return this.getChildren(webpage.getUuid());
    }

    public List<Webpage> getChildren(UUID uuid) {
        String query = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w INNER JOIN webpage_webpages ww ON w.uuid = ww.child_webpage_uuid LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE ww.parent_webpage_uuid = :uuid ORDER BY ww.sortIndex ASC";
        ArrayList<Webpage> result = new ArrayList<Webpage>((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(WebpageImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebpageImpl webpage = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebpageImpl)rowView.getRow(WebpageImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                webpage.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        return result;
    }

    public PageResponse<Webpage> getChildren(UUID uuid, PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(BASE_CHILDREN_QUERY);
        Filtering filtering = pageRequest.getFiltering();
        if (filtering != null) {
            FilterCriterion fc = filtering.getFilterCriterionFor("publicationStart");
            if (fc != null) {
                query.append(" AND ").append(this.getWhereClause(fc));
            }
            if ((fc = filtering.getFilterCriterionFor("publicationEnd")) != null) {
                if (fc.getOperation() == FilterOperation.GREATER_THAN_OR_EQUAL_TO) {
                    query.append(" AND (").append(this.getWhereClause(fc)).append(" OR ").append(this.getColumnName("publicationEnd")).append(" IS NULL").append(")");
                } else {
                    query.append(" AND ").append(this.getWhereClause(fc));
                }
            }
        }
        if (pageRequest.getSorting() == null) {
            query.append(" ORDER BY ww.sortIndex ASC");
        }
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(WebpageImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebpageImpl webpage = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebpageImpl)rowView.getRow(WebpageImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                webpage.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String sql = "SELECT count(*) FROM webpages as w INNER JOIN webpage_webpages ww ON w.uuid = ww.child_webpage_uuid WHERE ww.parent_webpage_uuid = :uuid";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sql).bind("uuid", (Object)uuid)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public Webpage getParent(UUID uuid) {
        String query = "SELECT w.uuid w_uuid, w.label w_label, w.description w_description, w.identifiable_type w_type, w.created w_created, w.last_modified w_lastModified, w.publication_start w_publicationStart, w.publication_end w_publicationEnd, w.preview_hints w_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM webpages as w LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid INNER JOIN webpage_webpages ww ON w.uuid = ww.parent_webpage_uuid WHERE ww.child_webpage_uuid = :uuid";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(WebpageImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebpageImpl parentWebpage = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebpageImpl)rowView.getRow(WebpageImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                parentWebpage.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    @Override
    public Webpage save(Webpage webpage) {
        webpage.setUuid(UUID.randomUUID());
        webpage.setCreated(LocalDateTime.now());
        webpage.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = webpage.getPreviewImage() == null ? null : webpage.getPreviewImage().getUuid();
        String query = "INSERT INTO webpages(uuid, label, description, previewfileresource, preview_hints, identifiable_type, created, last_modified, text, publication_start, publication_end) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :created, :lastModified, :text::JSONB, :publicationStart, :publicationEnd)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)webpage)).execute());
        Set identifiers = webpage.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)webpage);
        Webpage result = this.findOne(webpage.getUuid());
        return result;
    }

    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUuid) {
        Webpage savedWebpage = this.save(webpage);
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "webpage_webpages", "parent_webpage_uuid", parentWebpageUuid);
        String query = "INSERT INTO webpage_webpages(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parent_webpage_uuid, :uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_webpage_uuid", (Object)parentWebpageUuid)).bind("sortIndex", sortIndex)).bindBean((Object)savedWebpage)).execute());
        return this.findOne(savedWebpage.getUuid());
    }

    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) {
        Webpage savedWebpage = this.save(webpage);
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "website_webpages", "website_uuid", parentWebsiteUuid);
        String query = "INSERT INTO website_webpages(website_uuid, webpage_uuid, sortIndex) VALUES (:parent_website_uuid, :uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_website_uuid", (Object)parentWebsiteUuid)).bind("sortIndex", sortIndex)).bindBean((Object)savedWebpage)).execute());
        return this.findOne(savedWebpage.getUuid());
    }

    @Override
    public Webpage update(Webpage webpage) {
        webpage.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = webpage.getPreviewImage() == null ? null : webpage.getPreviewImage().getUuid();
        String query = "UPDATE webpages SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, text=:text::JSONB, publication_start=:publicationStart, publication_end=:publicationEnd WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)webpage)).execute());
        this.deleteIdentifiers((Identifiable)webpage);
        Set identifiers = webpage.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)webpage);
        Webpage result = this.findOne(webpage.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "publicationEnd", "publicationStart"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "w.created";
            }
            case "lastModified": {
                return "w.last_modified";
            }
            case "publicationEnd": {
                return "w.publication_end";
            }
            case "publicationStart": {
                return "w.publication_start";
            }
        }
        return null;
    }

    public Website getWebsite(UUID rootWebpageUuid) {
        String query = "SELECT uuid, refid, label FROM websites INNER JOIN website_webpages ww ON uuid = ww.website_uuid WHERE ww.webpage_uuid = :uuid";
        WebsiteImpl result = (WebsiteImpl)this.dbi.withHandle(h -> (WebsiteImpl)((Query)h.createQuery(query).bind("uuid", (Object)rootWebpageUuid)).mapToBean(WebsiteImpl.class).one());
        return result;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(BREADCRUMB_QUERY).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(BREADCRUMB_WITHOUT_PARENT_QUERY).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).list());
        }
        List nodes = result.stream().map(s -> s).collect(Collectors.toList());
        return new BreadcrumbNavigationImpl(nodes);
    }

    private static /* synthetic */ LinkedHashMap lambda$findOne$12(String finalQuery, UUID uuid, Handle h) throws RuntimeException {
        return (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(finalQuery).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(WebpageImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WebpageImpl webpage = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WebpageImpl)rowView.getRow(WebpageImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                webpage.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                webpage.addIdentifier((Identifier)identifier);
            }
            return map;
        });
    }
}

