/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.EntityPartRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.parts.EntityPart;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class EntityPartRepositoryImpl<P extends EntityPart, E extends Entity>
extends IdentifiableRepositoryImpl<P>
implements EntityPartRepository<P, E> {
    @Autowired
    public EntityPartRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    public void addRelatedEntity(P entityPart, E entity) {
        this.addRelatedEntity(entityPart.getUuid(), entity.getUuid());
    }

    public void addRelatedEntity(UUID entityPartUuid, UUID entityUuid) {
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "rel_entitypart_entities", "entitypart_uuid", entityPartUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_entitypart_entities(entitypart_uuid, entity_uuid, sortindex) VALUES (:entitypart_uuid, :entity_uuid, :sortindex)").bind("entitypart_uuid", (Object)entityPartUuid)).bind("entity_uuid", (Object)entityUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void addRelatedFileresource(P entityPart, FileResource fileResource) {
        this.addRelatedFileresource(entityPart.getUuid(), fileResource.getUuid());
    }

    public void addRelatedFileresource(UUID entityPartUuid, UUID fileResourceUuid) {
        Integer sortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "rel_entitypart_fileresources", "entitypart_uuid", entityPartUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_entitypart_fileresources(entitypart_uuid, fileresource_uuid, sortindex) VALUES (:entitypart_uuid, :fileresource_uuid, :sortindex)").bind("entitypart_uuid", (Object)entityPartUuid)).bind("fileresource_uuid", (Object)fileResourceUuid)).bind("sortindex", sortIndex)).execute());
    }

    @Override
    public P findOne(Identifier identifier) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public List<E> getRelatedEntities(P entityPart) {
        return this.getRelatedEntities(entityPart.getUuid());
    }

    public List<E> getRelatedEntities(UUID entityPartUuid) {
        String query = "SELECT * FROM entities e INNER JOIN rel_entitypart_entities ref ON e.uuid=ref.entity_uuid WHERE ref.entitypart_uuid = :entityPartUuid ORDER BY ref.sortindex";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("entityPartUuid", (Object)entityPartUuid)).mapToBean(EntityImpl.class).list());
        List result = list.stream().map(s -> s).collect(Collectors.toList());
        return result;
    }

    public List<FileResource> getRelatedFileResources(P entityPart) {
        return this.getRelatedFileResources(entityPart.getUuid());
    }

    public List<FileResource> getRelatedFileResources(UUID entityPartUuid) {
        String query = "SELECT * FROM fileresources f INNER JOIN rel_entitypart_fileresources ref ON f.uuid=ref.fileresource_uuid WHERE ref.entitypart_uuid = :entityPartUuid ORDER BY ref.sortindex";
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("entityPartUuid", (Object)entityPartUuid)).mapToBean(FileResourceImpl.class).map(FileResource.class::cast).list());
        return result;
    }

    public List<E> saveRelatedEntities(P entityPart, List<E> entities) {
        return this.saveRelatedEntities(entityPart.getUuid(), entities);
    }

    public List<E> saveRelatedEntities(UUID entityPartUuid, List<E> entities) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_entitypart_entities WHERE entitypart_uuid = :uuid").bind("uuid", (Object)entityPartUuid)).execute());
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entitypart_entities(entitypart_uuid, entity_uuid, sortIndex) VALUES(:uuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)entityPartUuid)).bind("entityUuid", (Object)entity.getUuid())).bind("sortIndex", this.getIndex(entities, (Identifiable)entity))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getRelatedEntities(entityPartUuid);
    }

    public List<FileResource> saveRelatedFileResources(P entityPart, List<FileResource> fileResources) {
        return this.saveRelatedFileResources(entityPart.getUuid(), fileResources);
    }

    public List<FileResource> saveRelatedFileResources(UUID entityPartUuid, List<FileResource> fileResources) {
        if (fileResources == null) {
            return null;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_entitypart_fileresources WHERE entitypart_uuid = :uuid").bind("uuid", (Object)entityPartUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_fileresources(entitypart_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
            for (FileResource fileResource : fileResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)entityPartUuid)).bind("fileResourceUuid", (Object)fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
            }
            preparedBatch.execute();
        });
        return this.getRelatedFileResources(entityPartUuid);
    }
}

