/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi;

import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.filter.enums.FilterOperation;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public abstract class AbstractPagingAndSortingRepositoryImpl {
    public void addLimit(PageRequest pageRequest, StringBuilder query) {
        int pageSize = pageRequest.getPageSize();
        if (pageSize > 0) {
            query.append(" ").append("LIMIT").append(" ").append(pageSize);
        }
    }

    public void addOffset(PageRequest pageRequest, StringBuilder query) {
        int offset = pageRequest.getOffset();
        if (offset >= 0) {
            query.append(" ").append("OFFSET").append(" ").append(offset);
        }
    }

    public void addOrderBy(PageRequest pageRequest, StringBuilder query) {
        String orderBy;
        String[] allowedOrderByFields = this.getAllowedOrderByFields();
        Sorting sorting = pageRequest.getSorting();
        if (sorting != null && !StringUtils.isEmpty((Object)(orderBy = Optional.ofNullable(sorting.getOrders()).orElse(Collections.emptyList()).stream().filter(o -> {
            String sortField = o.getProperty();
            return sortField != null && allowedOrderByFields != null && Arrays.asList(allowedOrderByFields).contains(sortField);
        }).map(o -> {
            String sortDirection = null;
            Direction direction = o.getDirection();
            sortDirection = direction != null && direction.isDescending() ? "DESC" : "ASC";
            String sortField = o.getProperty();
            Optional subSortField = o.getSubProperty();
            String fullQualifiedColumnName = this.getColumnName(sortField);
            if (subSortField.isEmpty()) {
                return String.format("%s %s", fullQualifiedColumnName, sortDirection);
            }
            return String.format("%s->>'%s' %s", fullQualifiedColumnName, subSortField.get(), sortDirection);
        }).collect(Collectors.joining(","))))) {
            query.append(" ORDER BY ").append(orderBy);
        }
    }

    protected void addPageRequestParams(PageRequest pageRequest, StringBuilder query) {
        if (pageRequest != null) {
            this.addOrderBy(pageRequest, query);
            this.addLimit(pageRequest, query);
            this.addOffset(pageRequest, query);
        }
    }

    protected abstract String[] getAllowedOrderByFields();

    protected abstract String getColumnName(String var1);

    protected String getFilterClauses(Filtering filtering) {
        if (filtering == null || filtering.getFilterCriteria().isEmpty()) {
            return "";
        }
        String filterClauses = filtering.getFilterCriteria().stream().map(this::getWhereClause).collect(Collectors.joining(" AND "));
        return filterClauses;
    }

    protected String getWhereClause(FilterCriterion<?> fc) throws IllegalArgumentException, UnsupportedOperationException {
        StringBuilder query = new StringBuilder();
        if (fc != null) {
            FilterOperation filterOperation = fc.getOperation();
            switch (filterOperation) {
                case BETWEEN: {
                    if (fc.getMinValue() == null || fc.getMaxValue() == null) {
                        throw new IllegalArgumentException("For 'BETWEEN' operation two values are expected");
                    }
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" BETWEEN ").append(this.convertToSqlString(fc.getMinValue())).append(" AND ").append(this.convertToSqlString(fc.getMaxValue())).append(")");
                    break;
                }
                case IN: 
                case NOT_IN: {
                    query.append("(").append(this.getColumnName(fc.getFieldName()));
                    if (filterOperation == FilterOperation.NOT_IN) {
                        query.append(" NOT");
                    }
                    query.append(" IN (");
                    query.append(fc.getValues().stream().map(this::convertToSqlString).collect(Collectors.joining(",")));
                    query.append("))");
                    break;
                }
                case CONTAINS: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" ILIKE '%").append(this.convertToSqlString(fc.getValue())).append("%')");
                    break;
                }
                case EQUALS: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" = ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case NOT_EQUALS: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" != ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case GREATER_THAN: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" > ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case GREATER_THAN_OR_NOT_SET: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" > ").append(this.convertToSqlString(fc.getValue())).append(" OR ").append(this.getColumnName(fc.getFieldName())).append(" IS NULL").append(")");
                    break;
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" >= ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case LESS_THAN: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" < ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case LESS_THAN_AND_SET: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" < ").append(this.convertToSqlString(fc.getValue())).append(" AND ").append(this.getColumnName(fc.getFieldName())).append(" IS NOT NULL").append(")");
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" <= ").append(this.convertToSqlString(fc.getValue())).append(")");
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO_AND_SET: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" <= ").append(this.convertToSqlString(fc.getValue())).append(" AND ").append(this.getColumnName(fc.getFieldName())).append(" IS NOT NULL").append(")");
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO_OR_NOT_SET: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" <= ").append(this.convertToSqlString(fc.getValue())).append(" OR ").append(this.getColumnName(fc.getFieldName())).append(" IS NULL").append(")");
                    break;
                }
                case SET: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" IS NOT NULL").append(")");
                    break;
                }
                case NOT_SET: {
                    query.append("(").append(this.getColumnName(fc.getFieldName())).append(" IS NULL").append(")");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(filterOperation + " not supported yet");
                }
            }
        }
        return query.toString();
    }

    protected String convertToSqlString(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof LocalDate) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
            return "'" + ((ChronoLocalDate)value).format(formatter) + "'";
        }
        if (value instanceof String) {
            return "'" + value + "'";
        }
        return value.toString();
    }
}

