/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ArticleRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Article;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.agent.Agent;
import de.digitalcollections.model.api.identifiable.entity.enums.EntityType;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.ArticleImpl;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.CorporateBodyImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.FamilyImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.PersonImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleRepositoryImpl
extends EntityRepositoryImpl<Article>
implements ArticleRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticleRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.text a_text, a.preview_hints a_previewImageRenderingHints, a.date_published a_datePublished, a.timevalue_published a_timeValuePublished, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM articles AS a LEFT JOIN identifiers AS id ON a.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON a.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.preview_hints a_previewImageRenderingHints, a.date_published a_datePublished, a.timevalue_published a_timeValuePublished, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM articles AS a LEFT JOIN fileresources_image AS file ON a.previewfileresource = file.uuid";

    @Autowired
    public ArticleRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM articles";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Article> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(ArticleImpl.class, (String)"a"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ArticleImpl article = map.computeIfAbsent((UUID)rowView.getColumn("a_uuid", UUID.class), fn -> (ArticleImpl)rowView.getRow(ArticleImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                article.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Article findOne(UUID uuid) {
        String query = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.text a_text, a.preview_hints a_previewImageRenderingHints, a.date_published a_datePublished, a.timevalue_published a_timeValuePublished, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM articles AS a LEFT JOIN identifiers AS id ON a.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON a.previewfileresource = file.uuid WHERE a.uuid = :uuid";
        ArticleImpl result = (ArticleImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(ArticleImpl.class, (String)"a"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ArticleImpl article = map.computeIfAbsent((UUID)rowView.getColumn("a_uuid", UUID.class), fn -> (ArticleImpl)rowView.getRow(ArticleImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                article.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                article.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        if (result != null) {
            List<Agent> creators = this.getCreators(uuid);
            result.setCreators(creators);
        }
        return result;
    }

    @Override
    public Article findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT a.uuid a_uuid, a.refid a_refId, a.label a_label, a.description a_description, a.identifiable_type a_type, a.entity_type a_entityType, a.created a_created, a.last_modified a_lastModified, a.text a_text, a.preview_hints a_previewImageRenderingHints, a.date_published a_datePublished, a.timevalue_published a_timeValuePublished, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM articles AS a LEFT JOIN identifiers AS id ON a.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON a.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(ArticleImpl.class, (String)"a"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ArticleImpl article = map.computeIfAbsent((UUID)rowView.getColumn("a_uuid", UUID.class), fn -> (ArticleImpl)rowView.getRow(ArticleImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                article.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                article.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        ArticleImpl article = result.orElse(null);
        if (article != null) {
            article.setCreators(this.getCreators(article.getUuid()));
        }
        return article;
    }

    @Override
    public Article save(Article article) {
        article.setUuid(UUID.randomUUID());
        article.setCreated(LocalDateTime.now());
        article.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = article.getPreviewImage() == null ? null : article.getPreviewImage().getUuid();
        String query = "INSERT INTO articles(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified, date_published, timevalue_published, text) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified, :datePublished, :timeValuePublished::JSONB, :text::JSONB)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)article)).execute());
        Set identifiers = article.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)article);
        List creators = article.getCreators();
        this.saveCreatorsList(article, creators);
        Article result = this.findOne(article.getUuid());
        return result;
    }

    @Override
    public Article update(Article article) {
        article.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = article.getPreviewImage() == null ? null : article.getPreviewImage().getUuid();
        String query = "UPDATE articles SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, date_published=:datePublished, timevalue_published=:timeValuePublished::JSONB, text=:text::JSONB WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)article)).execute());
        this.deleteIdentifiers((Identifiable)article);
        Set identifiers = article.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)article);
        List creators = article.getCreators();
        this.saveCreatorsList(article, creators);
        Article result = this.findOne(article.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "a.created";
            }
            case "lastModified": {
                return "a.last_modified";
            }
            case "refId": {
                return "a.refid";
            }
        }
        return null;
    }

    public List<Agent> getCreators(UUID articleUuid) {
        String query = "SELECT e.uuid e_uuid, e.label e_label, e.refid e_refId, e.entity_type e_entityType, e.created e_created, e.last_modified e_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimetype, file.size_in_bytes pf_size_in_bytes, file.uri pf_uri FROM entities AS e LEFT JOIN identifiers AS id ON e.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON e.previewfileresource = file.uuid LEFT JOIN article_creators AS ac ON e.uuid = ac.agent_uuid WHERE ac.article_uuid = :uuid ORDER BY ac.sortIndex ASC";
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)articleUuid)).registerRowMapper(BeanMapper.factory(EntityImpl.class, (String)"e"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Entity entity = map.computeIfAbsent((UUID)rowView.getColumn("e_uuid", UUID.class), fn -> (Entity)rowView.getRow(EntityImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                entity.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                entity.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(entity -> {
            EntityType entityType = entity.getEntityType();
            switch (entityType) {
                case CORPORATE_BODY: {
                    CorporateBodyImpl corporateBody = new CorporateBodyImpl();
                    corporateBody.setLabel(entity.getLabel());
                    corporateBody.setRefId(entity.getRefId());
                    corporateBody.setUuid(entity.getUuid());
                    return corporateBody;
                }
                case FAMILY: {
                    FamilyImpl family = new FamilyImpl();
                    family.setLabel(entity.getLabel());
                    family.setRefId(entity.getRefId());
                    family.setUuid(entity.getUuid());
                    return family;
                }
                case PERSON: {
                    PersonImpl person = new PersonImpl();
                    person.setLabel(entity.getLabel());
                    person.setRefId(entity.getRefId());
                    person.setUuid(entity.getUuid());
                    return person;
                }
            }
            return null;
        }).collect(Collectors.toList()));
        return result;
    }

    private void saveCreatorsList(Article article, List<Agent> creators) {
        UUID articleUuid = article.getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM article_creators WHERE article_uuid = :uuid").bind("uuid", (Object)articleUuid)).execute());
        if (creators != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO article_creators(work_uuid, agent_uuid, sortIndex) VALUES(:uuid, :agentUuid, :sortIndex)");
                for (Agent agent : creators) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)articleUuid)).bind("agentUuid", (Object)agent.getUuid())).bind("sortIndex", this.getIndex(creators, (Identifiable)agent))).add();
                }
                preparedBatch.execute();
            });
        }
    }
}

