/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.NodeImpl;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.CorporateBodyImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.paging.SearchPageResponseImpl;
import de.digitalcollections.model.impl.view.BreadcrumbNavigationImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CollectionRepositoryImpl
extends EntityRepositoryImpl<de.digitalcollections.model.api.identifiable.entity.Collection>
implements CollectionRepository {
    private static final String BREADCRUMB_QUERY = "WITH recursive breadcrumb (uuid,label,parent_uuid,depth) AS (        SELECT c.uuid AS uuid, c.label AS label, c.refid c_refId, cc.parent_collection_uuid AS parent_uuid, 99 AS depth        FROM collections c, collection_collections cc        WHERE uuid= :uuid and cc.child_collection_uuid = c.uuid        UNION ALL        SELECT c.uuid AS uuid, c.label AS label, c.refid c_refId, cc.parent_collection_uuid AS parent_uuid, depth-1 AS depth        FROM collections c,             collection_collections cc,             breadcrumb b        WHERE b.uuid = cc.child_collection_uuid AND cc.parent_collection_uuid = c.uuid AND cc.parent_collection_uuid IS NOT null    ) SELECT * FROM breadcrumb ORDER BY depth ASC";
    private static final String BREADCRUMB_WITHOUT_PARENT_QUERY = "SELECT c.uuid AS uuid, c.label AS label        FROM collections c        WHERE uuid= :uuid";
    private static final String FIND_ONE_BASE_SQL = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN identifiers AS id ON c.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid";
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionRepositoryImpl.class);
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid";
    private static final String BASE_TOP_QUERY = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid WHERE NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = c.uuid)";
    private static final String BASE_CHILDREN_QUERY = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid INNER JOIN collection_collections cc ON c.uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid";

    @Autowired
    public CollectionRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    public boolean addChildren(UUID parentUuid, List<de.digitalcollections.model.api.identifiable.entity.Collection> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        Integer nextSortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortIndex) VALUES (:parentCollectionUuid, :childCollectionUuid, :sortIndex) ON CONFLICT (parent_collection_uuid, child_collection_uuid) DO NOTHING");
            for (de.digitalcollections.model.api.identifiable.entity.Collection child : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentCollectionUuid", (Object)parentUuid)).bind("childCollectionUuid", (Object)child.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(children, (Identifiable)child))).add();
            }
            preparedBatch.execute();
        });
        return true;
    }

    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        if (collectionUuid != null && digitalObjects != null) {
            Integer nextSortIndex = this.selectNextSortIndexForParentChildren(this.dbi, "collection_digitalobjects", "collection_uuid", collectionUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex) ON CONFLICT (collection_uuid, digitalobject_uuid) DO NOTHING");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)collectionUuid)).bind("digitalObjectUuid", (Object)digitalObject.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM collections";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<de.digitalcollections.model.api.identifiable.entity.Collection> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        String filterClauses = this.getFilterClauses(pageRequest.getFiltering());
        if (!filterClauses.isEmpty()) {
            query.append(" WHERE ").append(filterClauses);
        }
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        Object sql = "SELECT count(*) FROM collections AS c";
        if (!filterClauses.isEmpty()) {
            sql = (String)sql + " WHERE " + filterClauses;
        }
        String sqlCount = sql;
        long total = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sqlCount).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public SearchPageResponse<de.digitalcollections.model.api.identifiable.entity.Collection> find(SearchPageRequest searchPageRequest) {
        StringBuilder query = new StringBuilder("SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.entity_type c_entityType, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid LEFT JOIN LATERAL jsonb_object_keys(c.label) l(keys) ON c.label IS NOT null WHERE (c.label->>l.keys ILIKE '%' || :searchTerm || '%')");
        String filterClauses = this.getFilterClauses(searchPageRequest.getFiltering());
        if (!filterClauses.isEmpty()) {
            query.append(" AND ").append(filterClauses);
        }
        this.addPageRequestParams((PageRequest)searchPageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("searchTerm", searchPageRequest.getQuery())).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            de.digitalcollections.model.api.identifiable.entity.Collection collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), uuid -> (de.digitalcollections.model.api.identifiable.entity.Collection)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", String.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        Object countQuery = "SELECT count(*) FROM collections AS c LEFT JOIN LATERAL jsonb_object_keys(c.label) l(keys) ON c.label IS NOT null WHERE (c.label->>l.keys ILIKE '%' || :searchTerm || '%')";
        if (!filterClauses.isEmpty()) {
            countQuery = (String)countQuery + " AND " + filterClauses;
        }
        String sqlCount = countQuery;
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount).bind("searchTerm", searchPageRequest.getQuery())).mapTo(Long.class).findOne().get());
        return new SearchPageResponseImpl(result, searchPageRequest, total);
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection findOne(UUID uuid) {
        return this.findOne(uuid, null);
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN identifiers AS id ON c.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                collection.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        de.digitalcollections.model.api.identifiable.entity.Collection collection = result.orElse(null);
        if (collection != null) {
            collection.setChildren(this.getChildren(collection));
        }
        return collection;
    }

    public de.digitalcollections.model.api.identifiable.entity.Collection findOne(UUID uuid, Filtering filtering) {
        String finalQuery;
        CollectionImpl result;
        String filterClauses;
        Object query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.text c_text, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN identifiers AS id ON c.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid WHERE c.uuid = :uuid";
        if (filtering != null && !(filterClauses = this.getFilterClauses(filtering)).isEmpty()) {
            query = (String)query + " AND " + filterClauses;
        }
        if ((result = (CollectionImpl)((LinkedHashMap)this.dbi.withHandle(arg_0 -> CollectionRepositoryImpl.lambda$findOne$16(finalQuery = query, uuid, arg_0))).get(uuid)) != null) {
            result.setChildren(this.getChildren((de.digitalcollections.model.api.identifiable.entity.Collection)result));
        }
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "label", "lastModified", "publicationEnd", "publicationStart", "refId"};
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(BREADCRUMB_QUERY).bind("uuid", (Object)nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(BREADCRUMB_WITHOUT_PARENT_QUERY).bind("uuid", (Object)nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).list());
        }
        List nodes = result.stream().map(s -> s).collect(Collectors.toList());
        return new BreadcrumbNavigationImpl(nodes);
    }

    public List<de.digitalcollections.model.api.identifiable.entity.Collection> getChildren(de.digitalcollections.model.api.identifiable.entity.Collection collection) {
        return super.getChildren(collection);
    }

    public List<de.digitalcollections.model.api.identifiable.entity.Collection> getChildren(UUID uuid) {
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid INNER JOIN collection_collections cc ON c.uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid ORDER BY cc.sortIndex ASC";
        ArrayList<de.digitalcollections.model.api.identifiable.entity.Collection> result = new ArrayList<de.digitalcollections.model.api.identifiable.entity.Collection>((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        return result;
    }

    public PageResponse<de.digitalcollections.model.api.identifiable.entity.Collection> getChildren(UUID uuid, PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(BASE_CHILDREN_QUERY);
        String filterClauses = this.getFilterClauses(pageRequest.getFiltering());
        if (!filterClauses.isEmpty()) {
            query.append(" AND ").append(filterClauses);
        }
        query.append(" ORDER BY cc.sortIndex ASC");
        pageRequest.setSorting(null);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        Object countQuery = "SELECT count(*) FROM collections AS c INNER JOIN collection_collections cc ON c.uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid";
        if (!filterClauses.isEmpty()) {
            countQuery = (String)countQuery + " AND " + filterClauses;
        }
        String sqlCount = countQuery;
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount).bind("uuid", (Object)uuid)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "c.created";
            }
            case "label": {
                return "c.label";
            }
            case "lastModified": {
                return "c.last_modified";
            }
            case "publicationEnd": {
                return "c.publication_end";
            }
            case "publicationStart": {
                return "c.publication_start";
            }
            case "refId": {
                return "c.refid";
            }
        }
        return null;
    }

    public PageResponse<DigitalObject> getDigitalObjects(UUID collectionUuid, PageRequest pageRequest) {
        String innerSelect = "SELECT * FROM digitalobjects as d LEFT JOIN collection_digitalobjects AS cd ON d.uuid = cd.digitalobject_uuid WHERE cd.collection_uuid = :uuid";
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM digitalobjects as d LEFT JOIN collection_digitalobjects AS cd ON d.uuid = cd.digitalobject_uuid WHERE cd.collection_uuid = :uuid");
        String filterClauses = this.getFilterClauses(pageRequest.getFiltering());
        if (!filterClauses.isEmpty()) {
            innerQuery.append(" AND ").append(filterClauses);
        }
        innerQuery.append(" ORDER BY cd.sortIndex ASC");
        pageRequest.setSorting(null);
        this.addPageRequestParams(pageRequest, innerQuery);
        String baseQuery = "SELECT d.uuid d_uuid, d.label d_label, d.refid d_refId, d.custom_attrs d_customAttributes, d.created d_created, d.last_modified d_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM (" + innerQuery + ") AS d LEFT JOIN identifiers AS id ON d.uuid = id.identifiable LEFT JOIN fileresources_image AS file ON d.previewfileresource = file.uuid";
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(baseQuery).bind("uuid", (Object)collectionUuid)).registerRowMapper(BeanMapper.factory(DigitalObjectImpl.class, (String)"d"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            DigitalObjectImpl digitalObject = map.computeIfAbsent((UUID)rowView.getColumn("d_uuid", UUID.class), fn -> (DigitalObjectImpl)rowView.getRow(DigitalObjectImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                digitalObject.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                digitalObject.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(DigitalObject.class::cast).collect(Collectors.toList()));
        Object countQuery = "SELECT count(*) FROM digitalobjects AS d LEFT JOIN collection_digitalobjects AS cd ON d.uuid = cd.digitalobject_uuid WHERE cd.collection_uuid = :uuid";
        if (!filterClauses.isEmpty()) {
            countQuery = (String)countQuery + " AND " + filterClauses;
        }
        String sqlCount = countQuery;
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount).bind("uuid", (Object)collectionUuid)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public de.digitalcollections.model.api.identifiable.entity.Collection getParent(UUID uuid) {
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid INNER JOIN collection_collections cc ON c.uuid = cc.parent_collection_uuid WHERE cc.child_collection_uuid = :uuid";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl parent = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                parent.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    public List<de.digitalcollections.model.api.identifiable.entity.Collection> getParents(UUID uuid) {
        String query = "SELECT c.uuid c_uuid, c.refid c_refId, c.label c_label, c.description c_description, c.identifiable_type c_type, c.entity_type c_entityType, c.created c_created, c.last_modified c_lastModified, c.publication_start c_publicationStart, c.publication_end c_publicationEnd, c.preview_hints c_previewImageRenderingHints, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM collections AS c LEFT JOIN fileresources_image AS file ON c.previewfileresource = file.uuid INNER JOIN collection_collections cc ON c.uuid = cc.parent_collection_uuid WHERE cc.child_collection_uuid = :uuid";
        List<de.digitalcollections.model.api.identifiable.entity.Collection> result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl parent = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                parent.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().collect(Collectors.toList());
        return result;
    }

    public List<CorporateBody> getRelatedCorporateBodies(UUID uuid, Filtering filtering) {
        String baseQuery = "SELECT cb.uuid cb_uuid, cb.label cb_label, cb.refid cb_refId, cb.created cb_created, cb.last_modified cb_lastModified, cb.homepage_url cb_homepageUrl, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM corporatebodies AS cb LEFT JOIN rel_entity_entities AS r ON cb.uuid = r.object_uuid LEFT JOIN rel_entity_entities AS rel ON r.subject_uuid = rel.subject_uuid LEFT JOIN fileresources_image AS file ON cb.previewfileresource = file.uuid WHERE rel.object_uuid = :uuid AND rel.predicate = 'is_part_of'";
        StringBuilder query = new StringBuilder(baseQuery);
        FilterCriterion predicate = filtering.getFilterCriterionFor("predicate");
        if (predicate != null) {
            String predicateFilter = String.format(" AND r.predicate = '%s'", predicate.getValue());
            query.append(predicateFilter);
        }
        List<CorporateBody> result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CorporateBodyImpl.class, (String)"cb"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CorporateBodyImpl related = map.computeIfAbsent((UUID)rowView.getColumn("cb_uuid", UUID.class), fn -> (CorporateBodyImpl)rowView.getRow(CorporateBodyImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                related.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        }))).values().stream().collect(Collectors.toList());
        return result;
    }

    public PageResponse<de.digitalcollections.model.api.identifiable.entity.Collection> getTopCollections(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(BASE_TOP_QUERY);
        String filterClauses = this.getFilterClauses(pageRequest.getFiltering());
        if (!filterClauses.isEmpty()) {
            query.append(" AND ").append(filterClauses);
        }
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        Object countQuery = "SELECT count(*) FROM collections AS c WHERE NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = c.uuid)";
        if (!filterClauses.isEmpty()) {
            countQuery = (String)countQuery + " AND " + filterClauses;
        }
        String sqlCount = countQuery;
        long total = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sqlCount).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String query = "DELETE FROM collection_collections WHERE parent_collection_uuid=:parentCollectionUuid AND child_collection_uuid=:childCollectionUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("parentCollectionUuid", (Object)parentUuid)).bind("childCollectionUuid", (Object)childUuid)).execute());
        return true;
    }

    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) {
        if (collectionUuid != null && digitalObjectUuid != null) {
            String query = "DELETE FROM collection_digitalobjects WHERE collection_uuid=:collectionUuid AND digitalobject_uuid=:digitalObjectUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("collectionUuid", (Object)collectionUuid)).bind("digitalObjectUuid", (Object)digitalObjectUuid)).execute());
            return true;
        }
        return false;
    }

    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) {
        if (digitalObject == null) {
            return false;
        }
        String query = "DELETE FROM collection_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid";
        this.dbi.withHandle(h -> ((Update)h.createUpdate(query).bind("digitalObjectUuid", (Object)digitalObject.getUuid())).execute());
        return true;
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection save(de.digitalcollections.model.api.identifiable.entity.Collection collection) {
        collection.setUuid(UUID.randomUUID());
        collection.setCreated(LocalDateTime.now());
        collection.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = collection.getPreviewImage() == null ? null : collection.getPreviewImage().getUuid();
        String query = "INSERT INTO collections(uuid, label, description, previewfileresource, preview_hints, identifiable_type, entity_type, created, last_modified, text, publication_start, publication_end) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :type, :entityType, :created, :lastModified, :text::JSONB, :publicationStart, :publicationEnd)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)collection)).execute());
        Set identifiers = collection.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)collection);
        de.digitalcollections.model.api.identifiable.entity.Collection result = this.findOne(collection.getUuid());
        return result;
    }

    public boolean saveDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE collection_uuid = :uuid").bind("uuid", (Object)collectionUuid)).execute());
        if (digitalObjects != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex)");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)collectionUuid)).bind("digitalObjectUuid", (Object)digitalObject.getUuid())).bind("sortIndex", this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public de.digitalcollections.model.api.identifiable.entity.Collection saveWithParentCollection(de.digitalcollections.model.api.identifiable.entity.Collection collection, UUID parentUuid) {
        UUID childUuid = collection.getUuid() == null ? this.save(collection).getUuid() : collection.getUuid();
        Integer sortindex = this.selectNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortindex) VALUES (:parent_collection_uuid, :child_collection_uuid, :sortindex)").bind("parent_collection_uuid", (Object)parentUuid)).bind("child_collection_uuid", (Object)childUuid)).bind("sortindex", sortindex)).execute());
        return this.findOne(childUuid);
    }

    @Override
    public de.digitalcollections.model.api.identifiable.entity.Collection update(de.digitalcollections.model.api.identifiable.entity.Collection collection) {
        collection.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = collection.getPreviewImage() == null ? null : collection.getPreviewImage().getUuid();
        String query = "UPDATE collections SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, last_modified=:lastModified, text=:text::JSONB, publication_start=:publicationStart, publication_end=:publicationEnd WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)collection)).execute());
        this.deleteIdentifiers((Identifiable)collection);
        Set identifiers = collection.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)collection);
        de.digitalcollections.model.api.identifiable.entity.Collection result = this.findOne(collection.getUuid());
        return result;
    }

    private static /* synthetic */ LinkedHashMap lambda$findOne$16(String finalQuery, UUID uuid, Handle h) throws RuntimeException {
        return (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(finalQuery).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                collection.addIdentifier((Identifier)identifier);
            }
            return map;
        });
    }
}

