/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work.WorkRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.agent.Agent;
import de.digitalcollections.model.api.identifiable.entity.enums.EntityType;
import de.digitalcollections.model.api.identifiable.entity.work.Item;
import de.digitalcollections.model.api.identifiable.entity.work.Work;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.CorporateBodyImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.FamilyImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.PersonImpl;
import de.digitalcollections.model.impl.identifiable.entity.work.ItemImpl;
import de.digitalcollections.model.impl.identifiable.entity.work.WorkImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WorkRepositoryImpl
extends IdentifiableRepositoryImpl<Work>
implements WorkRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.date_published w_datePublished, w.timevalue_published w_timeValuePublished, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimetype, file.size_in_bytes f_size_in_bytes, file.uri f_uri FROM works as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.date_published w_datePublished, w.timevalue_published w_timeValuePublished, file.uuid f_uuid, file.filename f_filename, file.uri f_uri FROM works as w LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid";

    @Autowired
    public WorkRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository);
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM works";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<Work> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(WorkImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WorkImpl work = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), uuid -> (WorkImpl)rowView.getRow(WorkImpl.class));
            if (rowView.getColumn("f_uuid", String.class) != null) {
                work.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public PageResponse<Work> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        StringBuilder query = new StringBuilder("SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.date_published w_datePublished, w.timevalue_published w_timeValuePublished, file.uuid f_uuid, file.uri f_uri, file.filename f_filename FROM works as w LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE w.label ->> :language IS NOT null AND w.label ->> :language ILIKE :initial || '%' ORDER BY w.label ->> :language");
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query.toString()).bind("language", language)).bind("initial", initial)).registerRowMapper(BeanMapper.factory(WorkImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Work work = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), uuid -> (Work)rowView.getRow(WorkImpl.class));
            if (rowView.getColumn("f_uuid", String.class) != null) {
                work.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String countQuery = "SELECT count(*) FROM works as w WHERE w.label ->> :language IS NOT null AND w.label ->> :language ILIKE :initial || '%'";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)((Query)h.createQuery(countQuery).bind("language", language)).bind("initial", initial)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public Work findOne(UUID uuid) {
        String query = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.date_published w_datePublished, w.timevalue_published w_timeValuePublished, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimetype, file.size_in_bytes f_size_in_bytes, file.uri f_uri FROM works as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE w.uuid = :uuid";
        WorkImpl result = (WorkImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(WorkImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WorkImpl work = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WorkImpl)rowView.getRow(WorkImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                work.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                work.addIdentifier((Identifier)identifier);
            }
            return map;
        }))).get(uuid);
        if (result != null) {
            List<Agent> creators = this.getCreators(uuid);
            result.setCreators(creators);
        }
        return result;
    }

    @Override
    public Work findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String query = "SELECT w.uuid w_uuid, w.refid w_refId, w.label w_label, w.description w_description, w.identifiable_type w_type, w.entity_type w_entityType, w.created w_created, w.last_modified w_lastModified, w.date_published w_datePublished, w.timevalue_published w_timeValuePublished, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimetype, file.size_in_bytes f_size_in_bytes, file.uri f_uri FROM works as w LEFT JOIN identifiers as id on w.uuid = id.identifiable LEFT JOIN fileresources_image as file on w.previewfileresource = file.uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        String identifierId = identifier.getId();
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(WorkImpl.class, (String)"w"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            WorkImpl work = map.computeIfAbsent((UUID)rowView.getColumn("w_uuid", UUID.class), fn -> (WorkImpl)rowView.getRow(WorkImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                work.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                work.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        }))).values().stream().findFirst();
        WorkImpl work = result.orElse(null);
        if (work != null) {
            work.setCreators(this.getCreators(work.getUuid()));
        }
        return work;
    }

    @Override
    public Work findOneByIdentifier(String namespace, String id) {
        return this.findOne((Identifier)new IdentifierImpl(null, namespace, id));
    }

    @Override
    public Work save(Work work) {
        work.setUuid(UUID.randomUUID());
        work.setCreated(LocalDateTime.now());
        work.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = work.getPreviewImage() == null ? null : work.getPreviewImage().getUuid();
        String query = "INSERT INTO works(uuid, label, description, previewfileresource, identifiable_type, entity_type, created, last_modified, date_published , timevalue_published) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :type, :entityType, :created, :lastModified, :datePublished, :timeValuePublished::JSONB)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)work)).execute());
        Set identifiers = work.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)work);
        List creators = work.getCreators();
        this.saveCreatorsList(work, creators);
        Work result = this.findOne(work.getUuid());
        return result;
    }

    @Override
    public Work update(Work work) {
        work.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = work.getPreviewImage() == null ? null : work.getPreviewImage().getUuid();
        String query = "UPDATE works SET label=:label::JSONB, description=:description::JSONB, previewfileresource=:previewFileResource, last_modified=:lastModified, date_published=:datePublished , timevalue_published=:timeValuePublished::JSONB WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)work)).execute());
        this.deleteIdentifiers((Identifiable)work);
        Set identifiers = work.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)work);
        List creators = work.getCreators();
        this.saveCreatorsList(work, creators);
        Work result = this.findOne(work.getUuid());
        return result;
    }

    public List<Agent> getCreators(UUID workUuid) {
        String query = "SELECT e.uuid e_uuid, e.label e_label, e.refid e_refId, e.entity_type e_entityType, e.created e_created, e.last_modified e_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimetype, file.size_in_bytes pf_size_in_bytes, file.uri pf_uri FROM entities as e LEFT JOIN identifiers as id on e.uuid = id.identifiable LEFT JOIN fileresources_image as file on e.previewfileresource = file.uuid LEFT JOIN work_creators as wc on e.uuid = wc.agent_uuid WHERE wc.work_uuid = :uuid ORDER BY wc.sortIndex ASC";
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)workUuid)).registerRowMapper(BeanMapper.factory(EntityImpl.class, (String)"e"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Entity entity = map.computeIfAbsent((UUID)rowView.getColumn("e_uuid", UUID.class), fn -> (Entity)rowView.getRow(EntityImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                entity.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                entity.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(entity -> {
            EntityType entityType = entity.getEntityType();
            switch (entityType) {
                case CORPORATE_BODY: {
                    CorporateBodyImpl corporateBody = new CorporateBodyImpl();
                    corporateBody.setLabel(entity.getLabel());
                    corporateBody.setRefId(entity.getRefId());
                    corporateBody.setUuid(entity.getUuid());
                    return corporateBody;
                }
                case FAMILY: {
                    FamilyImpl family = new FamilyImpl();
                    family.setLabel(entity.getLabel());
                    family.setRefId(entity.getRefId());
                    family.setUuid(entity.getUuid());
                    return family;
                }
                case PERSON: {
                    PersonImpl person = new PersonImpl();
                    person.setLabel(entity.getLabel());
                    person.setRefId(entity.getRefId());
                    person.setUuid(entity.getUuid());
                    return person;
                }
            }
            return null;
        }).collect(Collectors.toList()));
        return result;
    }

    public List<Item> getItems(UUID workUuid) {
        String query = "SELECT e.uuid e_uuid, e.label e_label, e.refid e_refId, e.created e_created, e.last_modified e_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimetype, file.size_in_bytes pf_size_in_bytes, file.uri pf_uri FROM entities as e LEFT JOIN identifiers as id on e.uuid = id.identifiable LEFT JOIN fileresources_image as file on e.previewfileresource = file.uuid LEFT JOIN item_works as iw on e.uuid = iw.item_uuid WHERE iw.work_uuid = :uuid ORDER BY iw.sortIndex ASC";
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)workUuid)).registerRowMapper(BeanMapper.factory(EntityImpl.class, (String)"e"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            Entity entity = map.computeIfAbsent((UUID)rowView.getColumn("e_uuid", UUID.class), fn -> (Entity)rowView.getRow(EntityImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                entity.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                entity.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(entity -> {
            ItemImpl item = new ItemImpl();
            item.setPreviewImage(entity.getPreviewImage());
            item.setLabel(entity.getLabel());
            item.setRefId(entity.getRefId());
            item.setUuid(entity.getUuid());
            return item;
        }).collect(Collectors.toList()));
        return result;
    }

    private void saveCreatorsList(Work work, List<Agent> creators) {
        UUID workUuid = work.getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM work_creators WHERE work_uuid = :uuid").bind("uuid", (Object)workUuid)).execute());
        if (creators != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO work_creators(work_uuid, agent_uuid, sortIndex) VALUES(:uuid, :agentUuid, :sortIndex)");
                for (Agent agent : creators) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)workUuid)).bind("agentUuid", (Object)agent.getUuid())).bind("sortIndex", this.getIndex(creators, (Identifiable)agent))).add();
                }
                preparedBatch.execute();
            });
        }
    }

    protected int getIndex(Set<? extends Identifiable> list, Identifiable identifiable) {
        int pos = -1;
        for (Identifiable identifiable2 : list) {
            ++pos;
            if (!identifiable2.getUuid().equals(identifiable.getUuid())) continue;
            return pos;
        }
        return -1;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "w.created";
            }
            case "lastModified": {
                return "w.last_modified";
            }
            case "refId": {
                return "w.refid";
            }
        }
        return null;
    }
}

