/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi;

import de.digitalcollections.cudami.server.backend.api.repository.PredicatesRepository;
import de.digitalcollections.model.api.relations.Predicate;
import de.digitalcollections.model.impl.relations.PredicateImpl;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PredicatesRepositoryImpl
implements PredicatesRepository {
    private final Jdbi dbi;

    @Autowired
    public PredicatesRepositoryImpl(Jdbi dbi) {
        this.dbi = dbi;
    }

    public Predicate findOne(String value) {
        String query = "SELECT * FROM predicates WHERE value = :value";
        Optional result = (Optional)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("value", value)).mapToBean(PredicateImpl.class).stream().map(Predicate.class::cast).findFirst());
        return result.orElse(null);
    }

    public List<Predicate> findAll() {
        String query = "SELECT * FROM predicates";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapToBean(PredicateImpl.class).stream().map(Predicate.class::cast).collect(Collectors.toList()));
        return result;
    }

    public Predicate save(Predicate predicate) {
        Predicate existingPredicate = this.findOne(predicate.getValue());
        if (existingPredicate != null) {
            predicate.setCreated(existingPredicate.getCreated());
        }
        predicate.setLastModified(LocalDateTime.now());
        if (existingPredicate != null) {
            String updateQuery = "UPDATE predicates SET label=:label::JSONB, description=:description::JSONB, last_modified=:lastModified WHERE value=:value";
            this.dbi.withHandle(h -> ((Update)h.createUpdate(updateQuery).bindBean((Object)predicate)).execute());
        } else {
            predicate.setCreated(predicate.getLastModified());
            String createQuery = "INSERT INTO predicates(value, label, description, created, last_modified) VALUES (:value, :label::JSONB, :description::JSONB, :created, :lastModified)";
            this.dbi.withHandle(h -> ((Update)h.createUpdate(createQuery).bindBean((Object)predicate)).execute());
        }
        return this.findOne(predicate.getValue());
    }
}

