/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.FileResourceMetadataRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.identifiable.entity.ProjectImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.paging.SearchPageResponseImpl;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectRepositoryImpl
extends EntityRepositoryImpl<DigitalObject>
implements DigitalObjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectRepositoryImpl.class);
    private static final String FIND_ONE_BASE_SQL = "SELECT d.uuid d_uuid, d.refid d_refId, d.label d_label, d.description d_description, d.identifiable_type d_type, d.entity_type d_entityType, d.created d_created, d.last_modified d_lastModified, d.preview_hints d_previewImageRenderingHints, d.custom_attrs d_customAttributes, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl, fr.uuid fr_uuid, fr.filename fr_filename, fr.mimetype fr_mimetype, fr.size_in_bytes fr_sizeInBytes, fr.uri fr_uri FROM digitalobjects as d LEFT JOIN identifiers as id on d.uuid = id.identifiable LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid LEFT JOIN digitalobject_fileresources as df on d.uuid = df.digitalobject_uuid LEFT JOIN fileresources as fr on fr.uuid = df.fileresource_uuid";
    private static final String REDUCED_FIND_ONE_BASE_SQL = "SELECT d.uuid d_uuid, d.refid d_refId, d.label d_label, d.description d_description, d.identifiable_type d_type, d.entity_type d_entityType, d.created d_created, d.last_modified d_lastModified, d.preview_hints d_previewImageRenderingHints, d.custom_attrs d_customAttributes, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM digitalobjects as d LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid";
    private final FileResourceMetadataRepository fileResourceMetadataRepository;

    @Autowired
    public DigitalObjectRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, FileResourceMetadataRepository fileResourceMetadataRepository) {
        super(dbi, identifierRepository);
        this.fileResourceMetadataRepository = fileResourceMetadataRepository;
    }

    @Override
    public long count() {
        String sql = "SELECT count(*) FROM digitalobjects";
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    @Override
    public PageResponse<DigitalObject> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder(REDUCED_FIND_ONE_BASE_SQL);
        this.addPageRequestParams(pageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)h.createQuery(query.toString()).registerRowMapper(BeanMapper.factory(DigitalObjectImpl.class, (String)"d"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            DigitalObjectImpl digitalObject = map.computeIfAbsent((UUID)rowView.getColumn("d_uuid", UUID.class), fn -> (DigitalObjectImpl)rowView.getRow(DigitalObjectImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                digitalObject.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        long total = this.count();
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public SearchPageResponse<DigitalObject> find(SearchPageRequest searchPageRequest) {
        StringBuilder query = new StringBuilder("SELECT d.uuid d_uuid, d.refid d_refId, d.label d_label, d.description d_description, d.entity_type d_entityType, d.custom_attrs d_customAttributes, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl FROM digitalobjects as d LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid LEFT JOIN LATERAL jsonb_object_keys(d.label) l(keys) on d.label is not null WHERE (d.label->>l.keys ILIKE '%' || :searchTerm || '%')");
        this.addPageRequestParams((PageRequest)searchPageRequest, query);
        ArrayList result = new ArrayList((Collection)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)h.createQuery(query.toString()).bind("searchTerm", searchPageRequest.getQuery())).registerRowMapper(BeanMapper.factory(DigitalObjectImpl.class, (String)"d"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            DigitalObject digitalObject = map.computeIfAbsent((UUID)rowView.getColumn("d_uuid", UUID.class), uuid -> (DigitalObject)rowView.getRow(DigitalObjectImpl.class));
            if (rowView.getColumn("f_uuid", String.class) != null) {
                digitalObject.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            return map;
        })).values()));
        String countQuery = "SELECT count(*) FROM digitalobjects as d LEFT JOIN LATERAL jsonb_object_keys(d.label) l(keys) on d.label is not null WHERE (d.label->>l.keys ILIKE '%' || :searchTerm || '%')";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery).bind("searchTerm", searchPageRequest.getQuery())).mapTo(Long.class).findOne().get());
        SearchPageResponseImpl pageResponse = new SearchPageResponseImpl(result, searchPageRequest, total);
        return pageResponse;
    }

    public DigitalObject findByIdentifier(String namespace, String id) {
        return this.findOne((Identifier)new IdentifierImpl(null, namespace, id));
    }

    @Override
    public DigitalObject findOne(UUID uuid) {
        String query = "SELECT d.uuid d_uuid, d.refid d_refId, d.label d_label, d.description d_description, d.identifiable_type d_type, d.entity_type d_entityType, d.created d_created, d.last_modified d_lastModified, d.preview_hints d_previewImageRenderingHints, d.custom_attrs d_customAttributes, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl, fr.uuid fr_uuid, fr.filename fr_filename, fr.mimetype fr_mimetype, fr.size_in_bytes fr_sizeInBytes, fr.uri fr_uri FROM digitalobjects as d LEFT JOIN identifiers as id on d.uuid = id.identifiable LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid LEFT JOIN digitalobject_fileresources as df on d.uuid = df.digitalobject_uuid LEFT JOIN fileresources as fr on fr.uuid = df.fileresource_uuid WHERE d.uuid = :uuid";
        DigitalObjectImpl result = (DigitalObjectImpl)((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)uuid)).registerRowMapper(BeanMapper.factory(DigitalObjectImpl.class, (String)"d"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"fr"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            DigitalObjectImpl digitalObject = map.computeIfAbsent((UUID)rowView.getColumn("d_uuid", UUID.class), fn -> (DigitalObjectImpl)rowView.getRow(DigitalObjectImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                digitalObject.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl identifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                digitalObject.addIdentifier((Identifier)identifier);
            }
            if (rowView.getColumn("fr_uuid", UUID.class) != null) {
                FileResourceImpl fileResource = (FileResourceImpl)rowView.getRow(FileResourceImpl.class);
                if (!digitalObject.getFileResources().contains(fileResource)) {
                    digitalObject.getFileResources().add(fileResource);
                }
            }
            return map;
        }))).get(uuid);
        return result;
    }

    @Override
    public DigitalObject findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        String query = "SELECT d.uuid d_uuid, d.refid d_refId, d.label d_label, d.description d_description, d.identifiable_type d_type, d.entity_type d_entityType, d.created d_created, d.last_modified d_lastModified, d.preview_hints d_previewImageRenderingHints, d.custom_attrs d_customAttributes, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid f_uuid, file.filename f_filename, file.mimetype f_mimeType, file.size_in_bytes f_sizeInBytes, file.uri f_uri, file.http_base_url f_httpBaseUrl, fr.uuid fr_uuid, fr.filename fr_filename, fr.mimetype fr_mimetype, fr.size_in_bytes fr_sizeInBytes, fr.uri fr_uri FROM digitalobjects as d LEFT JOIN identifiers as id on d.uuid = id.identifiable LEFT JOIN fileresources_image as file on d.previewfileresource = file.uuid LEFT JOIN digitalobject_fileresources as df on d.uuid = df.digitalobject_uuid LEFT JOIN fileresources as fr on fr.uuid = df.fileresource_uuid WHERE id.identifier = :id AND id.namespace = :namespace";
        Optional result = ((LinkedHashMap)this.dbi.withHandle(h -> (LinkedHashMap)((Query)((Query)((Query)((Query)((Query)((Query)h.createQuery(query).bind("id", identifierId)).bind("namespace", namespace)).registerRowMapper(BeanMapper.factory(DigitalObjectImpl.class, (String)"d"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"fr"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            DigitalObjectImpl digitalObject = map.computeIfAbsent((UUID)rowView.getColumn("d_uuid", UUID.class), fn -> (DigitalObjectImpl)rowView.getRow(DigitalObjectImpl.class));
            if (rowView.getColumn("f_uuid", UUID.class) != null) {
                digitalObject.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIidentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                digitalObject.addIdentifier((Identifier)dbIidentifier);
            }
            if (rowView.getColumn("fr_uuid", UUID.class) != null) {
                FileResourceImpl fileResource = (FileResourceImpl)rowView.getRow(FileResourceImpl.class);
                if (!digitalObject.getFileResources().contains(fileResource)) {
                    digitalObject.getFileResources().add(fileResource);
                }
            }
            return map;
        }))).values().stream().findFirst();
        return result.orElse(null);
    }

    public PageResponse<de.digitalcollections.model.api.identifiable.entity.Collection> getCollections(UUID digitalObjectUuid, PageRequest pageRequest) {
        String baseQuery = "SELECT c.uuid c_uuid, c.label c_label, c.refid c_refId, c.created c_created, c.last_modified c_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM collections as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid LEFT JOIN collection_digitalobjects as cd on c.uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid";
        StringBuilder query = new StringBuilder("SELECT c.uuid c_uuid, c.label c_label, c.refid c_refId, c.created c_created, c.last_modified c_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM collections as c LEFT JOIN identifiers as id on c.uuid = id.identifiable LEFT JOIN fileresources_image as file on c.previewfileresource = file.uuid LEFT JOIN collection_digitalobjects as cd on c.uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid");
        String filterClauses = this.getFilterClauses(pageRequest.getFiltering());
        if (!filterClauses.isEmpty()) {
            query.append(" AND ").append(filterClauses);
        }
        query.append(" ORDER BY c.label");
        pageRequest.setSorting(null);
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)digitalObjectUuid)).registerRowMapper(BeanMapper.factory(CollectionImpl.class, (String)"c"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            CollectionImpl collection = map.computeIfAbsent((UUID)rowView.getColumn("c_uuid", UUID.class), fn -> (CollectionImpl)rowView.getRow(CollectionImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                collection.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                collection.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(de.digitalcollections.model.api.identifiable.entity.Collection.class::cast).collect(Collectors.toList()));
        Object countQuery = "SELECT count(*) FROM collections as c LEFT JOIN collection_digitalobjects as cd on c.uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid";
        if (!filterClauses.isEmpty()) {
            countQuery = (String)countQuery + " AND " + filterClauses;
        }
        String sqlCount = countQuery;
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount).bind("uuid", (Object)digitalObjectUuid)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    public List<FileResource> getFileResources(UUID digitalObjectUuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimeType, f.size_in_bytes f_sizeInBytes, f.uri f_uri, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM fileresources as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid LEFT JOIN digitalobject_fileresources as df on f.uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY df.sortIndex ASC";
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)digitalObjectUuid)).registerRowMapper(BeanMapper.factory(FileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            FileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (FileResourceImpl)rowView.getRow(FileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(FileResource.class::cast).collect(Collectors.toList()));
        return result;
    }

    public List<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) {
        String query = "SELECT f.uuid f_uuid, f.label f_label, f.created f_created, f.last_modified f_lastModified, f.filename f_filename, f.mimetype f_mimeType, f.size_in_bytes f_sizeInBytes, f.uri f_uri, f.height f_height, f.width f_width, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM fileresources_image as f LEFT JOIN identifiers as id on f.uuid = id.identifiable LEFT JOIN fileresources_image as file on f.previewfileresource = file.uuid LEFT JOIN digitalobject_fileresources as df on f.uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY df.sortIndex ASC";
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query).bind("uuid", (Object)digitalObjectUuid)).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"f"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ImageFileResourceImpl fileResource = map.computeIfAbsent((UUID)rowView.getColumn("f_uuid", UUID.class), fn -> (ImageFileResourceImpl)rowView.getRow(ImageFileResourceImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                fileResource.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                fileResource.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(ImageFileResource.class::cast).collect(Collectors.toList()));
        return result;
    }

    public PageResponse<Project> getProjects(UUID digitalObjectUuid, PageRequest pageRequest) {
        String baseQuery = "SELECT p.uuid p_uuid, p.label p_label, p.refid p_refId, p.created p_created, p.last_modified p_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM projects as p LEFT JOIN identifiers as id on p.uuid = id.identifiable LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid LEFT JOIN project_digitalobjects as pd on p.uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid ORDER BY p.label";
        StringBuilder query = new StringBuilder("SELECT p.uuid p_uuid, p.label p_label, p.refid p_refId, p.created p_created, p.last_modified p_lastModified, id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pf_uuid, file.filename pf_filename, file.mimetype pf_mimeType, file.size_in_bytes pf_sizeInBytes, file.uri pf_uri, file.http_base_url pf_httpBaseUrl FROM projects as p LEFT JOIN identifiers as id on p.uuid = id.identifiable LEFT JOIN fileresources_image as file on p.previewfileresource = file.uuid LEFT JOIN project_digitalobjects as pd on p.uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid ORDER BY p.label");
        pageRequest.setSorting(null);
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((LinkedHashMap)((Query)((Query)((Query)((Query)h.createQuery(query.toString()).bind("uuid", (Object)digitalObjectUuid)).registerRowMapper(BeanMapper.factory(ProjectImpl.class, (String)"p"))).registerRowMapper(BeanMapper.factory(IdentifierImpl.class, (String)"id"))).registerRowMapper(BeanMapper.factory(ImageFileResourceImpl.class, (String)"pf"))).reduceRows(new LinkedHashMap(), (map, rowView) -> {
            ProjectImpl project = map.computeIfAbsent((UUID)rowView.getColumn("p_uuid", UUID.class), fn -> (ProjectImpl)rowView.getRow(ProjectImpl.class));
            if (rowView.getColumn("pf_uuid", UUID.class) != null) {
                project.setPreviewImage((ImageFileResource)rowView.getRow(ImageFileResourceImpl.class));
            }
            if (rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                project.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        })).values().stream().map(Project.class::cast).collect(Collectors.toList()));
        String countQuery = "SELECT count(*) FROM projects as p LEFT JOIN project_digitalobjects as pd on p.uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid";
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(countQuery).bind("uuid", (Object)digitalObjectUuid)).mapTo(Long.class).findOne().get());
        PageResponseImpl pageResponse = new PageResponseImpl(result, pageRequest, total);
        return pageResponse;
    }

    @Override
    public DigitalObject save(DigitalObject digitalObject) {
        digitalObject.setUuid(UUID.randomUUID());
        digitalObject.setCreated(LocalDateTime.now());
        digitalObject.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = digitalObject.getPreviewImage() == null ? null : digitalObject.getPreviewImage().getUuid();
        String query = "INSERT INTO digitalobjects(uuid, label, description, previewFileResource, preview_hints, custom_attrs, identifiable_type, entity_type, created, last_modified) VALUES (:uuid, :label::JSONB, :description::JSONB, :previewFileResource, :previewImageRenderingHints::JSONB, :customAttributes::JSONB, :type, :entityType, :created, :lastModified)";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)digitalObject)).execute());
        List fileResources = digitalObject.getFileResources();
        this.saveFileResources(digitalObject, (List<FileResource>)fileResources);
        Set identifiers = digitalObject.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)digitalObject);
        DigitalObject result = this.findOne(digitalObject.getUuid());
        return result;
    }

    public List<FileResource> saveFileResources(DigitalObject digitalObject, List<FileResource> fileResources) {
        if (fileResources == null) {
            return null;
        }
        return this.saveFileResources(digitalObject.getUuid(), fileResources);
    }

    public List<FileResource> saveFileResources(UUID digitalObjectUuid, List<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", (Object)digitalObjectUuid)).execute());
        if (fileResources != null) {
            for (FileResource fileResource : fileResources) {
                if (fileResource.getUuid() != null) continue;
                fileResource = (FileResource)this.fileResourceMetadataRepository.save((Identifiable)fileResource);
            }
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO digitalobject_fileresources(digitalobject_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", (Object)digitalObjectUuid)).bind("fileResourceUuid", (Object)fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(digitalObjectUuid);
    }

    public void deleteFileResources(UUID digitalObjectUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", (Object)digitalObjectUuid)).execute());
    }

    @Override
    public DigitalObject update(DigitalObject digitalObject) {
        digitalObject.setLastModified(LocalDateTime.now());
        UUID previewImageUuid = digitalObject.getPreviewImage() == null ? null : digitalObject.getPreviewImage().getUuid();
        String query = "UPDATE digitalobjects SET label=:label::JSONB, description=:description::JSONB, previewFileResource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, custom_attrs=:customAttributes::JSONB, last_modified=:lastModified WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("previewFileResource", (Object)previewImageUuid)).bindBean((Object)digitalObject)).execute());
        this.deleteIdentifiers((Identifiable)digitalObject);
        Set identifiers = digitalObject.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)digitalObject);
        DigitalObject result = this.findOne(digitalObject.getUuid());
        return result;
    }

    @Override
    protected String[] getAllowedOrderByFields() {
        return new String[]{"created", "lastModified", "refId"};
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return "d.created";
            }
            case "lastModified": {
                return "d.last_modified";
            }
            case "publicationEnd": {
                return "c.publication_end";
            }
            case "publicationStart": {
                return "c.publication_start";
            }
            case "refId": {
                return "d.refid";
            }
        }
        return null;
    }

    public boolean deleteIdentifiers(UUID digitalObjectUuid) {
        DigitalObject digitalObject = this.findOne(digitalObjectUuid);
        if (digitalObject == null) {
            return false;
        }
        this.identifierRepository.delete(digitalObject.getIdentifiers().stream().map(Identifier::getUuid).collect(Collectors.toList()));
        return true;
    }
}

