/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.CorporateBodyRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterCriterion;
import de.digitalcollections.model.api.filter.FilterValuePlaceholder;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.NodeImpl;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.view.BreadcrumbNavigationImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class CollectionRepositoryImpl
extends EntityRepositoryImpl<Collection>
implements CollectionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "col";
    public static final String TABLE_ALIAS = "c";
    public static final String TABLE_NAME = "collections";
    @Lazy
    @Autowired
    private CorporateBodyRepositoryImpl corporateBodyRepositoryImpl;
    @Lazy
    @Autowired
    private DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", publication_end, publication_start, text";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :publicationEnd, :publicationStart, :text::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return CollectionRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".publication_start " + mappingPrefix + "_publicationStart, " + tableAlias + ".publication_end " + mappingPrefix + "_publicationEnd";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", publication_end=:publicationEnd, publication_start=:publicationStart, text=:text::JSONB";
    }

    @Autowired
    public CollectionRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, CollectionImpl.class, CollectionRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), CollectionRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), CollectionRepositoryImpl.getSqlInsertFields(), CollectionRepositoryImpl.getSqlInsertValues(), CollectionRepositoryImpl.getSqlUpdateFieldValues());
    }

    public boolean addChildren(UUID parentUuid, List<Collection> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortIndex) VALUES (:parentCollectionUuid, :childCollectionUuid, :sortIndex) ON CONFLICT (parent_collection_uuid, child_collection_uuid) DO NOTHING");
            children.forEach(child -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentCollectionUuid", parentUuid)).bind("childCollectionUuid", child.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(children, (Identifiable)child))).add());
            preparedBatch.execute();
        });
        return true;
    }

    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        if (collectionUuid != null && digitalObjects != null) {
            Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_digitalobjects", "collection_uuid", collectionUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex) ON CONFLICT (collection_uuid, digitalobject_uuid) DO NOTHING");
                digitalObjects.forEach(digitalObject -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", collectionUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(digitalObjects, (Identifiable)digitalObject))).add());
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    @Override
    public Collection findOne(UUID uuid, Filtering filtering) {
        Collection collection = (Collection)super.findOne(uuid, filtering);
        if (collection != null) {
            collection.setChildren(this.getChildren(collection));
        }
        return collection;
    }

    @Override
    public Collection findOne(Identifier identifier) {
        Collection collection = (Collection)super.findOne(identifier);
        if (collection != null) {
            collection.setChildren(this.getChildren(collection));
        }
        return collection;
    }

    @Override
    public Collection findOneByRefId(long refId) {
        Collection collection = (Collection)super.findOneByRefId(refId);
        if (collection != null) {
            collection.setChildren(this.getChildren(collection));
        }
        return collection;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("publicationEnd", "publicationStart"));
        return allowedOrderByFields;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery("WITH recursive breadcrumb (uuid,label,parent_uuid,depth) AS (        SELECT c.uuid AS uuid, c.label AS label, c.refid c_refId, cc.parent_collection_uuid AS parent_uuid, 99 AS depth        FROM collections c, collection_collections cc        WHERE uuid= :uuid and cc.child_collection_uuid = c.uuid        UNION ALL        SELECT c.uuid AS uuid, c.label AS label, c.refid c_refId, cc.parent_collection_uuid AS parent_uuid, depth-1 AS depth        FROM collections c,             collection_collections cc,             breadcrumb b        WHERE b.uuid = cc.child_collection_uuid AND cc.parent_collection_uuid = c.uuid AND cc.parent_collection_uuid IS NOT null    ) SELECT * FROM breadcrumb ORDER BY depth ASC").bind("uuid", nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).map(Node.class::cast).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery("SELECT c.uuid AS uuid, c.label AS label        FROM collections c        WHERE uuid= :uuid").bind("uuid", nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).map(Node.class::cast).list());
        }
        return new BreadcrumbNavigationImpl(result);
    }

    public List<Collection> getChildren(Collection collection) {
        return super.getChildren((Node)collection);
    }

    public List<Collection> getChildren(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid ORDER BY cc.sortIndex ASC");
        List<Collection> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid));
        return result;
    }

    public PageResponse<Collection> getChildren(UUID uuid, PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid";
        StringBuilder innerQuery = new StringBuilder("SELECT *" + commonSql);
        this.addFiltering(pageRequest, innerQuery);
        pageRequest.setSorting(null);
        innerQuery.append(" ORDER BY cc.sortIndex ASC");
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery);
        long total = this.retrieveCount(countQuery, Map.of("uuid", uuid));
        return new PageResponseImpl(result, pageRequest, total);
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "publicationEnd": {
                return this.tableAlias + ".publication_end";
            }
            case "publicationStart": {
                return this.tableAlias + ".publication_start";
            }
        }
        return null;
    }

    public PageResponse<DigitalObject> getDigitalObjects(UUID collectionUuid, PageRequest pageRequest) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        String commonSql = " FROM " + doTableName + " AS " + doTableAlias + " LEFT JOIN collection_digitalobjects AS cd ON " + doTableAlias + ".uuid = cd.digitalobject_uuid WHERE cd.collection_uuid = :uuid";
        StringBuilder innerQuery = new StringBuilder("SELECT *" + commonSql);
        this.addFiltering(pageRequest, innerQuery);
        pageRequest.setSorting(null);
        innerQuery.append(" ORDER BY cd.sortIndex ASC");
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", collectionUuid));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery);
        long total = this.retrieveCount(countQuery, Map.of("uuid", collectionUuid));
        return new PageResponseImpl(result, pageRequest, total);
    }

    public Collection getParent(UUID uuid) {
        String sqlAdditionalJoins = " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.parent_collection_uuid";
        Filtering filtering = Filtering.defaultBuilder().filter("cc.child_collection_uuid").isEquals((Object)new FilterValuePlaceholder(":uuid")).build();
        Collection result = (Collection)this.retrieveOne(this.sqlSelectReducedFields, sqlAdditionalJoins, filtering, Map.of("uuid", uuid));
        return result;
    }

    public List<Collection> getParents(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.parent_collection_uuid WHERE cc.child_collection_uuid = :uuid");
        List<Collection> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid));
        return result;
    }

    public List<CorporateBody> getRelatedCorporateBodies(UUID uuid, Filtering filtering) {
        String cbTableAlias = this.corporateBodyRepositoryImpl.getTableAlias();
        String cbTableName = this.corporateBodyRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + cbTableName + " AS " + cbTableAlias + " LEFT JOIN rel_entity_entities AS r ON " + cbTableAlias + ".uuid = r.object_uuid LEFT JOIN rel_entity_entities AS rel ON r.subject_uuid = rel.subject_uuid WHERE rel.object_uuid = :uuid AND rel.predicate = 'is_part_of'");
        FilterCriterion predicate = filtering.getFilterCriterionFor("predicate");
        if (predicate != null) {
            String predicateFilter = String.format(" AND r.predicate = '%s'", predicate.getValue());
            innerQuery.append(predicateFilter);
        }
        List<CorporateBody> result = this.corporateBodyRepositoryImpl.retrieveList(this.corporateBodyRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", uuid));
        return result;
    }

    public PageResponse<Collection> getRootNodes(PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql, null);
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT languages FROM " + this.tableName + " AS " + this.tableAlias + ", jsonb_object_keys(" + this.tableAlias + ".label) AS languages WHERE NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String sql = "DELETE FROM collection_collections WHERE parent_collection_uuid=:parentCollectionUuid AND child_collection_uuid=:childCollectionUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM collection_collections WHERE parent_collection_uuid=:parentCollectionUuid AND child_collection_uuid=:childCollectionUuid").bind("parentCollectionUuid", parentUuid)).bind("childCollectionUuid", childUuid)).execute());
        return true;
    }

    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) {
        if (collectionUuid != null && digitalObjectUuid != null) {
            String sql = "DELETE FROM collection_digitalobjects WHERE collection_uuid=:collectionUuid AND digitalobject_uuid=:digitalObjectUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE collection_uuid=:collectionUuid AND digitalobject_uuid=:digitalObjectUuid").bind("collectionUuid", collectionUuid)).bind("digitalObjectUuid", digitalObjectUuid)).execute());
            return true;
        }
        return false;
    }

    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) {
        if (digitalObject == null) {
            return false;
        }
        String sql = "DELETE FROM collection_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid";
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid").bind("digitalObjectUuid", digitalObject.getUuid())).execute());
        return true;
    }

    public Collection save(Collection collection) {
        super.save((Identifiable)collection);
        Collection result = (Collection)this.findOne(collection.getUuid());
        return result;
    }

    public boolean saveDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE collection_uuid = :uuid").bind("uuid", collectionUuid)).execute());
        if (digitalObjects != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex)");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", collectionUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public Collection saveWithParent(Collection collection, UUID parentUuid) {
        UUID childUuid = collection.getUuid() == null ? this.save(collection).getUuid() : collection.getUuid();
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortindex) VALUES (:parent_collection_uuid, :child_collection_uuid, :sortindex)").bind("parent_collection_uuid", parentUuid)).bind("child_collection_uuid", childUuid)).bind("sortindex", nextSortIndex)).execute());
        return (Collection)this.findOne(childUuid);
    }

    public Collection update(Collection collection) {
        super.update((Identifiable)collection);
        Collection result = (Collection)this.findOne(collection.getUuid());
        return result;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<Collection> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        String query = "UPDATE collection_collections SET sortindex = :idx WHERE child_collection_uuid = :childUuid AND parent_collection_uuid = :parentUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Collection collection : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childUuid", collection.getUuid())).bind("parentUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

