/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work.WorkRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.ItemRepositoryImpl;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.agent.Agent;
import de.digitalcollections.model.api.identifiable.entity.work.Item;
import de.digitalcollections.model.api.identifiable.entity.work.Work;
import de.digitalcollections.model.impl.identifiable.entity.work.WorkImpl;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WorkRepositoryImpl
extends EntityRepositoryImpl<Work>
implements WorkRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WorkRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "wo";
    public static final String TABLE_ALIAS = "w";
    public static final String TABLE_NAME = "works";
    private final AgentRepositoryImpl agentRepositoryImpl;
    private final ItemRepositoryImpl itemRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", date_published, timevalue_published";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :datePublished, :timeValuePublished::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return WorkRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".date_published " + mappingPrefix + "_datePublished, " + tableAlias + ".timevalue_published " + mappingPrefix + "_timeValuePublished";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", date_published=:datePublished, timevalue_published=:timeValuePublished::JSONB";
    }

    @Autowired
    public WorkRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, AgentRepositoryImpl agentRepositoryImpl, ItemRepositoryImpl itemRepositoryImpl) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, WorkImpl.class, WorkRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), WorkRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), WorkRepositoryImpl.getSqlInsertFields(), WorkRepositoryImpl.getSqlInsertValues(), WorkRepositoryImpl.getSqlUpdateFieldValues());
        this.agentRepositoryImpl = agentRepositoryImpl;
        this.itemRepositoryImpl = itemRepositoryImpl;
    }

    @Override
    public Work findOne(UUID uuid, Filtering filtering) {
        Work work = (Work)super.findOne(uuid, filtering);
        if (work != null) {
            List<Agent> creators = this.getCreators(uuid);
            work.setCreators(creators);
        }
        return work;
    }

    @Override
    public Work findOne(Identifier identifier) {
        Work work = (Work)super.findOne(identifier);
        if (work != null) {
            List<Agent> creators = this.getCreators(work.getUuid());
            work.setCreators(creators);
        }
        return work;
    }

    public List<Agent> getCreators(UUID workUuid) {
        String agTableAlias = this.agentRepositoryImpl.getTableAlias();
        String agTableName = this.agentRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + agTableName + " AS " + agTableAlias + " LEFT JOIN work_creators AS wc ON " + agTableAlias + ".uuid = wc.agent_uuid WHERE wc.work_uuid = :uuid ORDER BY wc.sortIndex ASC");
        List<Agent> result = this.agentRepositoryImpl.retrieveList(this.agentRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", workUuid));
        return result;
    }

    public List<Item> getItems(UUID workUuid) {
        String itTableAlias = this.itemRepositoryImpl.getTableAlias();
        String itTableName = this.itemRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + itTableName + " AS " + itTableAlias + " LEFT JOIN item_works AS iw ON " + itTableAlias + ".uuid = iw.item_uuid WHERE iw.work_uuid = :uuid ORDER BY iw.sortIndex ASC");
        List<Item> result = this.itemRepositoryImpl.retrieveList(this.itemRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", workUuid));
        return result;
    }

    public Work save(Work work) {
        super.save((Identifiable)work);
        List creators = work.getCreators();
        this.saveCreatorsList(work, creators);
        Work result = (Work)this.findOne(work.getUuid());
        return result;
    }

    private void saveCreatorsList(Work work, List<Agent> creators) {
        UUID workUuid = work.getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM work_creators WHERE work_uuid = :uuid").bind("uuid", workUuid)).execute());
        if (creators != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO work_creators(work_uuid, agent_uuid, sortIndex) VALUES(:uuid, :agentUuid, :sortIndex)");
                for (Agent agent : creators) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", workUuid)).bind("agentUuid", agent.getUuid())).bind("sortIndex", this.getIndex(creators, (Identifiable)agent))).add();
                }
                preparedBatch.execute();
            });
        }
    }

    public Work update(Work work) {
        super.update((Identifiable)work);
        List creators = work.getCreators();
        this.saveCreatorsList(work, creators);
        Work result = (Work)this.findOne(work.getUuid());
        return result;
    }
}

