/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterValuePlaceholder;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.identifiable.resource.MimeType;
import de.digitalcollections.model.api.paging.Order;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.paging.Sorting;
import de.digitalcollections.model.api.paging.enums.Direction;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.model.impl.identifiable.IdentifierImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.paging.SearchPageResponseImpl;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class IdentifiableRepositoryImpl<I extends Identifiable>
extends JdbiRepositoryImpl
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "idf";
    public static final String TABLE_ALIAS = "i";
    public static final String TABLE_NAME = "identifiables";
    public BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> additionalReduceRowsBiFunction = (map, rowView) -> map;
    public final BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> basicReduceRowsBiFunction;
    public final BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> fullReduceRowsBiFunction;
    protected final Class identifiableImplClass;
    protected final IdentifierRepository identifierRepository;
    private final String sqlInsertFields;
    private final String sqlInsertValues;
    protected String sqlSelectAllFields;
    protected final String sqlSelectAllFieldsJoins;
    protected String sqlSelectReducedFields;
    private final String sqlUpdateFieldValues;

    public static String getSqlInsertFields() {
        return " uuid, created, description, identifiable_type, label, last_modified, previewfileresource, preview_hints";
    }

    public static String getSqlInsertValues() {
        return " :uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :previewFileResource, :previewImageRenderingHints::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return IdentifiableRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return " " + tableAlias + ".uuid " + mappingPrefix + "_uuid, " + tableAlias + ".created " + mappingPrefix + "_created, " + tableAlias + ".description " + mappingPrefix + "_description, " + tableAlias + ".identifiable_type " + mappingPrefix + "_type, " + tableAlias + ".label " + mappingPrefix + "_label, " + tableAlias + ".last_modified " + mappingPrefix + "_lastModified, " + tableAlias + ".preview_hints " + mappingPrefix + "_previewImageRenderingHints";
    }

    public static String getSqlUpdateFieldValues() {
        return " description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB";
    }

    @Autowired
    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        this(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, IdentifiableImpl.class, IdentifiableRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), IdentifiableRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), IdentifiableRepositoryImpl.getSqlInsertFields(), IdentifiableRepositoryImpl.getSqlInsertValues(), IdentifiableRepositoryImpl.getSqlUpdateFieldValues());
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues) {
        this(dbi, identifierRepository, tableName, tableAlias, mappingPrefix, identifiableImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, null);
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins) {
        this(dbi, identifierRepository, tableName, tableAlias, mappingPrefix, identifiableImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, sqlSelectAllFieldsJoins, null);
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins, BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> additionalReduceRowsBiFunction) {
        super(dbi, tableName, tableAlias, mappingPrefix);
        dbi.registerRowMapper(BeanMapper.factory((Class)identifiableImplClass, (String)mappingPrefix));
        this.basicReduceRowsBiFunction = this.createReduceRowsBiFunction(true, true);
        this.fullReduceRowsBiFunction = this.createReduceRowsBiFunction(true, true);
        if (additionalReduceRowsBiFunction != null) {
            this.additionalReduceRowsBiFunction = additionalReduceRowsBiFunction;
        }
        this.identifiableImplClass = identifiableImplClass;
        this.identifierRepository = identifierRepository;
        this.sqlInsertFields = sqlInsertFields;
        this.sqlInsertValues = sqlInsertValues;
        this.sqlSelectAllFields = sqlSelectAllFields;
        this.sqlSelectAllFieldsJoins = sqlSelectAllFieldsJoins;
        this.sqlSelectReducedFields = sqlSelectReducedFields;
        this.sqlUpdateFieldValues = sqlUpdateFieldValues;
    }

    private BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> createReduceRowsBiFunction(boolean withIdentifiers, boolean withPreviewImage) {
        return (map, rowView) -> {
            Identifiable identifiable = map.computeIfAbsent((UUID)rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class), fn -> (Identifiable)rowView.getRow(this.identifiableImplClass));
            if (withPreviewImage && rowView.getColumn("pi_uuid", UUID.class) != null) {
                ImageFileResourceImpl previewImage = new ImageFileResourceImpl();
                previewImage.setUuid((UUID)rowView.getColumn("pi_uuid", UUID.class));
                previewImage.setFilename((String)rowView.getColumn("pi_filename", String.class));
                previewImage.setHttpBaseUrl((URL)rowView.getColumn("pi_httpBaseUrl", URL.class));
                previewImage.setMimeType((MimeType)rowView.getColumn("pi_mimeType", MimeType.class));
                previewImage.setUri((URI)rowView.getColumn("pi_uri", URI.class));
                identifiable.setPreviewImage((ImageFileResource)previewImage);
            }
            if (withIdentifiers && rowView.getColumn("id_uuid", UUID.class) != null) {
                IdentifierImpl dbIdentifier = (IdentifierImpl)rowView.getRow(IdentifierImpl.class);
                identifiable.addIdentifier((Identifier)dbIdentifier);
            }
            return map;
        };
    }

    public boolean delete(List<UUID> uuids) {
        uuids.stream().forEach(u -> this.deleteIdentifiers((UUID)u));
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
        return true;
    }

    public boolean deleteIdentifiers(UUID identifiableUuid) {
        Identifiable identifiable = this.findOne(identifiableUuid);
        if (identifiable == null) {
            return false;
        }
        this.identifierRepository.delete(identifiable.getIdentifiers().stream().map(Identifier::getUuid).collect(Collectors.toList()));
        return true;
    }

    public PageResponse<I> find(PageRequest pageRequest) {
        return this.find(pageRequest, null, null);
    }

    protected PageResponse<I> find(PageRequest pageRequest, String commonSql, Map<String, Object> argumentMappings) {
        if (commonSql == null) {
            commonSql = " FROM " + this.tableName + " AS " + this.tableAlias;
        }
        StringBuilder innerQuery = new StringBuilder("SELECT *" + (String)commonSql);
        this.addFiltering(pageRequest, innerQuery);
        this.addPageRequestParams(pageRequest, innerQuery);
        Object orderBy = this.getOrderBy(pageRequest.getSorting());
        if (StringUtils.hasText((String)orderBy)) {
            orderBy = " ORDER BY " + (String)orderBy;
        }
        List<I> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, (String)orderBy);
        StringBuilder sqlCount = new StringBuilder("SELECT count(*)" + (String)commonSql);
        this.addFiltering(pageRequest, sqlCount);
        long total = this.retrieveCount(sqlCount, argumentMappings);
        return new PageResponseImpl(result, pageRequest, total);
    }

    public SearchPageResponse<I> find(SearchPageRequest searchPageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " LEFT JOIN LATERAL jsonb_object_keys(" + this.tableAlias + ".label) lbl(keys) ON " + this.tableAlias + ".label IS NOT NULL LEFT JOIN LATERAL jsonb_object_keys(" + this.tableAlias + ".description) dsc(keys) ON " + this.tableAlias + ".description IS NOT NULL WHERE (" + this.tableAlias + ".label->>lbl.keys ILIKE '%' || :searchTerm || '%' OR " + this.tableAlias + ".description->>dsc.keys ILIKE '%' || :searchTerm || '%')";
        return this.find(searchPageRequest, commonSql, Map.of("searchTerm", searchPageRequest.getQuery()));
    }

    protected SearchPageResponse<I> find(SearchPageRequest searchPageRequest, String commonSql, Map<String, Object> argumentMappings) {
        StringBuilder innerQuery = new StringBuilder("SELECT *" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, innerQuery);
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        Object orderBy = this.getOrderBy(searchPageRequest.getSorting());
        if (StringUtils.hasText((String)orderBy)) {
            orderBy = " ORDER BY " + (String)orderBy;
        }
        List<I> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, (String)orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, countQuery);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new SearchPageResponseImpl(result, searchPageRequest, total);
    }

    public List<I> findAllFull() {
        return this.retrieveList(this.sqlSelectAllFields, null, null, null);
    }

    public List<I> findAllReduced() {
        return this.retrieveList(this.sqlSelectReducedFields, null, null, null);
    }

    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        Filtering filtering = pageRequest.getFiltering();
        if (filtering == null) {
            filtering = Filtering.defaultBuilder().build();
            pageRequest.setFiltering(filtering);
        }
        Filtering.defaultBuilder().filter(this.tableAlias + ".label ->> :language").startsWith((Object)":initial").build();
        filtering.add(filtering);
        Sorting sorting = pageRequest.getSorting();
        if (sorting == null) {
            sorting = Sorting.defaultBuilder().build();
            pageRequest.setSorting(sorting);
        }
        Sorting.defaultBuilder().order(Order.defaultBuilder().property("label").subProperty(language).direction(Direction.ASC).build());
        sorting.and(sorting);
        return this.find(pageRequest, null, Map.of("language", language, "initial", initial));
    }

    public I findOne(UUID uuid, Filtering filtering) {
        if (filtering == null) {
            filtering = Filtering.defaultBuilder().build();
        }
        filtering.add(Filtering.defaultBuilder().filter("uuid").isEquals((Object)new FilterValuePlaceholder(":uuid")).build());
        I result = this.retrieveOne(this.sqlSelectAllFields, this.sqlSelectAllFieldsJoins, filtering, Map.of("uuid", uuid));
        return result;
    }

    public I findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return (I)this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        Filtering filtering = Filtering.defaultBuilder().filter("id.identifier").isEquals((Object)new FilterValuePlaceholder(":id")).filter("id.namespace").isEquals((Object)new FilterValuePlaceholder(":namespace")).build();
        I result = this.retrieveOne(this.sqlSelectAllFields, this.sqlSelectAllFieldsJoins, filtering, Map.of("id", identifierId, "namespace", namespace));
        return result;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("created", "label", "lastModified", "type"));
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "description": {
                return this.tableAlias + ".description";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "previewImage": {
                return this.tableAlias + ".previewfileresource";
            }
            case "type": {
                return this.tableAlias + ".identifiable_type";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    public int getIndex(List<? extends Identifiable> list, Identifiable identifiable) {
        int pos = -1;
        for (Identifiable identifiable2 : list) {
            ++pos;
            if (!identifiable2.getUuid().equals(identifiable.getUuid())) continue;
            return pos;
        }
        return -1;
    }

    public String getSqlSelectAllFields() {
        return this.sqlSelectAllFields;
    }

    public String getSqlSelectReducedFields() {
        return this.sqlSelectReducedFields;
    }

    public long retrieveCount(StringBuilder sqlCount, Map<String, Object> argumentMappings) {
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return total;
    }

    public List<I> retrieveList(String fieldsSql, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) {
        String sql = "SELECT " + fieldsSql + ", id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pi_uuid, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (this.sqlSelectAllFieldsJoins != null ? this.sqlSelectAllFieldsJoins : "") + " LEFT JOIN identifiers AS id ON " + this.tableAlias + ".uuid = id.identifiable LEFT JOIN fileresources_image AS file ON " + this.tableAlias + ".previewfileresource = file.uuid" + (String)(orderBy != null ? " " + orderBy : "");
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindMap(argumentMappings)).reduceRows((map, rowView) -> this.basicReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView)).collect(Collectors.toList()));
        return result;
    }

    protected Integer retrieveNextSortIndexForParentChildren(Jdbi dbi, String tableName, String columNameParentUuid, UUID parentUuid) {
        Integer sortIndex = (Integer)dbi.withHandle(h -> ((Query)h.createQuery("SELECT MAX(sortIndex) + 1 FROM " + tableName + " WHERE " + columNameParentUuid + " = :parent_uuid").bind("parent_uuid", parentUuid)).mapTo(Integer.class).findOne().orElse(null));
        if (sortIndex == null) {
            return 0;
        }
        return sortIndex;
    }

    public I retrieveOne(String fieldsSql, String sqlSelectAllFieldsJoins, Filtering filtering, Map<String, Object> argumentMappings) {
        StringBuilder sql = new StringBuilder("SELECT" + fieldsSql + ", id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pi_uuid, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl FROM " + this.tableName + " AS " + this.tableAlias + (sqlSelectAllFieldsJoins != null ? sqlSelectAllFieldsJoins : "") + " LEFT JOIN identifiers AS id ON " + this.tableAlias + ".uuid = id.identifiable LEFT JOIN fileresources_image AS file ON " + this.tableAlias + ".previewfileresource = file.uuid");
        this.addFiltering(filtering, sql);
        Identifiable result = ((Stream)this.dbi.withHandle(h -> ((Query)h.createQuery(sql.toString()).bindMap(argumentMappings)).reduceRows((map, rowView) -> {
            this.fullReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView);
            this.additionalReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView);
        }))).findFirst().orElse(null);
        return (I)result;
    }

    public I save(I identifiable, Map<String, Object> bindings) {
        if (bindings == null) {
            bindings = new HashMap<String, Object>();
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        HashMap<String, Object> finalBindings = new HashMap<String, Object>(bindings);
        if (identifiable.getUuid() == null) {
            identifiable.setUuid(UUID.randomUUID());
        }
        identifiable.setCreated(LocalDateTime.now());
        identifiable.setLastModified(LocalDateTime.now());
        String sql = "INSERT INTO " + this.tableName + "(" + this.sqlInsertFields + ") VALUES (" + this.sqlInsertValues + ")";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(sql).bindMap(finalBindings)).bindBean(identifiable)).execute());
        Set identifiers = identifiable.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)identifiable);
        return identifiable;
    }

    public void saveIdentifiers(Set<Identifier> identifiers, Identifiable identifiable) {
        if (identifiers != null) {
            for (Identifier identifier : identifiers) {
                identifier.setIdentifiable(identifiable.getUuid());
                this.identifierRepository.save(identifier);
            }
        }
    }

    public I update(I identifiable, Map<String, Object> bindings) {
        if (bindings == null) {
            bindings = new HashMap<String, Object>();
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        HashMap<String, Object> finalBindings = new HashMap<String, Object>(bindings);
        identifiable.setLastModified(LocalDateTime.now());
        String sql = "UPDATE " + this.tableName + " SET" + this.sqlUpdateFieldValues + " WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(sql).bindMap(finalBindings)).bindBean(identifiable)).execute());
        this.identifierRepository.deleteByIdentifiable(identifiable);
        Set identifiers = identifiable.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)identifiable);
        return identifiable;
    }
}

