/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.SubtopicRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterValuePlaceholder;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.NodeImpl;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.entity.TopicImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.SubtopicImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.view.BreadcrumbNavigationImpl;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class SubtopicRepositoryImpl
extends EntityPartRepositoryImpl<Subtopic>
implements SubtopicRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubtopicRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "st";
    public static final String TABLE_ALIAS = "s";
    public static final String TABLE_NAME = "subtopics";
    private final EntityRepositoryImpl<EntityImpl> entityRepositoryImpl;
    private final FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl;

    public static String getSqlInsertFields() {
        return IdentifiableRepositoryImpl.getSqlInsertFields();
    }

    public static String getSqlInsertValues() {
        return IdentifiableRepositoryImpl.getSqlInsertValues();
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return SubtopicRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return IdentifiableRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlUpdateFieldValues() {
        return IdentifiableRepositoryImpl.getSqlUpdateFieldValues();
    }

    @Autowired
    public SubtopicRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, EntityRepositoryImpl entityRepositoryImpl, FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, SubtopicImpl.class, SubtopicRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), SubtopicRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), SubtopicRepositoryImpl.getSqlInsertFields(), SubtopicRepositoryImpl.getSqlInsertValues(), SubtopicRepositoryImpl.getSqlUpdateFieldValues());
        this.entityRepositoryImpl = entityRepositoryImpl;
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    public boolean addChildren(UUID parentUuid, List<Subtopic> collections) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Integer deleteFromParentSubtopic(UUID subtopicUuid, UUID parentSubtopicUuid) {
        Integer count = (Integer)this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM subtopic_subtopics WHERE parent_subtopic_uuid=:parent_subtopic_uuid AND child_subtopic_uuid=:child_subtopic_uuid").bind("parent_subtopic_uuid", parentSubtopicUuid)).bind("child_subtopic_uuid", subtopicUuid)).execute());
        return count;
    }

    public Integer deleteFromParentTopic(UUID subtopicUuid, UUID topicUuid) {
        Integer count = (Integer)this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM topic_subtopics WHERE topic_uuid=:topic_uuid AND subtopic_uuid=:subtopic_uuid").bind("topic_uuid", topicUuid)).bind("subtopic_uuid", subtopicUuid)).execute());
        return count;
    }

    @Override
    public Subtopic findOne(UUID uuid, Filtering filtering) {
        Subtopic subtopic = (Subtopic)super.findOne(uuid, filtering);
        if (subtopic != null) {
            subtopic.setChildren(this.getChildren(subtopic));
        }
        return subtopic;
    }

    @Override
    public Subtopic findOne(Identifier identifier) {
        Subtopic subtopic = (Subtopic)super.findOne(identifier);
        if (subtopic != null) {
            subtopic.setChildren(this.getChildren(subtopic));
        }
        return subtopic;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery("WITH recursive breadcrumb (uuid,label,parent_uuid,depth) AS (        SELECT s.uuid as uuid, s.label as label, ss.parent_subtopic_uuid as parent_uuid,99 as depth        FROM subtopics s, subtopic_subtopics ss        WHERE uuid= :uuid and ss.child_subtopic_uuid = s.uuid        UNION ALL        SELECT s.uuid as uuid, s.label as label, ss.parent_subtopic_uuid as parent_uuid, depth-1 as depth        FROM subtopics s,             subtopic_subtopics ss,             breadcrumb b        WHERE b.uuid = ss.child_subtopic_uuid and ss.parent_subtopic_uuid = s.uuid AND ss.parent_subtopic_uuid is not null    ) SELECT * from breadcrumb UNION SELECT null as uuid, t.label as label, null as parent_uuid, 0 as depth FROM topics t, topic_subtopics ts, breadcrumb b WHERE ts.subtopic_uuid = b.parent_uuid and t.uuid = ts.topic_uuid ORDER BY depth ASC").bind("uuid", nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).map(Node.class::cast).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery("SELECT s.uuid as uuid, s.label as label        FROM subtopics s        WHERE uuid= :uuid").bind("uuid", nodeUuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).map(Node.class::cast).list());
        }
        return new BreadcrumbNavigationImpl(result);
    }

    public List<Subtopic> getChildren(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN subtopic_subtopics ss ON " + this.tableAlias + ".uuid = ss.child_subtopic_uuid WHERE ss.parent_subtopic_uuid = :uuid ORDER BY ss.sortIndex ASC");
        List<Subtopic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid), null);
        return result;
    }

    public PageResponse<Subtopic> getChildren(UUID uuid, PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ss.child_subtopic_uuid WHERE ss.parent_subtopic_uuid = :uuid";
        StringBuilder innerQuery = new StringBuilder("SELECT *" + commonSql);
        this.addFiltering(pageRequest, innerQuery);
        if (pageRequest.getSorting() == null) {
            innerQuery.append(" ORDER BY ss.sortIndex ASC");
        }
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid), null);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery);
        long total = this.retrieveCount(countQuery, Map.of("uuid", uuid));
        return new PageResponseImpl(result, pageRequest, total);
    }

    public List<Entity> getEntities(UUID subtopicUuid) {
        String entityTableAlias = this.entityRepositoryImpl.getTableAlias();
        String entityTableName = this.entityRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + entityTableName + " AS " + entityTableAlias + " INNER JOIN subtopic_entities se ON " + entityTableAlias + ".uuid = se.entity_uuid WHERE se.subtopic_uuid = :uuid ORDER BY se.sortIndex ASC");
        List<Entity> result = this.entityRepositoryImpl.retrieveList(this.entityRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", subtopicUuid), null).stream().map(Entity.class::cast).collect(Collectors.toList());
        return result;
    }

    public List<FileResource> getFileResources(UUID subtopicUuid) {
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN subtopic_fileresources sf ON " + frTableAlias + ".uuid = sf.fileresource_uuid WHERE sf.subtopic_uuid = :uuid ORDER BY sf.sortIndex ASC");
        List<FileResource> result = this.fileResourceMetadataRepositoryImpl.retrieveList(this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", subtopicUuid), null);
        return result;
    }

    public Subtopic getParent(UUID uuid) {
        String sqlAdditionalJoins = " INNER JOIN subtopic_subtopics ss ON " + this.tableAlias + ".uuid = ss.parent_subtopic_uuid";
        Filtering filtering = Filtering.defaultBuilder().filter("ss.child_subtopic_uuid").isEquals((Object)new FilterValuePlaceholder(":uuid")).build();
        Subtopic result = (Subtopic)this.retrieveOne(this.sqlSelectReducedFields, sqlAdditionalJoins, filtering, Map.of("uuid", uuid));
        return result;
    }

    public List<Subtopic> getParents(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN subtopic_subtopics ss ON " + this.tableAlias + ".uuid = ss.parent_subtopic_uuid WHERE ss.child_subtopic_uuid = :uuid");
        List<Subtopic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid), null);
        return result;
    }

    public PageResponse<Subtopic> getRootNodes(PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM subtopic_subtopics WHERE child_subtopic_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql, null);
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT languages FROM " + this.tableName + " AS " + this.tableAlias + ", jsonb_object_keys(" + this.tableAlias + ".label) AS languages WHERE NOT EXISTS (SELECT FROM subtopic_subtopics WHERE child_subtopic_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Subtopic> getSubtopicsOfEntity(UUID entityUuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN subtopic_entities se ON " + this.tableAlias + ".uuid = se.subtopic_uuid WHERE se.entity_uuid = :uuid");
        List<Subtopic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", entityUuid), null);
        return result;
    }

    public List<Subtopic> getSubtopicsOfFileResource(UUID fileResourceUuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN subtopic_fileresources sf ON " + this.tableAlias + ".uuid = sf.subtopic_uuid WHERE sf.fileresource_uuid = :uuid");
        List<Subtopic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", fileResourceUuid), null);
        return result;
    }

    public Topic getTopic(UUID rootSubtopicUuid) {
        String query = "SELECT uuid, refid, label FROM topics INNER JOIN topic_subtopics ts ON uuid = ts.topic_uuid WHERE ts.subtopic_uuid = :uuid";
        Topic result = (Topic)this.dbi.withHandle(h -> (TopicImpl)((Query)h.createQuery(query).bind("uuid", rootSubtopicUuid)).mapToBean(TopicImpl.class).one());
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Subtopic save(Subtopic subtopic) {
        super.save((Identifiable)subtopic);
        Subtopic result = (Subtopic)this.findOne(subtopic.getUuid());
        return result;
    }

    public List<Entity> saveEntities(UUID subtopicUuid, List<Entity> entities) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM subtopic_entities WHERE subtopic_uuid = :uuid").bind("uuid", subtopicUuid)).execute());
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO subtopic_entities(subtopic_uuid, entity_uuid, sortIndex) VALUES(:uuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", subtopicUuid)).bind("entityUuid", entity.getUuid())).bind("sortIndex", this.getIndex(entities, (Identifiable)entity))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getEntities(subtopicUuid);
    }

    public List<FileResource> saveFileResources(UUID subtopicUuid, List<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM subtopic_fileresources WHERE subtopic_uuid = :uuid").bind("uuid", subtopicUuid)).execute());
        if (fileResources != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO subtopic_fileresources(subtopic_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", subtopicUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(subtopicUuid);
    }

    public Subtopic saveWithParent(Subtopic subtopic, UUID parentSubtopicUuid) {
        UUID childSubtopicUuid = subtopic.getUuid() == null ? this.save(subtopic).getUuid() : subtopic.getUuid();
        Integer nextSortindex = this.retrieveNextSortIndexForParentChildren(this.dbi, "subtopic_subtopics", "parent_subtopic_uuid", parentSubtopicUuid);
        String query = "INSERT INTO subtopic_subtopics(parent_subtopic_uuid, child_subtopic_uuid, sortindex) VALUES (:parent_subtopic_uuid, :child_subtopic_uuid, :sortindex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_subtopic_uuid", parentSubtopicUuid)).bind("child_subtopic_uuid", childSubtopicUuid)).bind("sortindex", nextSortindex)).execute());
        return (Subtopic)this.findOne(childSubtopicUuid);
    }

    public Subtopic saveWithParentTopic(Subtopic subtopic, UUID parentTopicUuid) {
        UUID childSubtopicUuid = subtopic.getUuid() == null ? this.save(subtopic).getUuid() : subtopic.getUuid();
        Integer nextSortindex = this.retrieveNextSortIndexForParentChildren(this.dbi, "topic_subtopics", "topic_uuid", parentTopicUuid);
        String query = "INSERT INTO topic_subtopics(topic_uuid, subtopic_uuid, sortindex) VALUES (:parent_topic_uuid, :child_subtopic_uuid, :sortindex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_topic_uuid", parentTopicUuid)).bind("child_subtopic_uuid", childSubtopicUuid)).bind("sortindex", nextSortindex)).execute());
        return (Subtopic)this.findOne(childSubtopicUuid);
    }

    public Subtopic update(Subtopic subtopic) {
        super.update((Identifiable)subtopic);
        Subtopic result = (Subtopic)this.findOne(subtopic.getUuid());
        return result;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<Subtopic> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        String query = "UPDATE subtopic_subtopics SET sortindex = :idx WHERE child_subtopic_uuid = :childSubtopicUuid AND parent_subtopic_uuid = :parentSubtopicUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Subtopic subtopic : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childSubtopicUuid", subtopic.getUuid())).bind("parentSubtopicUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

