/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.TopicRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts.SubtopicRepositoryImpl;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.entity.Topic;
import de.digitalcollections.model.api.identifiable.entity.parts.Subtopic;
import de.digitalcollections.model.impl.identifiable.entity.TopicImpl;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TopicRepositoryImpl
extends EntityRepositoryImpl<Topic>
implements TopicRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "to";
    public static final String TABLE_ALIAS = "t";
    public static final String TABLE_NAME = "topics";
    private final SubtopicRepositoryImpl subtopicRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields();
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues();
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return TopicRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues();
    }

    @Autowired
    public TopicRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, SubtopicRepositoryImpl subtopicRepositoryImpl) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, TopicImpl.class, TopicRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), TopicRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), TopicRepositoryImpl.getSqlInsertFields(), TopicRepositoryImpl.getSqlInsertValues(), TopicRepositoryImpl.getSqlUpdateFieldValues());
        this.subtopicRepositoryImpl = subtopicRepositoryImpl;
    }

    @Override
    public Topic findOne(UUID uuid, Filtering filtering) {
        Topic topic = (Topic)super.findOne(uuid, filtering);
        if (topic != null) {
            topic.setSubtopics(this.getSubtopics(topic));
        }
        return topic;
    }

    @Override
    public Topic findOne(Identifier identifier) {
        Topic topic = (Topic)super.findOne(identifier);
        if (topic != null) {
            topic.setSubtopics(this.getSubtopics(topic));
        }
        return topic;
    }

    public List<Subtopic> getSubtopics(UUID uuid) {
        String stTableAlias = this.subtopicRepositoryImpl.getTableAlias();
        String stTableName = this.subtopicRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + stTableName + " AS " + stTableAlias + " INNER JOIN topic_subtopics ts ON " + stTableAlias + ".uuid = ts.subtopic_uuid WHERE ts.topic_uuid = :uuid ORDER BY ts.sortIndex ASC");
        List<Subtopic> result = this.subtopicRepositoryImpl.retrieveList(this.subtopicRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", uuid), null);
        return result;
    }

    public Topic save(Topic topic) {
        super.save((Identifiable)topic);
        Topic result = (Topic)this.findOne(topic.getUuid());
        return result;
    }

    public Topic update(Topic topic) {
        super.update((Identifiable)topic);
        Topic result = (Topic)this.findOne(topic.getUuid());
        return result;
    }
}

