/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.parts.WebpageRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.parts.EntityPartRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterValuePlaceholder;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.Identifier;
import de.digitalcollections.model.api.identifiable.Node;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.NodeImpl;
import de.digitalcollections.model.impl.identifiable.entity.WebsiteImpl;
import de.digitalcollections.model.impl.identifiable.entity.parts.WebpageImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import de.digitalcollections.model.impl.view.BreadcrumbNavigationImpl;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl
extends EntityPartRepositoryImpl<Webpage>
implements WebpageRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "wp";
    public static final String TABLE_ALIAS = "w";
    public static final String TABLE_NAME = "webpages";

    public static String getSqlInsertFields() {
        return IdentifiableRepositoryImpl.getSqlInsertFields() + ", publication_end, publication_start, rendering_hints, text";
    }

    public static String getSqlInsertValues() {
        return IdentifiableRepositoryImpl.getSqlInsertValues() + ", :publicationEnd, :publicationStart, :renderingHints::JSONB, :text::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return WebpageRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return IdentifiableRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".publication_end " + mappingPrefix + "_publicationEnd, " + tableAlias + ".publication_start " + mappingPrefix + "_publicationStart, " + tableAlias + ".rendering_hints " + mappingPrefix + "_renderingHints";
    }

    public static String getSqlUpdateFieldValues() {
        return IdentifiableRepositoryImpl.getSqlUpdateFieldValues() + ", publication_end=:publicationEnd, publication_start=:publicationStart, rendering_hints=:renderingHints::JSONB, text=:text::JSONB";
    }

    @Autowired
    public WebpageRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, WebpageImpl.class, WebpageRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), WebpageRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), WebpageRepositoryImpl.getSqlInsertFields(), WebpageRepositoryImpl.getSqlInsertValues(), WebpageRepositoryImpl.getSqlUpdateFieldValues());
    }

    public boolean addChildren(UUID parentUuid, List<Webpage> collections) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Webpage findOne(UUID uuid, Filtering filtering) {
        Webpage webpage = (Webpage)super.findOne(uuid, filtering);
        if (webpage != null) {
            webpage.setChildren(this.getChildren(webpage));
        }
        return webpage;
    }

    @Override
    public Webpage findOne(Identifier identifier) {
        Webpage webpage = (Webpage)super.findOne(identifier);
        if (webpage != null) {
            webpage.setChildren(this.getChildren(webpage));
        }
        return webpage;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("publicationEnd", "publicationStart"));
        return allowedOrderByFields;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery("WITH recursive breadcrumb (uuid,label,parent_uuid,depth) AS (        SELECT w.uuid as uuid, w.label as label, ww.parent_webpage_uuid as parent_uuid,99 as depth        FROM webpages w, webpage_webpages ww        WHERE uuid= :uuid and ww.child_webpage_uuid = w.uuid        UNION ALL        SELECT w.uuid as uuid, w.label as label, ww.parent_webpage_uuid as parent_uuid, depth-1 as depth        FROM webpages w,             webpage_webpages ww,             breadcrumb b        WHERE b.uuid = ww.child_webpage_uuid and ww.parent_webpage_uuid = w.uuid AND ww.parent_webpage_uuid is not null    ) SELECT * from breadcrumb UNION SELECT null as uuid, w.label as label, null as parent_uuid, 0 as depth FROM websites w, website_webpages ww, breadcrumb b WHERE ww.webpage_uuid = b.parent_uuid and w.uuid = ww.website_uuid ORDER BY depth ASC").bind("uuid", uuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).map(Node.class::cast).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery("SELECT w.uuid as uuid, w.label as label        FROM webpages w        WHERE uuid= :uuid").bind("uuid", uuid)).registerRowMapper(BeanMapper.factory(NodeImpl.class))).mapTo(NodeImpl.class).map(Node.class::cast).list());
        }
        return new BreadcrumbNavigationImpl(result);
    }

    public List<Webpage> getChildren(Webpage webpage) {
        return this.getChildren(webpage.getUuid());
    }

    public List<Webpage> getChildren(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.child_webpage_uuid WHERE ww.parent_webpage_uuid = :uuid ORDER BY ww.sortIndex ASC");
        List<Webpage> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid), null);
        return result;
    }

    public PageResponse<Webpage> getChildren(UUID uuid, PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.child_webpage_uuid WHERE ww.parent_webpage_uuid = :uuid";
        StringBuilder innerQuery = new StringBuilder("SELECT *" + commonSql);
        this.addFiltering(pageRequest, innerQuery);
        if (pageRequest.getSorting() == null) {
            innerQuery.append(" ORDER BY ww.sortIndex ASC");
        }
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid), null);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery);
        long total = this.retrieveCount(countQuery, Map.of("uuid", uuid));
        return new PageResponseImpl(result, pageRequest, total);
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "publicationEnd": {
                return this.tableAlias + ".publication_end";
            }
            case "publicationStart": {
                return this.tableAlias + ".publication_start";
            }
        }
        return null;
    }

    public Webpage getParent(UUID uuid) {
        String sqlAdditionalJoins = " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.parent_webpage_uuid";
        Filtering filtering = Filtering.defaultBuilder().filter("ww.child_webpage_uuid").isEquals((Object)new FilterValuePlaceholder(":uuid")).build();
        Webpage result = (Webpage)this.retrieveOne(this.sqlSelectReducedFields, sqlAdditionalJoins, filtering, Map.of("uuid", uuid));
        return result;
    }

    public List<Webpage> getParents(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.parent_webpage_uuid WHERE ww.child_webpage_uuid = :uuid");
        List<Webpage> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, Map.of("uuid", uuid), null);
        return result;
    }

    public PageResponse<Webpage> getRootNodes(PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM webpage_webpages WHERE child_webpage_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql, null);
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT languages FROM " + this.tableName + " AS " + this.tableAlias + ", jsonb_object_keys(" + this.tableAlias + ".label) AS languages WHERE NOT EXISTS (SELECT FROM webpage_webpages WHERE child_webpage_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public Website getWebsite(UUID rootWebpageUuid) {
        String query = "SELECT uuid, refid, label FROM websites INNER JOIN website_webpages ww ON uuid = ww.website_uuid WHERE ww.webpage_uuid = :uuid";
        Website result = (Website)this.dbi.withHandle(h -> (WebsiteImpl)((Query)h.createQuery(query).bind("uuid", rootWebpageUuid)).mapToBean(WebsiteImpl.class).one());
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Webpage save(Webpage webpage) {
        super.save((Identifiable)webpage);
        Webpage result = (Webpage)this.findOne(webpage.getUuid());
        return result;
    }

    public Webpage saveWithParent(Webpage webpage, UUID parentWebpageUuid) {
        UUID childUuid = webpage.getUuid() == null ? this.save(webpage).getUuid() : webpage.getUuid();
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "webpage_webpages", "parent_webpage_uuid", parentWebpageUuid);
        String query = "INSERT INTO webpage_webpages(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parent_webpage_uuid, :child_webpage_uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_webpage_uuid", parentWebpageUuid)).bind("child_webpage_uuid", childUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Webpage)this.findOne(childUuid);
    }

    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) {
        UUID webpageUuid = webpage.getUuid() == null ? this.save(webpage).getUuid() : webpage.getUuid();
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "website_webpages", "website_uuid", parentWebsiteUuid);
        String query = "INSERT INTO website_webpages(website_uuid, webpage_uuid, sortIndex) VALUES (:parent_website_uuid, :webpage_uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_website_uuid", parentWebsiteUuid)).bind("webpage_uuid", webpageUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Webpage)this.findOne(webpageUuid);
    }

    public Webpage update(Webpage webpage) {
        super.update((Identifiable)webpage);
        Webpage result = (Webpage)this.findOne(webpage.getUuid());
        return result;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<Webpage> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        String query = "UPDATE webpage_webpages SET sortindex = :idx WHERE child_webpage_uuid = :childWebpageUuid AND parent_webpage_uuid = :parentWebpageUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Webpage webpage : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childWebpageUuid", webpage.getUuid())).bind("parentWebpageUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

