/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.relation;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.relation.PredicateRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.api.identifiable.entity.relation.Predicate;
import de.digitalcollections.model.impl.identifiable.entity.relation.PredicateImpl;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PredicateRepositoryImpl
extends JdbiRepositoryImpl
implements PredicateRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PredicateRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "pred";
    public static final String SQL_REDUCED_FIELDS_PRED = " p.value pred_value, p.label pred_label, p.created pred_created, p.last_modified pred_lastModified";
    public static final String SQL_FULL_FIELDS_PRED = " p.value pred_value, p.label pred_label, p.created pred_created, p.last_modified pred_lastModified , p.description pred_description";
    public static final String TABLE_ALIAS = "p";
    public static final String TABLE_NAME = "predicates";

    @Autowired
    public PredicateRepositoryImpl(Jdbi dbi) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX);
    }

    public void delete(String value) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE value = :value").bind("value", value)).execute());
    }

    public List<Predicate> findAll() {
        String sql = "SELECT * FROM " + this.tableName + " AS " + this.tableAlias;
        List result = (List)this.dbi.withHandle(h -> (List)h.createQuery(sql).mapToBean(PredicateImpl.class).map(Predicate.class::cast).collect(Collectors.toList()));
        return result;
    }

    public Predicate findOneByValue(String value) {
        String query = "SELECT * FROM " + this.tableName + " WHERE value = :value";
        Optional result = (Optional)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("value", value)).mapToBean(PredicateImpl.class).map(Predicate.class::cast).findFirst());
        return result.orElse(null);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return Arrays.asList("created", "label", "lastModified", "value");
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "value": {
                return this.tableAlias + ".value";
            }
        }
        return null;
    }

    public Predicate save(Predicate predicate) {
        Predicate existingPredicate = this.findOneByValue(predicate.getValue());
        if (existingPredicate != null) {
            predicate.setCreated(existingPredicate.getCreated());
        }
        predicate.setLastModified(LocalDateTime.now());
        if (existingPredicate != null) {
            String updateQuery = "UPDATE " + this.tableName + " SET label=:label::JSONB, description=:description::JSONB, last_modified=:lastModified WHERE value=:value";
            this.dbi.withHandle(h -> ((Update)h.createUpdate(updateQuery).bindBean((Object)predicate)).execute());
        } else {
            predicate.setCreated(predicate.getLastModified());
            String createQuery = "INSERT INTO " + this.tableName + "(value, label, description, created, last_modified) VALUES (:value, :label::JSONB, :description::JSONB, :created, :lastModified)";
            this.dbi.withHandle(h -> ((Update)h.createUpdate(createQuery).bindBean((Object)predicate)).execute());
        }
        return this.findOneByValue(predicate.getValue());
    }
}

