/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.CollectionRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.ProjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.ItemRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.ImageFileResourceRepositoryImpl;
import de.digitalcollections.model.api.filter.FilterValuePlaceholder;
import de.digitalcollections.model.api.filter.Filtering;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.identifiable.entity.work.Item;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.paging.PageResponseImpl;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectRepositoryImpl
extends EntityRepositoryImpl<DigitalObject>
implements DigitalObjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "do";
    public static final String TABLE_ALIAS = "d";
    public static final String TABLE_NAME = "digitalobjects";
    @Lazy
    @Autowired
    private CollectionRepositoryImpl collectionRepositoryImpl;
    @Lazy
    @Autowired
    private FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl;
    @Lazy
    @Autowired
    private ImageFileResourceRepositoryImpl imageFileResourceRepositoryImpl;
    @Lazy
    @Autowired
    private ItemRepositoryImpl itemRepositoryImpl;
    @Lazy
    @Autowired
    private ProjectRepositoryImpl projectRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields();
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues();
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return DigitalObjectRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues();
    }

    @Autowired
    public DigitalObjectRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, DigitalObjectImpl.class, DigitalObjectRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), DigitalObjectRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), DigitalObjectRepositoryImpl.getSqlInsertFields(), DigitalObjectRepositoryImpl.getSqlInsertValues(), DigitalObjectRepositoryImpl.getSqlUpdateFieldValues());
    }

    public void deleteFileResources(UUID digitalObjectUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
    }

    public PageResponse<Collection> getCollections(UUID digitalObjectUuid, PageRequest pageRequest) {
        String tableAliasCollection = this.collectionRepositoryImpl.getTableAlias();
        String tableNameCollection = this.collectionRepositoryImpl.getTableName();
        String commonSql = " FROM " + tableNameCollection + " AS " + tableAliasCollection + " LEFT JOIN collection_digitalobjects AS cd ON " + tableAliasCollection + ".uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid";
        StringBuilder innerQuery = new StringBuilder("SELECT *" + commonSql);
        Filtering filtering = pageRequest.getFiltering();
        if (filtering != null) {
            List filterCriteria = filtering.getFilterCriteria().stream().map(fc -> {
                fc.setFieldName(this.collectionRepositoryImpl.getColumnName(fc.getFieldName()));
                return fc;
            }).collect(Collectors.toList());
            filtering.setFilterCriteria(filterCriteria);
        }
        this.addFiltering(pageRequest, innerQuery);
        pageRequest.setSorting(null);
        innerQuery.append(" ORDER BY ").append(tableAliasCollection).append(".label ASC");
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.collectionRepositoryImpl.retrieveList(this.collectionRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", digitalObjectUuid), null);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery);
        long total = this.retrieveCount(countQuery, Map.of("uuid", digitalObjectUuid));
        return new PageResponseImpl(result, pageRequest, total);
    }

    public List<FileResource> getFileResources(UUID digitalObjectUuid) {
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        String fieldsSql = this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + frTableName + " AS " + frTableAlias + " LEFT JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY df.sortIndex ASC");
        Map<String, Object> argumentMappings = Map.of("uuid", digitalObjectUuid);
        List<FileResource> fileResources = this.fileResourceMetadataRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, null);
        return fileResources;
    }

    public List<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) {
        String frTableAlias = this.imageFileResourceRepositoryImpl.getTableAlias();
        String frTableName = this.imageFileResourceRepositoryImpl.getTableName();
        String fieldsSql = this.imageFileResourceRepositoryImpl.getSqlSelectAllFields();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + frTableName + " AS " + frTableAlias + " LEFT JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY df.sortIndex ASC");
        Map<String, Object> argumentMappings = Map.of("uuid", digitalObjectUuid);
        List<ImageFileResource> fileResources = this.imageFileResourceRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, null);
        return fileResources;
    }

    public Item getItem(UUID digitalObjectUuid) {
        String itTableAlias = this.itemRepositoryImpl.getTableAlias();
        String sqlAdditionalJoins = " LEFT JOIN item_digitalobjects AS ido ON " + itTableAlias + ".uuid = ido.item_uuid";
        Filtering filtering = Filtering.defaultBuilder().filter("ido.digitalobject_uuid").isEquals((Object)new FilterValuePlaceholder(":uuid")).build();
        Item result = (Item)this.itemRepositoryImpl.retrieveOne(this.itemRepositoryImpl.getSqlSelectReducedFields(), sqlAdditionalJoins, filtering, Map.of("uuid", digitalObjectUuid));
        return result;
    }

    public PageResponse<Project> getProjects(UUID digitalObjectUuid, PageRequest pageRequest) {
        String prTableAlias = this.projectRepositoryImpl.getTableAlias();
        String prTableName = this.projectRepositoryImpl.getTableName();
        String commonSql = " FROM " + prTableName + " AS " + prTableAlias + " LEFT JOIN project_digitalobjects AS pd ON " + prTableAlias + ".uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid";
        StringBuilder innerQuery = new StringBuilder("SELECT *" + commonSql);
        this.addFiltering(pageRequest, innerQuery);
        pageRequest.setSorting(null);
        innerQuery.append(" ORDER BY ").append(prTableAlias).append(".label ASC");
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.projectRepositoryImpl.retrieveList(this.projectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", digitalObjectUuid), null);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering(pageRequest, countQuery);
        long total = this.retrieveCount(countQuery, Map.of("uuid", digitalObjectUuid));
        return new PageResponseImpl(result, pageRequest, total);
    }

    public DigitalObject save(DigitalObject digitalObject) {
        super.save((Identifiable)digitalObject);
        List fileResources = digitalObject.getFileResources();
        this.saveFileResources(digitalObject, fileResources);
        DigitalObject result = (DigitalObject)this.findOne(digitalObject.getUuid());
        return result;
    }

    public List<FileResource> saveFileResources(UUID digitalObjectUuid, List<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
        if (fileResources != null) {
            for (FileResource fileResource : fileResources) {
                if (fileResource.getUuid() != null) continue;
                this.fileResourceMetadataRepositoryImpl.save((FileResource)((FileResourceImpl)fileResource));
            }
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO digitalobject_fileresources(digitalobject_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(digitalObjectUuid);
    }

    public DigitalObject update(DigitalObject digitalObject) {
        super.update((Identifiable)digitalObject);
        DigitalObject result = (DigitalObject)this.findOne(digitalObject.getUuid());
        return result;
    }
}

