/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.agent.PersonRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.agent.FamilyNameRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.agent.GivenNameRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.WorkRepositoryImpl;
import de.digitalcollections.model.api.identifiable.agent.FamilyName;
import de.digitalcollections.model.api.identifiable.agent.GivenName;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.agent.Person;
import de.digitalcollections.model.api.identifiable.entity.geo.GeoLocation;
import de.digitalcollections.model.api.identifiable.entity.geo.enums.GeoLocationType;
import de.digitalcollections.model.api.identifiable.entity.work.Work;
import de.digitalcollections.model.api.identifiable.parts.LocalizedText;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.agent.FamilyNameImpl;
import de.digitalcollections.model.impl.identifiable.agent.GivenNameImpl;
import de.digitalcollections.model.impl.identifiable.entity.agent.PersonImpl;
import de.digitalcollections.model.impl.identifiable.entity.geo.GeoLocationImpl;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PersonRepositoryImpl
extends EntityRepositoryImpl<Person>
implements PersonRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "pe";
    public static final String TABLE_ALIAS = "p";
    private static final String SQL_FULL_FIELDS_JOINS = " LEFT JOIN geolocations AS glbirth ON glbirth.uuid = p.locationofbirth LEFT JOIN geolocations AS gldeath ON gldeath.uuid = p.locationofdeath LEFT JOIN person_familynames AS pf ON pf.person_uuid = p.uuid LEFT JOIN familynames AS fn ON fn.uuid = pf.familyname_uuid LEFT JOIN person_givennames AS pg ON pg.person_uuid = p.uuid LEFT JOIN givennames AS gn ON gn.uuid = pg.givenname_uuid";
    public static final String TABLE_NAME = "persons";
    private final DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;
    private final FamilyNameRepositoryImpl familyNameRepositoryImpl;
    private final GivenNameRepositoryImpl givenNameRepositoryImpl;
    private final WorkRepositoryImpl workRepositoryImpl;

    private static BiFunction<Map<UUID, Person>, RowView, Map<UUID, Person>> createAdditionalReduceRowsBiFunction() {
        return (map, rowView) -> {
            GeoLocationType geoLocationType;
            LocalizedText label;
            Person person = (Person)map.get(rowView.getColumn("pe_uuid", UUID.class));
            if (rowView.getColumn("glbirth_uuid", UUID.class) != null) {
                UUID glBirthUuid = (UUID)rowView.getColumn("glbirth_uuid", UUID.class);
                label = (LocalizedText)rowView.getColumn("glbirth_label", LocalizedText.class);
                geoLocationType = (GeoLocationType)rowView.getColumn("glbirth_geoLocationType", GeoLocationType.class);
                GeoLocationImpl placeOfBirth = new GeoLocationImpl();
                placeOfBirth.setUuid(glBirthUuid);
                placeOfBirth.setLabel(label);
                placeOfBirth.setGeoLocationType(geoLocationType);
                person.setPlaceOfBirth((GeoLocation)placeOfBirth);
            }
            if (rowView.getColumn("gldeath_uuid", UUID.class) != null) {
                UUID glDeathUuid = (UUID)rowView.getColumn("gldeath_uuid", UUID.class);
                label = (LocalizedText)rowView.getColumn("gldeath_label", LocalizedText.class);
                geoLocationType = (GeoLocationType)rowView.getColumn("gldeath_geoLocationType", GeoLocationType.class);
                GeoLocationImpl placeOfDeath = new GeoLocationImpl();
                placeOfDeath.setUuid(glDeathUuid);
                placeOfDeath.setLabel(label);
                placeOfDeath.setGeoLocationType(geoLocationType);
                person.setPlaceOfDeath((GeoLocation)placeOfDeath);
            }
            try {
                if (rowView.getColumn("fn_uuid", UUID.class) != null) {
                    person.getFamilyNames().add((FamilyName)rowView.getRow(FamilyNameImpl.class));
                }
                if (rowView.getColumn("gn_uuid", UUID.class) != null) {
                    person.getGivenNames().add((GivenName)rowView.getRow(GivenNameImpl.class));
                }
            }
            catch (Exception e) {
                LOGGER.debug("No family name or given name in rowview. Skipping.");
            }
            return map;
        };
    }

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", dateofbirth, dateofdeath, gender, locationofbirth, locationofdeath, timevalueofbirth, timevalueofdeath";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :dateOfBirth, :dateOfDeath, :gender, :locationOfBirth, :locationOfDeath, :timeValueOfBirth::JSONB, :timeValueOfDeath::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        String familyNameMappingPrefix = "fn";
        String givenNameMappingPrefix = "gn";
        return PersonRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", glbirth.uuid glbirth_uuid, glbirth.label glbirth_label, glbirth.geolocation_type glbirth_geoLocationType, gldeath.uuid gldeath_uuid, gldeath.label gldeath_label, gldeath.geolocation_type gldeath_geoLocationType, fn.uuid fn_uuid, fn.label fn_label, gn.uuid gn_uuid, gn.label gn_label";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".dateofbirth " + mappingPrefix + "_dateOfBirth, " + tableAlias + ".dateofdeath " + mappingPrefix + "_dateOfDeath, " + tableAlias + ".gender " + mappingPrefix + "_gender, " + tableAlias + ".timevalueofbirth " + mappingPrefix + "_timeValueOfBirth, " + tableAlias + ".timevalueofdeath " + mappingPrefix + "_timeValueOfDeath";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", dateofbirth=:dateOfBirth, dateofdeath=:dateOfDeath, gender=:gender, locationofbirth=:locationOfBirth, locationofdeath=:locationOfDeath, timevalueofbirth=:timeValueOfBirth::JSONB, timevalueofdeath=:timeValueOfDeath::JSONB";
    }

    @Autowired
    public PersonRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, DigitalObjectRepositoryImpl digitalObjectRepositoryImpl, FamilyNameRepositoryImpl familyNameRepositoryImpl, GivenNameRepositoryImpl givenNameRepositoryImpl, WorkRepositoryImpl workRepositoryImpl) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class)PersonImpl.class, PersonRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), PersonRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), PersonRepositoryImpl.getSqlInsertFields(), PersonRepositoryImpl.getSqlInsertValues(), PersonRepositoryImpl.getSqlUpdateFieldValues(), SQL_FULL_FIELDS_JOINS, PersonRepositoryImpl.createAdditionalReduceRowsBiFunction());
        this.digitalObjectRepositoryImpl = digitalObjectRepositoryImpl;
        this.familyNameRepositoryImpl = familyNameRepositoryImpl;
        this.givenNameRepositoryImpl = givenNameRepositoryImpl;
        this.workRepositoryImpl = workRepositoryImpl;
    }

    public PageResponse<Person> findByLocationOfBirth(PageRequest pageRequest, UUID uuidGeoLocation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public PageResponse<Person> findByLocationOfDeath(PageRequest pageRequest, UUID uuidGeoLocation) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Set<DigitalObject> getDigitalObjects(UUID uuidPerson) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + doTableName + " AS " + doTableAlias + " LEFT JOIN item_digitalobjects AS itdi ON " + doTableAlias + ".uuid = itdi.digitalobject_uuid LEFT JOIN item_works AS itwo ON itdi.item_uuid = itwo.item_uuid LEFT JOIN work_creators AS wocr ON itwo.work_uuid = wocr.work_uuid WHERE wocr.agent_uuid = :uuid");
        List list = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", uuidPerson), null);
        return list.stream().collect(Collectors.toSet());
    }

    public Set<Work> getWorks(UUID uuidPerson) {
        String wTableAlias = this.workRepositoryImpl.getTableAlias();
        String wTableName = this.workRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + wTableName + " AS " + wTableAlias + " LEFT JOIN work_creators AS wc ON " + wTableAlias + ".uuid = wc.work_uuid WHERE wc.agent_uuid = :uuid ORDER BY wc.sortIndex ASC");
        List list = this.workRepositoryImpl.retrieveList(this.workRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", uuidPerson), null);
        return list.stream().collect(Collectors.toSet());
    }

    public Person save(Person person) {
        UUID locationOfBirthUuid = person.getPlaceOfBirth() == null ? null : person.getPlaceOfBirth().getUuid();
        UUID locationOfDeathUuid = person.getPlaceOfDeath() == null ? null : person.getPlaceOfDeath().getUuid();
        Map<String, Object> bindings = Map.of("locationOfBirth", locationOfBirthUuid, "locationOfDeath", locationOfDeathUuid);
        super.save(person, bindings);
        List givenNames = person.getGivenNames();
        this.saveRelatedGivenNames(givenNames, person);
        List familyNames = person.getFamilyNames();
        this.saveRelatedFamilyNames(familyNames, person);
        Person result = (Person)this.findOne(person.getUuid());
        return result;
    }

    private void saveRelatedFamilyNames(List<FamilyName> familyNames, Person person) {
        if (familyNames != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO person_familynames(person_uuid, familyname_uuid, sortIndex) VALUES(:uuid, :familynameUuid, :sortIndex)");
                int i = 0;
                for (FamilyName familyName : familyNames) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", person.getUuid())).bind("familynameUuid", familyName.getUuid())).bind("sortIndex", i)).add();
                    ++i;
                }
                preparedBatch.execute();
            });
        }
    }

    private void saveRelatedGivenNames(List<GivenName> givenNames, Person person) {
        if (givenNames != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO person_givennames(person_uuid, givenname_uuid, sortIndex) VALUES(:uuid, :givennameUuid, :sortIndex)");
                int i = 0;
                for (GivenName givenName : givenNames) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", person.getUuid())).bind("givennameUuid", givenName.getUuid())).bind("sortIndex", i)).add();
                    ++i;
                }
                preparedBatch.execute();
            });
        }
    }

    public Person update(Person person) {
        UUID locationOfBirthUuid = person.getPlaceOfBirth() == null ? null : person.getPlaceOfBirth().getUuid();
        UUID locationOfDeathUuid = person.getPlaceOfDeath() == null ? null : person.getPlaceOfDeath().getUuid();
        Map<String, Object> bindings = Map.of("locationOfBirth", locationOfBirthUuid, "locationOfDeath", locationOfDeathUuid);
        super.update(person, bindings);
        List givenNames = person.getGivenNames();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM person_givennames WHERE person_uuid = :uuid").bind("uuid", person.getUuid())).execute());
        this.saveRelatedGivenNames(givenNames, person);
        List familyNames = person.getFamilyNames();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM person_familynames WHERE person_uuid = :uuid").bind("uuid", person.getUuid())).execute());
        this.saveRelatedFamilyNames(familyNames, person);
        Person result = (Person)this.findOne(person.getUuid());
        return result;
    }
}

