/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work.ItemRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.WorkRepositoryImpl;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.work.Item;
import de.digitalcollections.model.api.identifiable.entity.work.Work;
import de.digitalcollections.model.impl.identifiable.entity.work.ItemImpl;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class ItemRepositoryImpl
extends EntityRepositoryImpl<Item>
implements ItemRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "it";
    public static final String TABLE_ALIAS = "i";
    public static final String TABLE_NAME = "items";
    private final DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;
    private final WorkRepositoryImpl workRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", language, publication_date, publication_place, publisher, version";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :language, :publicationDate, :publicationPlace, :publisher, :version";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return ItemRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".language " + mappingPrefix + "_language, " + tableAlias + ".publication_date " + mappingPrefix + "_publicationDate, " + tableAlias + ".publication_place " + mappingPrefix + "_publicationPlace, " + tableAlias + ".publisher " + mappingPrefix + "_publisher, " + tableAlias + ".version " + mappingPrefix + "_version";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", language=:language, publication_date=:publicationDate, publication_place=:publicationPlace, publisher=:publisher, version=:version";
    }

    @Autowired
    public ItemRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, @Lazy DigitalObjectRepositoryImpl digitalObjectRepositoryImpl, @Lazy WorkRepositoryImpl workRepositoryImpl) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, ItemImpl.class, ItemRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), ItemRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), ItemRepositoryImpl.getSqlInsertFields(), ItemRepositoryImpl.getSqlInsertValues(), ItemRepositoryImpl.getSqlUpdateFieldValues());
        this.digitalObjectRepositoryImpl = digitalObjectRepositoryImpl;
        this.workRepositoryImpl = workRepositoryImpl;
    }

    public boolean addDigitalObject(UUID itemUuid, UUID digitalObjectUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "item_digitalobjects", "item_uuid", itemUuid);
        String query = "INSERT INTO item_digitalobjects (item_uuid, digitalobject_uuid, sortindex) VALUES (:itemUuid, :digitalObjectUuid, :nextSortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("itemUuid", itemUuid)).bind("digitalObjectUuid", digitalObjectUuid)).bind("nextSortIndex", nextSortIndex)).execute());
        return true;
    }

    public boolean addWork(UUID itemUuid, UUID workUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "item_works", "item_uuid", itemUuid);
        String query = "INSERT INTO item_works (item_uuid, work_uuid, sortindex) VALUES (:itemUuid, :workUuid, :nextSortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("itemUuid", itemUuid)).bind("workUuid", workUuid)).bind("nextSortIndex", nextSortIndex)).execute());
        return true;
    }

    public Set<DigitalObject> getDigitalObjects(UUID itemUuid) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + doTableName + " AS " + doTableAlias + " LEFT JOIN item_digitalobjects AS ido ON " + doTableAlias + ".uuid = ido.digitalobject_uuid WHERE ido.item_uuid = :uuid ORDER BY ido.sortIndex ASC");
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", itemUuid), null);
        return result.stream().collect(Collectors.toSet());
    }

    public Set<Work> getWorks(UUID itemUuid) {
        String wTableAlias = this.workRepositoryImpl.getTableAlias();
        String wTableName = this.workRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + wTableName + " AS " + wTableAlias + " LEFT JOIN item_works AS iw ON " + wTableAlias + ".uuid = iw.work_uuid WHERE iw.item_uuid = :uuid ORDER BY iw.sortIndex ASC");
        List result = this.workRepositoryImpl.retrieveList(this.workRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", itemUuid), null);
        return result.stream().collect(Collectors.toSet());
    }

    public Item save(Item item) {
        super.save((Identifiable)item);
        Item result = (Item)this.findOne(item.getUuid());
        return result;
    }

    public Item update(Item item) {
        super.update((Identifiable)item);
        Item result = (Item)this.findOne(item.getUuid());
        return result;
    }
}

