/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.filter.FilterValuePlaceholder;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class IdentifiableRepositoryImpl<I extends Identifiable>
extends JdbiRepositoryImpl
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "idf";
    public static final String TABLE_ALIAS = "i";
    public static final String TABLE_NAME = "identifiables";
    public BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> additionalReduceRowsBiFunction = (map, rowView) -> map;
    public final BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> basicReduceRowsBiFunction;
    public final BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> fullReduceRowsBiFunction;
    protected final Class identifiableImplClass;
    protected final IdentifierRepository identifierRepository;
    private final String sqlInsertFields;
    private final String sqlInsertValues;
    protected String sqlSelectAllFields;
    protected final String sqlSelectAllFieldsJoins;
    protected String sqlSelectReducedFields;
    private final String sqlUpdateFieldValues;

    public static String getSqlInsertFields() {
        return " uuid, created, description, identifiable_type, label, last_modified, previewfileresource, preview_hints";
    }

    public static String getSqlInsertValues() {
        return " :uuid, :created, :description::JSONB, :type, :label::JSONB, :lastModified, :previewFileResource, :previewImageRenderingHints::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return IdentifiableRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return " " + tableAlias + ".uuid " + mappingPrefix + "_uuid, " + tableAlias + ".created " + mappingPrefix + "_created, " + tableAlias + ".description " + mappingPrefix + "_description, " + tableAlias + ".identifiable_type " + mappingPrefix + "_type, " + tableAlias + ".label " + mappingPrefix + "_label, " + tableAlias + ".last_modified " + mappingPrefix + "_lastModified, " + tableAlias + ".preview_hints " + mappingPrefix + "_previewImageRenderingHints";
    }

    public static String getSqlUpdateFieldValues() {
        return " description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB";
    }

    @Autowired
    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        this(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Identifiable.class, IdentifiableRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), IdentifiableRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), IdentifiableRepositoryImpl.getSqlInsertFields(), IdentifiableRepositoryImpl.getSqlInsertValues(), IdentifiableRepositoryImpl.getSqlUpdateFieldValues());
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues) {
        this(dbi, identifierRepository, tableName, tableAlias, mappingPrefix, identifiableImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, null);
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins) {
        this(dbi, identifierRepository, tableName, tableAlias, mappingPrefix, identifiableImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, sqlSelectAllFieldsJoins, null);
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins, BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> additionalReduceRowsBiFunction) {
        super(dbi, tableName, tableAlias, mappingPrefix);
        dbi.registerRowMapper(BeanMapper.factory((Class)identifiableImplClass, (String)mappingPrefix));
        this.basicReduceRowsBiFunction = this.createReduceRowsBiFunction(true, true);
        this.fullReduceRowsBiFunction = this.createReduceRowsBiFunction(true, true);
        if (additionalReduceRowsBiFunction != null) {
            this.additionalReduceRowsBiFunction = additionalReduceRowsBiFunction;
        }
        this.identifiableImplClass = identifiableImplClass;
        this.identifierRepository = identifierRepository;
        this.sqlInsertFields = sqlInsertFields;
        this.sqlInsertValues = sqlInsertValues;
        this.sqlSelectAllFields = sqlSelectAllFields;
        this.sqlSelectAllFieldsJoins = sqlSelectAllFieldsJoins;
        this.sqlSelectReducedFields = sqlSelectReducedFields;
        this.sqlUpdateFieldValues = sqlUpdateFieldValues;
    }

    public void addRelatedEntity(UUID identifiableUuid, UUID entityUuid) {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_identifiable_entities", "identifiable_uuid", identifiableUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_identifiable_entities(identifiable_uuid, entity_uuid, sortindex) VALUES (:identifiableUuid, :entityUuid, :sortindex)").bind("identifiableUuid", identifiableUuid)).bind("entityUuid", entityUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void addRelatedFileresource(UUID identifiableUuid, UUID fileResourceUuid) {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_identifiable_fileresources", "identifiable_uuid", identifiableUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_identifiable_fileresources(identifiable_uuid, fileresource_uuid, sortindex) VALUES (:identifiableUuid, :fileresourceUuid, :sortindex)").bind("identifiableUuid", identifiableUuid)).bind("fileresourceUuid", fileResourceUuid)).bind("sortindex", sortIndex)).execute());
    }

    private BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> createReduceRowsBiFunction(boolean withIdentifiers, boolean withPreviewImage) {
        return (map, rowView) -> {
            Identifiable identifiable = map.computeIfAbsent((UUID)rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class), fn -> (Identifiable)rowView.getRow(this.identifiableImplClass));
            if (withPreviewImage && rowView.getColumn("pi_uuid", UUID.class) != null) {
                ImageFileResource previewImage = new ImageFileResource();
                previewImage.setUuid((UUID)rowView.getColumn("pi_uuid", UUID.class));
                previewImage.setFilename((String)rowView.getColumn("pi_filename", String.class));
                previewImage.setHttpBaseUrl((URL)rowView.getColumn("pi_httpBaseUrl", URL.class));
                previewImage.setMimeType((MimeType)rowView.getColumn("pi_mimeType", MimeType.class));
                previewImage.setUri((URI)rowView.getColumn("pi_uri", URI.class));
                identifiable.setPreviewImage(previewImage);
            }
            if (withIdentifiers && rowView.getColumn("id_uuid", UUID.class) != null) {
                Identifier dbIdentifier = (Identifier)rowView.getRow(Identifier.class);
                identifiable.addIdentifier(dbIdentifier);
            }
            return map;
        };
    }

    public boolean delete(List<UUID> uuids) {
        uuids.stream().forEach(u -> this.deleteIdentifiers((UUID)u));
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
        return true;
    }

    public boolean deleteIdentifiers(UUID identifiableUuid) {
        Identifiable identifiable = this.findOne(identifiableUuid);
        if (identifiable == null) {
            return false;
        }
        this.identifierRepository.delete(identifiable.getIdentifiers().stream().map(Identifier::getUuid).collect(Collectors.toList()));
        return true;
    }

    protected String escapeTermForJsonpath(String term) {
        if (term == null) {
            return null;
        }
        if (term.startsWith("\"") && term.endsWith("\"")) {
            term = term.replaceAll("^\"(.+)\"$", "$1");
        }
        if (term.contains("\"")) {
            term = term.replaceAll("\"", "\\\\\"");
        }
        return term;
    }

    public PageResponse<I> find(PageRequest pageRequest) {
        return this.find(pageRequest, null, null);
    }

    protected PageResponse<I> find(PageRequest pageRequest, String commonSql, Map<String, Object> argumentMappings) {
        if (commonSql == null) {
            commonSql = " FROM " + this.tableName + " AS " + this.tableAlias;
        }
        StringBuilder innerQuery = new StringBuilder("SELECT *" + (String)commonSql);
        this.addFiltering(pageRequest, innerQuery);
        this.addPageRequestParams(pageRequest, innerQuery);
        Object orderBy = this.getOrderBy(pageRequest.getSorting());
        if (StringUtils.hasText((String)orderBy)) {
            orderBy = " ORDER BY " + (String)orderBy;
        }
        List<I> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, (String)orderBy);
        StringBuilder sqlCount = new StringBuilder("SELECT count(*)" + (String)commonSql);
        this.addFiltering(pageRequest, sqlCount);
        long total = this.retrieveCount(sqlCount, argumentMappings);
        return new PageResponse(result, pageRequest, total);
    }

    public SearchPageResponse<I> find(SearchPageRequest searchPageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias;
        String searchTerm = searchPageRequest.getQuery();
        if (!StringUtils.hasText((String)searchTerm)) {
            return this.find(searchPageRequest, commonSql, (Map<String, Object>)Collections.EMPTY_MAP);
        }
        commonSql = commonSql + " WHERE " + this.getCommonSearchSql(this.tableAlias);
        return this.find(searchPageRequest, commonSql, Map.of("searchTerm", this.escapeTermForJsonpath(searchTerm)));
    }

    protected SearchPageResponse<I> find(SearchPageRequest searchPageRequest, String commonSql, Map<String, Object> argumentMappings) {
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".*" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, innerQuery);
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        Object orderBy = this.getOrderBy(searchPageRequest.getSorting());
        if (StringUtils.hasText((String)orderBy)) {
            orderBy = " ORDER BY " + (String)orderBy;
        }
        List<I> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, (String)orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, countQuery);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new SearchPageResponse(result, searchPageRequest, total);
    }

    public List<I> findAllFull() {
        return this.retrieveList(this.sqlSelectAllFields, null, null, null);
    }

    public List<I> findAllReduced() {
        return this.retrieveList(this.sqlSelectReducedFields, null, null, null);
    }

    @Deprecated
    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        Filtering filtering = pageRequest.getFiltering();
        if (filtering == null) {
            filtering = Filtering.defaultBuilder().build();
            pageRequest.setFiltering(filtering);
        }
        Filtering initialFiltering = Filtering.defaultBuilder().filter(this.tableAlias + ".label ->> :language").startsWith((Object)":initial").build();
        filtering.add(initialFiltering);
        Sorting sorting = pageRequest.getSorting();
        if (sorting == null) {
            sorting = Sorting.defaultBuilder().build();
            pageRequest.setSorting(sorting);
        }
        Sorting.defaultBuilder().order(Order.defaultBuilder().property("label").subProperty(language).direction(Direction.ASC).build());
        sorting.and(sorting);
        return this.find(pageRequest, null, Map.of("language", language, "initial", initial));
    }

    public I findOne(UUID uuid, Filtering filtering) {
        if (filtering == null) {
            filtering = Filtering.defaultBuilder().build();
        }
        filtering.add(Filtering.defaultBuilder().filter("uuid").isEquals((Object)new FilterValuePlaceholder(":uuid")).build());
        I result = this.retrieveOne(this.sqlSelectAllFields, this.sqlSelectAllFieldsJoins, filtering, Map.of("uuid", uuid));
        return result;
    }

    public I findOne(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return (I)this.findOne(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        Filtering filtering = Filtering.defaultBuilder().filter("id.identifier").isEquals((Object)new FilterValuePlaceholder(":id")).filter("id.namespace").isEquals((Object)new FilterValuePlaceholder(":namespace")).build();
        I result = this.retrieveOne(this.sqlSelectAllFields, this.sqlSelectAllFieldsJoins, filtering, Map.of("id", identifierId, "namespace", namespace));
        return result;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("created", "label", "lastModified", "type"));
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "description": {
                return this.tableAlias + ".description";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "previewImage": {
                return this.tableAlias + ".previewfileresource";
            }
            case "type": {
                return this.tableAlias + ".identifiable_type";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    protected String getCommonSearchSql(String tblAlias) {
        return "(jsonb_path_exists(" + tblAlias + ".label, ('$.* ? (@ like_regex \"' || :searchTerm || '\" flag \"iq\")')::jsonpath) OR jsonb_path_exists(" + tblAlias + ".description, ('$.* ? (@ like_regex \"' || :searchTerm || '\" flag \"iq\")')::jsonpath))";
    }

    public int getIndex(List<? extends Identifiable> list, Identifiable identifiable) {
        int pos = -1;
        for (Identifiable identifiable2 : list) {
            ++pos;
            if (!identifiable2.getUuid().equals(identifiable.getUuid())) continue;
            return pos;
        }
        return -1;
    }

    public int getIndex(List<UUID> list, UUID uuid) {
        int pos = -1;
        for (UUID u : list) {
            ++pos;
            if (!u.equals(uuid)) continue;
            return pos;
        }
        return -1;
    }

    public List<Locale> getLanguages() {
        String query = "SELECT DISTINCT languages FROM " + this.tableName + " AS " + this.tableAlias + ", jsonb_object_keys(" + this.tableAlias + ".label) AS languages";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Entity> getRelatedEntities(UUID identifiableUuid) {
        String query = "SELECT * FROM entities e INNER JOIN rel_identifiable_entities ref ON e.uuid=ref.entity_uuid WHERE ref.identifiable_uuid = :identifiableUuid ORDER BY ref.sortindex";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("identifiableUuid", identifiableUuid)).mapToBean(Entity.class).map(Entity.class::cast).list());
        return list;
    }

    public List<FileResource> getRelatedFileResources(UUID identifiableUuid) {
        String query = "SELECT * FROM fileresources f INNER JOIN rel_identifiable_fileresources ref ON f.uuid=ref.fileresource_uuid WHERE ref.identifiableUuid = :identifiableUuid ORDER BY ref.sortindex";
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("identifiableUuid", identifiableUuid)).mapToBean(FileResource.class).map(FileResource.class::cast).list());
        return result;
    }

    public String getSqlSelectAllFields() {
        return this.sqlSelectAllFields;
    }

    public String getSqlSelectReducedFields() {
        return this.sqlSelectReducedFields;
    }

    public long retrieveCount(StringBuilder sqlCount, Map<String, Object> argumentMappings) {
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return total;
    }

    public List<I> retrieveList(String fieldsSql, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) {
        String sql = "SELECT " + fieldsSql + ", id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pi_uuid, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (this.sqlSelectAllFieldsJoins != null ? this.sqlSelectAllFieldsJoins : "") + " LEFT JOIN identifiers AS id ON " + this.tableAlias + ".uuid = id.identifiable LEFT JOIN fileresources_image AS file ON " + this.tableAlias + ".previewfileresource = file.uuid" + (String)(orderBy != null ? " " + orderBy : "");
        List result = (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(sql).bindMap(argumentMappings)).reduceRows((map, rowView) -> this.basicReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView)).collect(Collectors.toList()));
        return result;
    }

    protected Integer retrieveNextSortIndexForParentChildren(Jdbi dbi, String tableName, String columNameParentUuid, UUID parentUuid) {
        Integer sortIndex = (Integer)dbi.withHandle(h -> ((Query)h.createQuery("SELECT MAX(sortIndex) + 1 FROM " + tableName + " WHERE " + columNameParentUuid + " = :parent_uuid").bind("parent_uuid", parentUuid)).mapTo(Integer.class).findOne().orElse(null));
        if (sortIndex == null) {
            return 0;
        }
        return sortIndex;
    }

    public I retrieveOne(String fieldsSql, String sqlSelectAllFieldsJoins, Filtering filtering, Map<String, Object> argumentMappings) {
        StringBuilder sql = new StringBuilder("SELECT" + fieldsSql + ", id.uuid id_uuid, id.identifiable id_identifiable, id.namespace id_namespace, id.identifier id_id, file.uuid pi_uuid, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl FROM " + this.tableName + " AS " + this.tableAlias + (sqlSelectAllFieldsJoins != null ? sqlSelectAllFieldsJoins : "") + " LEFT JOIN identifiers AS id ON " + this.tableAlias + ".uuid = id.identifiable LEFT JOIN fileresources_image AS file ON " + this.tableAlias + ".previewfileresource = file.uuid");
        this.addFiltering(filtering, sql);
        Identifiable result = ((Stream)this.dbi.withHandle(h -> ((Query)h.createQuery(sql.toString()).bindMap(argumentMappings)).reduceRows((map, rowView) -> {
            this.fullReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView);
            this.additionalReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView);
        }))).findFirst().orElse(null);
        return (I)result;
    }

    public I save(I identifiable, Map<String, Object> bindings) {
        if (bindings == null) {
            bindings = new HashMap<String, Object>();
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        HashMap<String, Object> finalBindings = new HashMap<String, Object>(bindings);
        if (identifiable.getUuid() == null) {
            identifiable.setUuid(UUID.randomUUID());
        }
        identifiable.setCreated(LocalDateTime.now());
        identifiable.setLastModified(LocalDateTime.now());
        String sql = "INSERT INTO " + this.tableName + "(" + this.sqlInsertFields + ") VALUES (" + this.sqlInsertValues + ")";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(sql).bindMap(finalBindings)).bindBean(identifiable)).execute());
        Set identifiers = identifiable.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)identifiable);
        return identifiable;
    }

    public void saveIdentifiers(Set<Identifier> identifiers, Identifiable identifiable) {
        if (identifiers != null) {
            for (Identifier identifier : identifiers) {
                identifier.setIdentifiable(identifiable.getUuid());
                this.identifierRepository.save(identifier);
            }
        }
    }

    public List<Entity> saveRelatedEntities(UUID identifiableUuid, List<Entity> entities) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_identifiable_entities WHERE identifiable_uuid = :identifiableUuid").bind("identifiableUuid", identifiableUuid)).execute());
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_identifiable_entities(identifiable_uuid, entity_uuid, sortIndex) VALUES(:identifiableUuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("identifiableUuid", identifiableUuid)).bind("entityUuid", entity.getUuid())).bind("sortIndex", this.getIndex(entities, (Identifiable)entity))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getRelatedEntities(identifiableUuid);
    }

    public List<FileResource> saveRelatedFileResources(UUID identifiableUuid, List<FileResource> fileResources) {
        if (fileResources == null) {
            return null;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_identifiable_fileresources WHERE identifiable_uuid = :identifiableUuid").bind("identifiableUuid", identifiableUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_fileresources(identifiable_uuid, fileresource_uuid, sortIndex) VALUES(:identifiableUuid, :fileResourceUuid, :sortIndex)");
            for (FileResource fileResource : fileResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("identifiableUuid", identifiableUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
            }
            preparedBatch.execute();
        });
        return this.getRelatedFileResources(identifiableUuid);
    }

    public I update(I identifiable, Map<String, Object> bindings) {
        if (bindings == null) {
            bindings = new HashMap<String, Object>();
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        HashMap<String, Object> finalBindings = new HashMap<String, Object>(bindings);
        identifiable.setLastModified(LocalDateTime.now());
        String sql = "UPDATE " + this.tableName + " SET" + this.sqlUpdateFieldValues + " WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(sql).bindMap(finalBindings)).bindBean(identifiable)).execute());
        this.identifierRepository.deleteByIdentifiable(identifiable);
        Set identifiers = identifiable.getIdentifiers();
        this.saveIdentifiers(identifiers, (Identifiable)identifiable);
        return identifiable;
    }
}

