/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.security;

import de.digitalcollections.cudami.server.backend.api.repository.security.UserRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserRepositoryImpl
extends JdbiRepositoryImpl
implements UserRepository {
    public static final String MAPPING_PREFIX = "u";
    public static final String TABLE_ALIAS = "u";
    public static final String TABLE_NAME = "users";

    @Autowired
    public UserRepositoryImpl(Jdbi dbi) {
        super(dbi, TABLE_NAME, "u", "u");
    }

    public User create() {
        return new User();
    }

    public PageResponse<User> find(PageRequest pageRequest) {
        StringBuilder query = new StringBuilder("SELECT * FROM users");
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query.toString()).mapToBean(User.class).map(User.class::cast).list());
        long total = this.count();
        PageResponse pageResponse = new PageResponse(result, pageRequest, total);
        return pageResponse;
    }

    public List<User> findActiveAdminUsers() {
        return (List)this.dbi.withHandle(h -> h.createQuery("SELECT * FROM users WHERE '" + Role.ADMIN.name() + "' = any(roles)").mapToBean(User.class).map(User.class::cast).list());
    }

    public User findByEmail(String email) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM users WHERE email = :email").bind("email", email)).mapToBean(User.class).map(User.class::cast).list());
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    public User findOne(UUID uuid) {
        List users = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT * FROM users WHERE uuid = :uuid").bind("uuid", uuid)).mapToBean(User.class).map(User.class::cast).list());
        if (users.isEmpty()) {
            return null;
        }
        return (User)users.get(0);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return Arrays.asList("email", "firstname", "lastname");
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "email": {
                return "email";
            }
            case "lastname": {
                return "lastname";
            }
            case "firstname": {
                return "firstname";
            }
        }
        return null;
    }

    public User save(User user) {
        user.setUuid(UUID.randomUUID());
        User result = (User)this.dbi.withHandle(h -> ((Query)((Handle)h.registerArrayType(Role.class, "varchar")).createQuery("INSERT INTO users(email, enabled, firstname, lastname, passwordHash, roles, uuid) VALUES (:email, :enabled, :firstname, :lastname, :passwordHash, :roles, :uuid) RETURNING *").bindBean((Object)user)).mapToBean(User.class).findOne().orElse(null));
        return result;
    }

    public User update(User user) {
        User result = (User)this.dbi.withHandle(h -> ((Query)((Handle)h.registerArrayType(Role.class, "varchar")).createQuery("UPDATE users SET email=:email, enabled=:enabled, firstname=:firstname, lastname=:lastname, passwordHash=:passwordHash, roles=:roles, uuid=:uuid WHERE uuid=:uuid RETURNING *").bindBean((Object)user)).mapToBean(User.class).map(User.class::cast).findOne().orElse(null));
        return result;
    }
}

