/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.CollectionRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.ProjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.ItemRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.ImageFileResourceRepositoryImpl;
import de.digitalcollections.model.filter.FilterValuePlaceholder;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class DigitalObjectRepositoryImpl
extends EntityRepositoryImpl<DigitalObject>
implements DigitalObjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "do";
    public static final String TABLE_ALIAS = "d";
    public static final String TABLE_NAME = "digitalobjects";
    @Lazy
    @Autowired
    private CollectionRepositoryImpl collectionRepositoryImpl;
    @Lazy
    @Autowired
    private FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl;
    @Lazy
    @Autowired
    private ImageFileResourceRepositoryImpl imageFileResourceRepositoryImpl;
    @Lazy
    @Autowired
    private ItemRepositoryImpl itemRepositoryImpl;
    @Lazy
    @Autowired
    private ProjectRepositoryImpl projectRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields();
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues();
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return DigitalObjectRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues();
    }

    @Autowired
    public DigitalObjectRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, DigitalObject.class, DigitalObjectRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), DigitalObjectRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), DigitalObjectRepositoryImpl.getSqlInsertFields(), DigitalObjectRepositoryImpl.getSqlInsertValues(), DigitalObjectRepositoryImpl.getSqlUpdateFieldValues());
    }

    public void deleteFileResources(UUID digitalObjectUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
    }

    public SearchPageResponse<Collection> getCollections(UUID digitalObjectUuid, SearchPageRequest searchPageRequest) {
        String tableAliasCollection = this.collectionRepositoryImpl.getTableAlias();
        String tableNameCollection = this.collectionRepositoryImpl.getTableName();
        String commonSql = " FROM " + tableNameCollection + " AS " + tableAliasCollection + " LEFT JOIN collection_digitalobjects AS cd ON " + tableAliasCollection + ".uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        String searchTerm = searchPageRequest.getQuery();
        if (StringUtils.hasText((String)searchTerm)) {
            commonSql = commonSql + " AND " + this.getCommonSearchSql(tableAliasCollection);
            argumentMappings.put("searchTerm", this.escapeTermForJsonpath(searchTerm));
        }
        StringBuilder innerQuery = new StringBuilder("SELECT cd.sortindex AS idx, *" + commonSql);
        Filtering filtering = searchPageRequest.getFiltering();
        if (filtering != null) {
            List filterCriteria = filtering.getFilterCriteria().stream().map(fc -> {
                fc.setFieldName(this.collectionRepositoryImpl.getColumnName(fc.getFieldName()));
                return fc;
            }).collect(Collectors.toList());
            filtering.setFilterCriteria(filterCriteria);
        }
        this.addFiltering((PageRequest)searchPageRequest, innerQuery);
        String orderBy = null;
        if (searchPageRequest.getSorting() == null) {
            orderBy = "ORDER BY idx ASC";
            innerQuery.append(" ").append(orderBy);
        }
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        List result = this.collectionRepositoryImpl.retrieveList(this.collectionRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, countQuery);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new SearchPageResponse(result, searchPageRequest, total);
    }

    public List<FileResource> getFileResources(UUID digitalObjectUuid) {
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        String fieldsSql = this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields();
        StringBuilder innerQuery = new StringBuilder("SELECT df.sortindex AS idx, * FROM " + frTableName + " AS " + frTableAlias + " LEFT JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY idx ASC");
        Map<String, Object> argumentMappings = Map.of("uuid", digitalObjectUuid);
        List<FileResource> fileResources = this.fileResourceMetadataRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return fileResources;
    }

    public List<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) {
        String frTableAlias = this.imageFileResourceRepositoryImpl.getTableAlias();
        String frTableName = this.imageFileResourceRepositoryImpl.getTableName();
        String fieldsSql = this.imageFileResourceRepositoryImpl.getSqlSelectAllFields();
        StringBuilder innerQuery = new StringBuilder("SELECT df.sortindex AS idx, * FROM " + frTableName + " AS " + frTableAlias + " LEFT JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY idx ASC");
        Map<String, Object> argumentMappings = Map.of("uuid", digitalObjectUuid);
        List<ImageFileResource> fileResources = this.imageFileResourceRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return fileResources;
    }

    public Item getItem(UUID digitalObjectUuid) {
        String itTableAlias = this.itemRepositoryImpl.getTableAlias();
        String sqlAdditionalJoins = " LEFT JOIN item_digitalobjects AS ido ON " + itTableAlias + ".uuid = ido.item_uuid";
        Filtering filtering = Filtering.defaultBuilder().filter("ido.digitalobject_uuid").isEquals((Object)new FilterValuePlaceholder(":uuid")).build();
        Item result = (Item)this.itemRepositoryImpl.retrieveOne(this.itemRepositoryImpl.getSqlSelectReducedFields(), sqlAdditionalJoins, filtering, Map.of("uuid", digitalObjectUuid));
        return result;
    }

    public List<Locale> getLanguagesOfCollections(UUID uuid) {
        String collectionTable = this.collectionRepositoryImpl.getTableName();
        String collectionAlias = this.collectionRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + collectionAlias + ".label) as languages FROM " + collectionTable + " AS " + collectionAlias + " LEFT JOIN collection_digitalobjects AS cd ON " + collectionAlias + ".uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public List<Locale> getLanguagesOfProjects(UUID uuid) {
        String projectTable = this.projectRepositoryImpl.getTableName();
        String projectAlias = this.projectRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + projectAlias + ".label) as languages FROM " + projectTable + " AS " + projectAlias + " LEFT JOIN project_digitalobjects AS pd ON " + projectAlias + ".uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public SearchPageResponse<Project> getProjects(UUID digitalObjectUuid, SearchPageRequest searchPageRequest) {
        String prTableAlias = this.projectRepositoryImpl.getTableAlias();
        String prTableName = this.projectRepositoryImpl.getTableName();
        String commonSql = " FROM " + prTableName + " AS " + prTableAlias + " LEFT JOIN project_digitalobjects AS pd ON " + prTableAlias + ".uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        String searchTerm = searchPageRequest.getQuery();
        if (StringUtils.hasText((String)searchTerm)) {
            commonSql = commonSql + " AND " + this.getCommonSearchSql(prTableAlias);
            argumentMappings.put("searchTerm", this.escapeTermForJsonpath(searchTerm));
        }
        StringBuilder innerQuery = new StringBuilder("SELECT pd.sortindex AS idx, *" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, innerQuery);
        String orderBy = null;
        if (searchPageRequest.getSorting() == null) {
            orderBy = "ORDER BY idx ASC";
            innerQuery.append(" ").append(orderBy);
        }
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        List result = this.projectRepositoryImpl.retrieveList(this.projectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, countQuery);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new SearchPageResponse(result, searchPageRequest, total);
    }

    public DigitalObject save(DigitalObject digitalObject) {
        super.save((Identifiable)digitalObject);
        List fileResources = digitalObject.getFileResources();
        this.saveFileResources(digitalObject, fileResources);
        DigitalObject result = (DigitalObject)this.findOne(digitalObject.getUuid());
        return result;
    }

    public List<FileResource> saveFileResources(UUID digitalObjectUuid, List<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
        if (fileResources != null) {
            for (FileResource fileResource : fileResources) {
                if (fileResource.getUuid() != null) continue;
                this.fileResourceMetadataRepositoryImpl.save(fileResource);
            }
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO digitalobject_fileresources(digitalobject_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(digitalObjectUuid);
    }

    public DigitalObject update(DigitalObject digitalObject) {
        super.update((Identifiable)digitalObject);
        DigitalObject result = (DigitalObject)this.findOne(digitalObject.getUuid());
        return result;
    }

    public void setCollectionRepository(CollectionRepositoryImpl collectionRepositoryImpl) {
        this.collectionRepositoryImpl = collectionRepositoryImpl;
    }

    public void setFileResourceMetadataRepository(FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl) {
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }
}

