/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.WebsiteRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.web.WebpageRepositoryImpl;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class WebsiteRepositoryImpl
extends EntityRepositoryImpl<Website>
implements WebsiteRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebsiteRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "ws";
    public static final String TABLE_ALIAS = "w";
    public static final String TABLE_NAME = "websites";
    private final WebpageRepositoryImpl webpageRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", registration_date, url";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :registrationDate, :url";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return WebsiteRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".url " + mappingPrefix + "_url, " + tableAlias + ".registration_date " + mappingPrefix + "_registrationDate";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", registration_date=:registrationDate, url=:url";
    }

    @Autowired
    public WebsiteRepositoryImpl(Jdbi dbi, IdentifierRepository identifierRepository, WebpageRepositoryImpl webpageRepositoryImpl) {
        super(dbi, identifierRepository, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Website.class, WebsiteRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), WebsiteRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), WebsiteRepositoryImpl.getSqlInsertFields(), WebsiteRepositoryImpl.getSqlInsertValues(), WebsiteRepositoryImpl.getSqlUpdateFieldValues());
        this.webpageRepositoryImpl = webpageRepositoryImpl;
    }

    @Override
    public Website findOne(UUID uuid, Filtering filtering) {
        Website website = (Website)super.findOne(uuid, filtering);
        if (website != null) {
            website.setRootPages(this.getRootPages(website));
        }
        return website;
    }

    @Override
    public Website findOne(Identifier identifier) {
        Website website = (Website)super.findOne(identifier);
        if (website != null) {
            website.setRootPages(this.getRootPages(website));
        }
        return website;
    }

    public SearchPageResponse<Webpage> findRootPages(UUID uuid, SearchPageRequest searchPageRequest) {
        String wpTableAlias = this.webpageRepositoryImpl.getTableAlias();
        String wpTableName = this.webpageRepositoryImpl.getTableName();
        String commonSql = " FROM " + wpTableName + " AS " + wpTableAlias + " LEFT JOIN website_webpages ww ON " + wpTableAlias + ".uuid = ww.webpage_uuid WHERE ww.website_uuid = :uuid";
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        String searchTerm = searchPageRequest.getQuery();
        if (StringUtils.hasText((String)searchTerm)) {
            commonSql = commonSql + " AND " + this.getCommonSearchSql(wpTableAlias);
            argumentMappings.put("searchTerm", this.escapeTermForJsonpath(searchTerm));
        }
        StringBuilder innerQuery = new StringBuilder("SELECT ww.sortindex AS idx, *" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, innerQuery);
        String orderBy = null;
        if (searchPageRequest.getSorting() == null) {
            orderBy = "ORDER BY idx ASC";
            innerQuery.append(" ").append(orderBy);
        }
        this.addPageRequestParams((PageRequest)searchPageRequest, innerQuery);
        List result = this.webpageRepositoryImpl.retrieveList(this.webpageRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        this.addFiltering((PageRequest)searchPageRequest, countQuery);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new SearchPageResponse(result, searchPageRequest, total);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("url"));
        return allowedOrderByFields;
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "url": {
                return this.tableAlias + ".url";
            }
        }
        return null;
    }

    public List<Webpage> getRootPages(UUID uuid) {
        String wpTableAlias = this.webpageRepositoryImpl.getTableAlias();
        String wpTableName = this.webpageRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + wpTableName + " AS " + wpTableAlias + " INNER JOIN website_webpages ww ON " + wpTableAlias + ".uuid = ww.webpage_uuid WHERE ww.website_uuid = :uuid");
        List<Webpage> result = this.webpageRepositoryImpl.retrieveList(this.webpageRepositoryImpl.getSqlSelectReducedFields(), innerQuery, Map.of("uuid", uuid), null);
        return result;
    }

    public Website save(Website website) {
        super.save((Identifiable)website);
        Website result = (Website)this.findOne(website.getUuid());
        return result;
    }

    public Website update(Website website) {
        super.update((Identifiable)website);
        Website result = (Website)this.findOne(website.getUuid());
        return result;
    }

    public boolean updateRootPagesOrder(UUID websiteUuid, List<Webpage> rootPages) {
        if (websiteUuid == null || rootPages == null) {
            return false;
        }
        String query = "UPDATE website_webpages SET sortindex = :idx WHERE website_uuid = :websiteUuid AND webpage_uuid = :webpageUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Webpage webpage : rootPages) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("webpageUuid", webpage.getUuid())).bind("websiteUuid", websiteUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

