/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.plugins;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.commons.jdbi.JsonbArgumentFactory;
import de.digitalcollections.commons.jdbi.JsonbColumnMapperFactory;
import de.digitalcollections.model.geo.CoordinateLocation;
import de.digitalcollections.model.identifiable.entity.CustomAttributes;
import de.digitalcollections.model.text.LocalizedStructuredContent;
import de.digitalcollections.model.text.LocalizedText;
import de.digitalcollections.model.view.RenderingHints;
import de.digitalcollections.model.view.RenderingHintsPreviewImage;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.argument.ArgumentFactory;
import org.jdbi.v3.core.mapper.ColumnMapperFactory;
import org.jdbi.v3.core.spi.JdbiPlugin;
import org.wikidata.wdtk.datamodel.interfaces.TimeValue;

public class JsonbJdbiPlugin
implements JdbiPlugin {
    private final ObjectMapper objectMapper;

    public JsonbJdbiPlugin(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void customizeJdbi(Jdbi db) {
        db.registerArgument((ArgumentFactory)new JsonbArgumentFactory(CoordinateLocation.class, this.objectMapper));
        db.registerArgument((ArgumentFactory)new JsonbArgumentFactory(CustomAttributes.class, this.objectMapper));
        db.registerArgument((ArgumentFactory)new JsonbArgumentFactory(LocalizedStructuredContent.class, this.objectMapper));
        db.registerArgument((ArgumentFactory)new JsonbArgumentFactory(LocalizedText.class, this.objectMapper));
        db.registerArgument((ArgumentFactory)new JsonbArgumentFactory(RenderingHints.class, this.objectMapper));
        db.registerArgument((ArgumentFactory)new JsonbArgumentFactory(RenderingHintsPreviewImage.class, this.objectMapper));
        db.registerArgument((ArgumentFactory)new JsonbArgumentFactory(TimeValue.class, this.objectMapper));
        db.registerColumnMapper((ColumnMapperFactory)new JsonbColumnMapperFactory(CoordinateLocation.class, this.objectMapper));
        db.registerColumnMapper((ColumnMapperFactory)new JsonbColumnMapperFactory(CustomAttributes.class, this.objectMapper));
        db.registerColumnMapper((ColumnMapperFactory)new JsonbColumnMapperFactory(LocalizedStructuredContent.class, this.objectMapper));
        db.registerColumnMapper((ColumnMapperFactory)new JsonbColumnMapperFactory(LocalizedText.class, this.objectMapper));
        db.registerColumnMapper((ColumnMapperFactory)new JsonbColumnMapperFactory(RenderingHints.class, this.objectMapper));
        db.registerColumnMapper((ColumnMapperFactory)new JsonbColumnMapperFactory(RenderingHintsPreviewImage.class, this.objectMapper));
        db.registerColumnMapper((ColumnMapperFactory)new JsonbColumnMapperFactory(TimeValue.class, this.objectMapper));
    }
}

