/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database;

import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.Sorting;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractPagingAndSortingRepositoryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPagingAndSortingRepositoryImpl.class);

    public void addLimit(PageRequest pageRequest, StringBuilder sqlQuery) {
        int pageSize;
        if (pageRequest != null && (pageSize = pageRequest.getPageSize()) > 0) {
            sqlQuery.append(" ").append("LIMIT").append(" ").append(pageSize);
        }
    }

    public void addOffset(PageRequest pageRequest, StringBuilder sqlQuery) {
        int offset;
        if (pageRequest != null && (offset = pageRequest.getOffset()) >= 0) {
            sqlQuery.append(" ").append("OFFSET").append(" ").append(offset);
        }
    }

    public void addOrderBy(PageRequest pageRequest, StringBuilder sqlQuery) {
        Sorting sorting;
        String orderBy;
        if (pageRequest != null && StringUtils.hasText((String)(orderBy = this.getOrderBy(sorting = pageRequest.getSorting())))) {
            sqlQuery.append(" ORDER BY ").append(orderBy);
        }
    }

    protected void addPageRequestParams(PageRequest pageRequest, StringBuilder sqlQuery) {
        if (pageRequest != null) {
            this.addOrderBy(pageRequest, sqlQuery);
            this.addLimit(pageRequest, sqlQuery);
            this.addOffset(pageRequest, sqlQuery);
        }
    }

    protected abstract List<String> getAllowedOrderByFields();

    protected abstract String getColumnName(String var1);

    public String getOrderBy(Sorting sorting) {
        if (sorting == null) {
            return null;
        }
        List<String> allowedOrderByFields = this.getAllowedOrderByFields();
        String orderBy = Optional.ofNullable(sorting.getOrders()).orElse(Collections.emptyList()).stream().filter(o -> {
            boolean allowedSortField;
            String sortField = o.getProperty();
            boolean bl = allowedSortField = sortField != null && allowedOrderByFields != null && allowedOrderByFields.contains(sortField);
            if (!allowedSortField) {
                LOGGER.warn("'" + sortField + "' not in allowed sort fields! Ignoring it.");
            }
            return allowedSortField;
        }).map(o -> {
            String sortDirection = null;
            Direction direction = o.getDirection();
            sortDirection = direction != null && direction.isDescending() ? "DESC" : "ASC";
            String sortField = o.getProperty();
            Optional subSortField = o.getSubProperty();
            String fullQualifiedColumnName = this.getColumnName(sortField);
            if (subSortField.isEmpty()) {
                return String.format("%s %s", fullQualifiedColumnName, sortDirection);
            }
            return String.format("%s->>'%s' %s", fullQualifiedColumnName, subSortField.get(), sortDirection);
        }).collect(Collectors.joining(","));
        return orderBy;
    }
}

