/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierTypeRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.identifiable.IdentifierType;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifierTypeRepositoryImpl
extends JdbiRepositoryImpl
implements IdentifierTypeRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifierTypeRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "idt";
    public static final String TABLE_ALIAS = "idt";
    public static final String TABLE_NAME = "identifiertypes";

    @Autowired
    public IdentifierTypeRepositoryImpl(Jdbi dbi) {
        super(dbi, TABLE_NAME, "idt", "idt");
    }

    public void delete(List<UUID> uuids) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
    }

    public PageResponse<IdentifierType> find(PageRequest pageRequest) {
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName);
        this.addFiltering(pageRequest, innerQuery, argumentMappings);
        this.addPageRequestParams(pageRequest, innerQuery);
        String sql = innerQuery.toString();
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindMap(argumentMappings)).mapToBean(IdentifierType.class).map(IdentifierType.class::cast).list());
        StringBuilder sqlCount = new StringBuilder("SELECT count(*) FROM " + this.tableName);
        this.addFiltering(pageRequest, sqlCount, argumentMappings);
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return new PageResponse(result, pageRequest, total);
    }

    public IdentifierType findOne(UUID uuid) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE uuid = :uuid";
        IdentifierType identifierType = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return identifierType;
    }

    public IdentifierType findOneByNamespace(String namespace) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE namespace = :namespace";
        IdentifierType identifierType = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("namespace", namespace)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return identifierType;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return Arrays.asList("label", "namespace", "pattern");
    }

    @Override
    protected String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "label": {
                return "label";
            }
            case "namespace": {
                return "namespace";
            }
            case "pattern": {
                return "pattern";
            }
        }
        return null;
    }

    public IdentifierType save(IdentifierType identifierType) {
        identifierType.setUuid(UUID.randomUUID());
        String sql = "INSERT INTO " + this.tableName + "(uuid, label, namespace, pattern) VALUES (:uuid, :label, :namespace, :pattern) RETURNING *";
        IdentifierType result = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)identifierType)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return result;
    }

    public IdentifierType update(IdentifierType identifierType) {
        String sql = "UPDATE " + this.tableName + " SET label=:label, namespace=:namespace, pattern=:pattern WHERE uuid=:uuid RETURNING *";
        IdentifierType result = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)identifierType)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return result;
    }
}

