/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ArticleRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Article;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Family;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class ArticleRepositoryImpl
extends EntityRepositoryImpl<Article>
implements ArticleRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArticleRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "ar";
    public static final String TABLE_ALIAS = "a";
    public static final String TABLE_NAME = "articles";
    private final EntityRepositoryImpl<Entity> entityRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", date_published, text, timevalue_published";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :datePublished, :text::JSONB, :timeValuePublished::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return ArticleRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".date_published " + mappingPrefix + "_datePublished, " + tableAlias + ".timevalue_published " + mappingPrefix + "_timeValuePublished";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", date_published=:datePublished, text=:text::JSONB, timevalue_published=:timeValuePublished::JSONB";
    }

    @Autowired
    public ArticleRepositoryImpl(Jdbi dbi, @Qualifier(value="entityRepositoryImpl") EntityRepositoryImpl<Entity> entityRepositoryImpl) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Article.class, ArticleRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), ArticleRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), ArticleRepositoryImpl.getSqlInsertFields(), ArticleRepositoryImpl.getSqlInsertValues(), ArticleRepositoryImpl.getSqlUpdateFieldValues());
        this.entityRepositoryImpl = entityRepositoryImpl;
    }

    @Override
    public Article findOne(UUID uuid, Filtering filtering) {
        Article article = (Article)super.findOne(uuid, filtering);
        if (article != null) {
            List<Agent> creators = this.getCreators(uuid);
            article.setCreators(creators);
        }
        return article;
    }

    @Override
    public Article findOne(Identifier identifier) {
        Article article = (Article)super.findOne(identifier);
        if (article != null) {
            article.setCreators(this.getCreators(article.getUuid()));
        }
        return article;
    }

    @Override
    public Article findOneByRefId(long refId) {
        Article article = (Article)super.findOneByRefId(refId);
        if (article != null) {
            article.setCreators(this.getCreators(article.getUuid()));
        }
        return article;
    }

    public List<Agent> getCreators(UUID articleUuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT ac.sortindex AS idx, * FROM entities AS e LEFT JOIN article_creators AS ac ON e.uuid = ac.agent_uuid WHERE ac.article_uuid = :uuid ORDER BY ac.sortindex ASC");
        String fieldsSql = this.entityRepositoryImpl.getSqlSelectReducedFields();
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", articleUuid);
        List entityList = this.entityRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        List agents = null;
        if (entityList != null) {
            agents = entityList.stream().map(entity -> {
                EntityType entityType = entity.getEntityType();
                switch (entityType) {
                    case CORPORATE_BODY: {
                        CorporateBody corporateBody = new CorporateBody();
                        corporateBody.setLabel(entity.getLabel());
                        corporateBody.setRefId(entity.getRefId());
                        corporateBody.setUuid(entity.getUuid());
                        return corporateBody;
                    }
                    case FAMILY: {
                        Family family = new Family();
                        family.setLabel(entity.getLabel());
                        family.setRefId(entity.getRefId());
                        family.setUuid(entity.getUuid());
                        return family;
                    }
                    case PERSON: {
                        Person person = new Person();
                        person.setLabel(entity.getLabel());
                        person.setRefId(entity.getRefId());
                        person.setUuid(entity.getUuid());
                        return person;
                    }
                }
                return null;
            }).collect(Collectors.toList());
        }
        return agents;
    }

    @Override
    public List<FileResource> getRelatedFileResources(UUID entityUuid) {
        return this.entityRepositoryImpl.getRelatedFileResources(entityUuid);
    }

    public Article save(Article article) {
        super.save((Identifiable)article);
        List creators = article.getCreators();
        this.saveCreatorsList(article, creators);
        Article result = (Article)this.findOne(article.getUuid());
        return result;
    }

    private void saveCreatorsList(Article article, List<Agent> creators) {
        UUID articleUuid = article.getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM article_creators WHERE article_uuid = :uuid").bind("uuid", articleUuid)).execute());
        if (creators != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO article_creators(article_uuid, agent_uuid, sortIndex) VALUES(:uuid, :agentUuid, :sortIndex)");
                for (Agent agent : creators) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", articleUuid)).bind("agentUuid", agent.getUuid())).bind("sortIndex", this.getIndex(creators, (Identifiable)agent))).add();
                }
                preparedBatch.execute();
            });
        }
    }

    public Article update(Article article) {
        super.update((Identifiable)article);
        List creators = article.getCreators();
        this.saveCreatorsList(article, creators);
        Article result = (Article)this.findOne(article.getUuid());
        return result;
    }
}

