/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.DigitalObjectLinkedDataFileResourceRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.LinkedDataFileResourceRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.resource.LinkedDataFileResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectLinkedDataFileResourceRepositoryImpl
extends JdbiRepositoryImpl
implements DigitalObjectLinkedDataFileResourceRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectLinkedDataFileResourceRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "dold";
    public static final String TABLE_ALIAS = "do_ld";
    public static final String TABLE_NAME = "digitalobject_linkeddataresources";
    private final LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepositoryImpl;

    @Autowired
    public DigitalObjectLinkedDataFileResourceRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepository) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, cudamiConfig.getOffsetForAlternativePaging());
        this.linkedDataFileResourceRepositoryImpl = linkedDataFileResourceRepository;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("digitalobject_uuid", "linkeddata_fileresource_uuid", "sortIndex"));
    }

    @Override
    public String getColumnName(String modelProperty) {
        return null;
    }

    public List<LinkedDataFileResource> getLinkedDataFileResources(UUID digitalObjectUuid) {
        String fieldsSql = LinkedDataFileResourceRepositoryImpl.getSqlSelectAllFields("f", "fr");
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.getTableAlias() + ".sortindex as idx, * FROM fileresources_linkeddata AS f INNER JOIN " + this.getTableName() + " AS " + this.getTableAlias() + " ON f.uuid = " + this.getTableAlias() + ".linkeddata_fileresource_uuid WHERE " + this.getTableAlias() + ".digitalobject_uuid = :uuid ORDER by " + this.getTableAlias() + ".sortindex ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        List<LinkedDataFileResource> linkedDataFileResources = this.linkedDataFileResourceRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return linkedDataFileResources;
    }

    @Override
    protected String getUniqueField() {
        return null;
    }

    public List<LinkedDataFileResource> setLinkedDataFileResources(UUID digitalObjectUuid, List<LinkedDataFileResource> linkedDataFileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_linkeddataresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
        if (linkedDataFileResources != null) {
            for (LinkedDataFileResource linkedDataFileResource : linkedDataFileResources) {
                if (linkedDataFileResource.getUuid() != null) continue;
                this.linkedDataFileResourceRepositoryImpl.save(linkedDataFileResource);
            }
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO digitalobject_linkeddataresources(digitalobject_uuid, linkeddata_fileresource_uuid, sortIndex) VALUES(:uuid, :linkedDataFileResourceUuid, :sortIndex)");
                for (LinkedDataFileResource linkedDataFileResource : linkedDataFileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("linkedDataFileResourceUuid", linkedDataFileResource.getUuid())).bind("sortIndex", this.linkedDataFileResourceRepositoryImpl.getIndex(linkedDataFileResources, (Identifiable)linkedDataFileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getLinkedDataFileResources(digitalObjectUuid);
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }
}

