/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.resource.DigitalObjectRenderingFileResourceRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.FileResourceType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectRenderingFileResourceRepositoryImpl
extends JdbiRepositoryImpl
implements DigitalObjectRenderingFileResourceRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectRenderingFileResourceRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "dorr";
    public static final String TABLE_ALIAS = "do_rr";
    public static final String TABLE_NAME = "digitalobject_renderingresources";
    private FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl;

    @Autowired
    public DigitalObjectRenderingFileResourceRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, cudamiConfig.getOffsetForAlternativePaging());
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    private FileResource fillResourceType(FileResource untypedFileResource) {
        switch (untypedFileResource.getMimeType().getPrimaryType()) {
            case "application": {
                untypedFileResource.setFileResourceType(FileResourceType.APPLICATION);
                break;
            }
            case "audio": {
                untypedFileResource.setFileResourceType(FileResourceType.AUDIO);
                break;
            }
            case "image": {
                untypedFileResource.setFileResourceType(FileResourceType.IMAGE);
                break;
            }
            case "text": {
                untypedFileResource.setFileResourceType(FileResourceType.TEXT);
                break;
            }
            case "video": {
                untypedFileResource.setFileResourceType(FileResourceType.VIDEO);
                break;
            }
        }
        return untypedFileResource;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("digitalobject_uuid", "fileresource_uuid", "sortIndex"));
    }

    @Override
    public String getColumnName(String modelProperty) {
        return null;
    }

    public List<FileResource> getRenderingFileResources(UUID digitalObjectUuid) {
        String fieldsSql = FileResourceMetadataRepositoryImpl.getSqlSelectAllFields("f", "fr");
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.getTableAlias() + ".sortindex as idx, * FROM fileresources AS f INNER JOIN " + this.getTableName() + " AS " + this.getTableAlias() + " ON f.uuid = " + this.getTableAlias() + ".fileresource_uuid WHERE " + this.getTableAlias() + ".digitalobject_uuid = :uuid ORDER by " + this.getTableAlias() + ".sortindex ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", digitalObjectUuid);
        List<FileResource> fileResources = this.fileResourceMetadataRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC").stream().map(f -> this.fillResourceType((FileResource)f)).collect(Collectors.toList());
        return fileResources;
    }

    @Override
    protected String getUniqueField() {
        return null;
    }

    public void removeByDigitalObject(UUID digitalObjectUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.getTableName() + " WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
    }

    public void saveRenderingFileResources(UUID digitalObjectUuid, List<FileResource> renderingResources) {
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO " + this.getTableName() + "(digitalobject_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
            for (FileResource renderingResource : renderingResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("fileResourceUuid", renderingResource.getUuid())).bind("sortIndex", this.fileResourceMetadataRepositoryImpl.getIndex(renderingResources, (Identifiable)renderingResource))).add();
            }
            preparedBatch.execute();
        });
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }
}

