/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.ProjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class ProjectRepositoryImpl
extends EntityRepositoryImpl<Project>
implements ProjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "pr";
    public static final String TABLE_ALIAS = "p";
    public static final String TABLE_NAME = "projects";
    @Lazy
    @Autowired
    private DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", end_date, start_date, text";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :endDate, :startDate, :text::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return ProjectRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".end_date " + mappingPrefix + "_endDate, " + tableAlias + ".start_date " + mappingPrefix + "_startDate";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", end_date=:endDate, start_date=:startDate, text=:text::JSONB";
    }

    @Autowired
    public ProjectRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Project.class, ProjectRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), ProjectRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), ProjectRepositoryImpl.getSqlInsertFields(), ProjectRepositoryImpl.getSqlInsertValues(), ProjectRepositoryImpl.getSqlUpdateFieldValues(), cudamiConfig.getOffsetForAlternativePaging());
    }

    public boolean addDigitalObjects(UUID projectUuid, List<DigitalObject> digitalObjects) {
        if (projectUuid != null && digitalObjects != null) {
            Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "project_digitalobjects", "project_uuid", projectUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO project_digitalobjects(project_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex) ON CONFLICT (project_uuid, digitalobject_uuid) DO NOTHING");
                digitalObjects.forEach(digitalObject -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", projectUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(digitalObjects, (Identifiable)digitalObject))).add());
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID projectUuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        String digitalObjectTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String digitalObjectTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + digitalObjectTableName + " AS " + digitalObjectTableAlias + " INNER JOIN project_digitalobjects AS xtable ON " + digitalObjectTableAlias + ".uuid = xtable.digitalobject_uuid WHERE xtable.project_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", projectUuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.digitalObjectRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public boolean removeDigitalObject(UUID projectUuid, UUID digitalObjectUuid) {
        if (projectUuid != null && digitalObjectUuid != null) {
            String query = "DELETE FROM project_digitalobjects WHERE project_uuid=:projectUuid AND digitalobject_uuid=:digitalObjectUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(query).bind("projectUuid", projectUuid)).bind("digitalObjectUuid", digitalObjectUuid)).execute());
            return true;
        }
        return false;
    }

    public boolean removeDigitalObjectFromAllProjects(UUID digitalObjectUuid) {
        if (digitalObjectUuid == null) {
            return false;
        }
        String query = "DELETE FROM project_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid";
        this.dbi.withHandle(h -> ((Update)h.createUpdate(query).bind("digitalObjectUuid", digitalObjectUuid)).execute());
        return true;
    }

    public Project save(Project project) {
        super.save((Identifiable)project);
        Project result = (Project)this.getByUuid(project.getUuid());
        return result;
    }

    public boolean setDigitalObjects(UUID projectUuid, List<DigitalObject> digitalObjects) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM project_digitalobjects WHERE project_uuid = :uuid").bind("uuid", projectUuid)).execute());
        if (digitalObjects != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO project_digitalobjects(project_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex)");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", projectUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public Project update(Project project) {
        super.update((Identifiable)project);
        Project result = (Project)this.getByUuid(project.getUuid());
        return result;
    }
}

