/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.web;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.web.WebpageRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifiableRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import de.digitalcollections.model.view.BreadcrumbNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebpageRepositoryImpl
extends IdentifiableRepositoryImpl<Webpage>
implements WebpageRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpageRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "wp";
    public static final String TABLE_ALIAS = "w";
    public static final String TABLE_NAME = "webpages";

    public static String getSqlInsertFields() {
        return IdentifiableRepositoryImpl.getSqlInsertFields() + ", publication_end, publication_start, rendering_hints, text";
    }

    public static String getSqlInsertValues() {
        return IdentifiableRepositoryImpl.getSqlInsertValues() + ", :publicationEnd, :publicationStart, :renderingHints::JSONB, :text::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return WebpageRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return IdentifiableRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".publication_end " + mappingPrefix + "_publicationEnd, " + tableAlias + ".publication_start " + mappingPrefix + "_publicationStart, " + tableAlias + ".rendering_hints " + mappingPrefix + "_renderingHints";
    }

    public static String getSqlUpdateFieldValues() {
        return IdentifiableRepositoryImpl.getSqlUpdateFieldValues() + ", publication_end=:publicationEnd, publication_start=:publicationStart, rendering_hints=:renderingHints::JSONB, text=:text::JSONB";
    }

    @Autowired
    public WebpageRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Webpage.class, WebpageRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), WebpageRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), WebpageRepositoryImpl.getSqlInsertFields(), WebpageRepositoryImpl.getSqlInsertValues(), WebpageRepositoryImpl.getSqlUpdateFieldValues(), cudamiConfig.getOffsetForAlternativePaging());
    }

    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        if (parentUuid == null || childrenUuids == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "webpage_webpages", "parent_webpage_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO webpage_webpages(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parentWebpageUuid, :childWebpageUuid, :sortIndex) ON CONFLICT (parent_webpage_uuid, child_webpage_uuid) DO NOTHING");
            childrenUuids.forEach(childUuid -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentWebpageUuid", parentUuid)).bind("childWebpageUuid", childUuid)).bind("sortIndex", nextSortIndex + this.getIndex(childrenUuids, (UUID)childUuid))).add());
            preparedBatch.execute();
        });
        return true;
    }

    public PageResponse<Webpage> findChildren(UUID uuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages AS xtable ON " + this.tableAlias + ".uuid = xtable.child_webpage_uuid WHERE xtable.parent_webpage_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public PageResponse<Webpage> findRootNodes(PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM webpage_webpages WHERE child_webpage_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql);
    }

    public PageResponse<Webpage> findRootWebpagesForWebsite(UUID uuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " LEFT JOIN website_webpages AS xtable ON " + this.tableAlias + ".uuid = xtable.webpage_uuid WHERE xtable.website_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("publicationEnd", "publicationStart"));
        return allowedOrderByFields;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("WITH RECURSIVE breadcrumb (targetId, label, parentId, depth) AS (        SELECT w.uuid AS targetId, w.label AS label, ww.parent_webpage_uuid AS parentId, 99 AS depth        FROM webpages w, webpage_webpages ww        WHERE uuid=:uuid and ww.child_webpage_uuid = w.uuid        UNION ALL        SELECT w.uuid AS targetId, w.label AS label, ww.parent_webpage_uuid AS parentId, depth-1 AS depth        FROM webpages w, webpage_webpages ww, breadcrumb b        WHERE b.targetId = ww.child_webpage_uuid AND ww.parent_webpage_uuid = w.uuid AND ww.parent_webpage_uuid IS NOT NULL    ) SELECT cast(targetId AS VARCHAR) AS targetId, label, parentId, depth FROM breadcrumb UNION SELECT NULL AS targetId, ws.label AS label, NULL AS parentId, 0 AS depth FROM websites ws, website_webpages ww, breadcrumb b WHERE ww.webpage_uuid = b.parentId AND ws.uuid = ww.website_uuid ORDER BY depth ASC").bind("uuid", uuid)).mapTo(BreadcrumbNode.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT cast(w.uuid AS VARCHAR) as targetId, w.label as label        FROM webpages w        WHERE uuid= :uuid").bind("uuid", uuid)).mapTo(BreadcrumbNode.class).list());
        }
        return new BreadcrumbNavigation(result);
    }

    @Override
    public Webpage getByIdentifier(Identifier identifier) {
        Webpage webpage = (Webpage)super.getByIdentifier(identifier);
        if (webpage != null) {
            webpage.setChildren(this.getChildren((Identifiable)webpage));
        }
        return webpage;
    }

    @Override
    public Webpage getByUuidAndFiltering(UUID uuid, Filtering filtering) {
        Webpage webpage = (Webpage)super.getByUuidAndFiltering(uuid, filtering);
        if (webpage != null) {
            webpage.setChildren(this.getChildren((Identifiable)webpage));
        }
        return webpage;
    }

    public List<Webpage> getChildren(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT ww.sortindex AS idx, * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.child_webpage_uuid WHERE ww.parent_webpage_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        List<Webpage> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return result;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "publicationEnd": {
                return this.tableAlias + ".publication_end";
            }
            case "publicationStart": {
                return this.tableAlias + ".publication_start";
            }
        }
        return null;
    }

    public Webpage getParent(UUID uuid) {
        String sqlAdditionalJoins = " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.parent_webpage_uuid";
        Filtering filtering = Filtering.builder().add(FilterCriterion.nativeBuilder().withExpression("ww.child_webpage_uuid").isEquals((Object)uuid).build()).build();
        Webpage result = (Webpage)this.retrieveOne(this.sqlSelectReducedFields, sqlAdditionalJoins, filtering);
        return result;
    }

    public List<Webpage> getParents(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN webpage_webpages ww ON " + this.tableAlias + ".uuid = ww.parent_webpage_uuid WHERE ww.child_webpage_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Webpage> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, null);
        return result;
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT languages FROM " + this.tableName + " AS " + this.tableAlias + ", jsonb_object_keys(" + this.tableAlias + ".label) AS languages WHERE NOT EXISTS (SELECT FROM webpage_webpages WHERE child_webpage_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public Website getWebsite(UUID rootWebpageUuid) {
        String query = "SELECT uuid, refid, label, url FROM websites INNER JOIN website_webpages ww ON uuid = ww.website_uuid WHERE ww.webpage_uuid = :uuid";
        Website result = (Website)this.dbi.withHandle(h -> (Website)((Query)h.createQuery(query).bind("uuid", rootWebpageUuid)).mapToBean(Website.class).one());
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String sql = "DELETE FROM webpage_webpages WHERE parent_webpage_uuid=:parentWebpageUuid AND child_webpage_uuid=:childWebpageUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM webpage_webpages WHERE parent_webpage_uuid=:parentWebpageUuid AND child_webpage_uuid=:childWebpageUuid").bind("parentWebpageUuid", parentUuid)).bind("childWebpageUuid", childUuid)).execute());
        return true;
    }

    public Webpage save(Webpage webpage) {
        super.save((Identifiable)webpage);
        Webpage result = (Webpage)this.getByUuid(webpage.getUuid());
        return result;
    }

    public Webpage saveWithParent(UUID childWebpageUuid, UUID parentWebpageUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "webpage_webpages", "parent_webpage_uuid", parentWebpageUuid);
        String query = "INSERT INTO webpage_webpages(parent_webpage_uuid, child_webpage_uuid, sortIndex) VALUES (:parent_webpage_uuid, :child_webpage_uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_webpage_uuid", parentWebpageUuid)).bind("child_webpage_uuid", childWebpageUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Webpage)this.getByUuid(childWebpageUuid);
    }

    public Webpage saveWithParentWebsite(UUID webpageUuid, UUID parentWebsiteUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "website_webpages", "website_uuid", parentWebsiteUuid);
        String query = "INSERT INTO website_webpages(website_uuid, webpage_uuid, sortIndex) VALUES (:parent_website_uuid, :webpage_uuid, :sortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("parent_website_uuid", parentWebsiteUuid)).bind("webpage_uuid", webpageUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Webpage)this.getByUuid(webpageUuid);
    }

    public Webpage update(Webpage webpage) {
        super.update((Identifiable)webpage);
        Webpage result = (Webpage)this.getByUuid(webpage.getUuid());
        return result;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<Webpage> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        String query = "UPDATE webpage_webpages SET sortindex = :idx WHERE child_webpage_uuid = :childWebpageUuid AND parent_webpage_uuid = :parentWebpageUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Webpage webpage : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childWebpageUuid", webpage.getUuid())).bind("parentWebpageUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

