/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class IdentifierRepositoryImpl
extends JdbiRepositoryImpl
implements IdentifierRepository {
    public static final String MAPPING_PREFIX = "id";
    public static final String SQL_INSERT_FIELDS = " uuid, created, identifiable, namespace, identifier, last_modified";
    public static final String SQL_INSERT_VALUES = " :uuid, :created, :identifiable, :namespace, :id, :lastModified";
    public static final String TABLE_ALIAS = "id";
    public static final String SQL_REDUCED_FIELDS_ID;
    public static final String SQL_FULL_FIELDS_ID;
    public static final String TABLE_NAME = "identifiers";

    @Autowired
    public IdentifierRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "id", "id", cudamiConfig.getOffsetForAlternativePaging());
        dbi.registerRowMapper(BeanMapper.factory(Identifier.class, (String)"id"));
    }

    public void delete(List<UUID> uuids) {
        if (uuids == null || uuids.isEmpty()) {
            return;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
    }

    public void deleteByIdentifiable(UUID identifiableUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE identifiable = :uuid").bind("uuid", identifiableUuid)).execute());
    }

    public PageResponse<Identifier> find(PageRequest pageRequest) {
        String selectSql = "SELECT " + SQL_REDUCED_FIELDS_ID + " FROM " + this.tableName + " AS " + this.tableAlias;
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        String searchTerm = pageRequest.getSearchTerm();
        boolean hasSearchTerm = StringUtils.hasText((String)searchTerm);
        String executedSearchTerm = null;
        if (hasSearchTerm) {
            selectSql = selectSql + " WHERE namespace ILIKE '%' || :searchTerm || '%'";
            executedSearchTerm = searchTerm;
            argumentMappings.put("searchTerm", executedSearchTerm);
        }
        StringBuilder innerQuery = new StringBuilder(selectSql);
        this.addFiltering(pageRequest, innerQuery, argumentMappings);
        this.addPageRequestParams(pageRequest, innerQuery);
        String sql = innerQuery.toString();
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindMap(argumentMappings)).mapTo(Identifier.class).list());
        String countSql = "SELECT count(*) FROM " + this.tableName;
        if (hasSearchTerm) {
            countSql = countSql + " WHERE namespace ILIKE '%' || :searchTerm || '%'";
        }
        StringBuilder sqlCount = new StringBuilder(countSql);
        this.addFiltering(pageRequest, sqlCount, argumentMappings);
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return new PageResponse(result, pageRequest, total);
    }

    public List<Identifier> findByIdentifiable(UUID uuidIdentifiable) {
        String sql = "SELECT " + SQL_FULL_FIELDS_ID + " FROM " + this.tableName + " " + this.tableAlias + " WHERE identifiable = :uuid";
        return (List)this.dbi.withHandle(h -> (List)((Query)h.createQuery(sql).bind("uuid", uuidIdentifiable)).mapTo(Identifier.class).collect(Collectors.toList()));
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("id", "identifiable", "namespace"));
    }

    public Identifier getByNamespaceAndId(String namespace, String id) {
        String sql = "SELECT " + SQL_FULL_FIELDS_ID + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE namespace = :namespace, identifier = :identifier";
        Identifier identifier = (Identifier)this.dbi.withHandle(h -> ((Query)((Query)h.createQuery(sql).bind("namespace", namespace)).bind("identifier", id)).mapTo(Identifier.class).findOne().orElse(null));
        return identifier;
    }

    public Identifier getByUuid(UUID identifierUuid) {
        String sql = "SELECT " + SQL_FULL_FIELDS_ID + " FROM " + this.tableName + " " + this.tableAlias + " WHERE uuid = :uuid";
        Identifier result = (Identifier)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", identifierUuid)).mapTo(Identifier.class).findOne().orElse(null));
        return result;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "id": {
                return this.tableAlias + ".id";
            }
            case "identifiable": {
                return this.tableAlias + ".identifiable";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "namespace": {
                return this.tableAlias + ".namespace";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    public Identifier save(Identifier identifier) {
        identifier.setUuid(UUID.randomUUID());
        identifier.setCreated(LocalDateTime.now());
        identifier.setLastModified(LocalDateTime.now());
        String sql = "INSERT INTO " + this.tableName + "(  uuid, created, identifiable, namespace, identifier, last_modified ) VALUES (  :uuid, :created, :identifiable, :namespace, :id, :lastModified ) RETURNING *, identifier id";
        Identifier result = (Identifier)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)identifier)).mapToBean(Identifier.class).findOne().orElse(null));
        return result;
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }

    public Identifier update(Identifier identifier) {
        throw new UnsupportedOperationException("An update on identifiable, namespace and identifier has no use case.");
    }

    static {
        SQL_FULL_FIELDS_ID = SQL_REDUCED_FIELDS_ID = String.format(" %1$s.uuid %2$s_uuid, %1$s.created %2$s_created, %1$s.identifiable %2$s_identifiable, %1$s.namespace %2$s_namespace, %1$s.identifier %2$s_id, %1$s.last_modified %2$s_lastModified", "id", "id");
    }
}

