/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.alias;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.UrlAliasRepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.text.LocalizedText;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class UrlAliasRepositoryImpl
extends JdbiRepositoryImpl
implements UrlAliasRepository {
    public static final String MAPPING_PREFIX = "ua";
    private static final Map<String, String> PROPERTY_COLUMN_MAPPING;
    public static final String TABLE_ALIAS = "ua";
    public static final String TABLE_NAME = "url_aliases";
    public static final String WEBSITESALIAS = "webs";
    public static final String WEBSITESJOIN;

    public static String getSelectFields(boolean withWebsite) {
        Stream<String> selectFields = PROPERTY_COLUMN_MAPPING.entrySet().stream().map(e -> String.format("%s.%s %s_%s", "ua", e.getValue(), "ua", e.getKey()));
        if (withWebsite) {
            selectFields = Stream.concat(selectFields, Stream.of("uuid", "label", "url").map(col -> String.format("%1$s.%2$s %1$s_%2$s", WEBSITESALIAS, col)));
        }
        return selectFields.collect(Collectors.joining(", "));
    }

    @Autowired
    public UrlAliasRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "ua", "ua", cudamiConfig.getOffsetForAlternativePaging());
        dbi.registerRowMapper(BeanMapper.factory(UrlAlias.class, (String)"ua"));
    }

    public int delete(List<UUID> urlAliasUuids) throws UrlAliasRepositoryException {
        if (urlAliasUuids.isEmpty()) {
            return 0;
        }
        String sql = "DELETE FROM " + this.tableName + " WHERE uuid in (<aliasUuids>);";
        try {
            return (Integer)this.dbi.withHandle(h -> ((Update)h.createUpdate(sql).bindList("aliasUuids", (Iterable)urlAliasUuids)).execute());
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    private UUID extractWebsiteUuid(UrlAlias urlAlias) {
        if (urlAlias == null) {
            return null;
        }
        return urlAlias.getWebsite() != null ? urlAlias.getWebsite().getUuid() : null;
    }

    public PageResponse<LocalizedUrlAliases> find(PageRequest pageRequest) throws UrlAliasRepositoryException {
        long count;
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + WEBSITESJOIN);
        FilterCriterion slug = StringUtils.hasText((String)pageRequest.getSearchTerm()) ? FilterCriterion.builder().withExpression("slug").contains((Object)pageRequest.getSearchTerm()).build() : null;
        Filtering filtering = pageRequest.getFiltering();
        if (filtering == null) {
            filtering = Filtering.builder().add(slug).build();
        } else {
            filtering.add(slug);
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>(0);
        this.addFiltering(filtering, commonSql, bindings);
        try {
            count = (Long)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT count(*) " + commonSql.toString()).bindMap(bindings)).mapTo(Long.class).findOne().orElse(0L));
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
        if (!pageRequest.hasSorting()) {
            pageRequest.setSorting(new Sorting(new String[]{"slug"}));
        }
        commonSql.insert(0, String.format("SELECT %s ", UrlAliasRepositoryImpl.getSelectFields(true)));
        this.addPageRequestParams(pageRequest, commonSql);
        try {
            UrlAlias[] resultset = (UrlAlias[])this.dbi.withHandle(h -> (UrlAlias[])((Query)h.createQuery(commonSql.toString()).bindMap(bindings)).reduceRows(this::mapRowToUrlAlias).toArray(UrlAlias[]::new));
            return new PageResponse(List.of(new LocalizedUrlAliases(resultset)), pageRequest, count);
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    public LocalizedUrlAliases findAllPrimaryLinks(String slug) throws UrlAliasRepositoryException {
        if (!StringUtils.hasText((String)slug)) {
            return new LocalizedUrlAliases();
        }
        return this.findMainLinks(false, null, slug, false);
    }

    private LocalizedUrlAliases findMainLinks(boolean useWebsite, UUID websiteUuid, String slug, boolean considerLanguage) throws UrlAliasRepositoryException {
        StringBuilder innerSel = new StringBuilder(String.format("(SELECT %2$s.target_uuid, %2$s.target_language FROM %1$s AS %2$s ", this.tableName, this.tableAlias));
        Filtering innerFiltering = Filtering.builder().add(FilterCriterion.builder().withExpression("slug").isEquals((Object)slug).build()).build();
        if (useWebsite) {
            innerFiltering.add(FilterCriterion.builder().withExpression("websiteUuid").isEquals((Object)websiteUuid).build());
        }
        HashMap<String, Object> bindings = new HashMap<String, Object>(0);
        this.addFiltering(innerFiltering, innerSel, bindings);
        innerSel.append(")");
        StringBuilder sql = new StringBuilder("WITH target (uuid, language) AS " + innerSel.toString() + " SELECT " + UrlAliasRepositoryImpl.getSelectFields(true) + " FROM " + this.tableName + " AS " + this.tableAlias + WEBSITESJOIN + " WHERE " + this.tableAlias + ".target_uuid IN (SELECT uuid FROM target)");
        if (considerLanguage) {
            sql.append(" AND " + this.tableAlias + ".target_language IN (SELECT language FROM target)");
        }
        Filtering outerFiltering = Filtering.builder().add(FilterCriterion.builder().withExpression("primary").isEquals((Object)true).build()).build();
        if (useWebsite) {
            outerFiltering.add(FilterCriterion.builder().withExpression("websiteUuid").isEquals((Object)websiteUuid).build());
        }
        this.addFiltering(outerFiltering, sql, bindings);
        try {
            UrlAlias[] resultset = (UrlAlias[])this.dbi.withHandle(h -> (UrlAlias[])((Query)h.createQuery(sql.toString()).bindMap(bindings)).reduceRows(this::mapRowToUrlAlias).toArray(UrlAlias[]::new));
            return new LocalizedUrlAliases(resultset);
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    public LocalizedUrlAliases findPrimaryLinksForWebsite(UUID websiteUuid, String slug, boolean considerLanguage) throws UrlAliasRepositoryException {
        if (!StringUtils.hasText((String)slug)) {
            return new LocalizedUrlAliases();
        }
        return this.findMainLinks(true, websiteUuid, slug, considerLanguage);
    }

    public LocalizedUrlAliases getAllForTarget(UUID uuid) throws UrlAliasRepositoryException {
        if (uuid == null) {
            return new LocalizedUrlAliases();
        }
        StringBuilder sql = new StringBuilder("SELECT " + UrlAliasRepositoryImpl.getSelectFields(true) + " FROM " + this.tableName + " AS " + this.tableAlias + WEBSITESJOIN);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        Filtering target = Filtering.builder().add(FilterCriterion.builder().withExpression("targetUuid").isEquals((Object)uuid).build()).build();
        this.addFiltering(target, sql, bindings);
        try {
            UrlAlias[] resultset = (UrlAlias[])this.dbi.withHandle(h -> (UrlAlias[])((Query)h.createQuery(sql.toString()).bindMap(bindings)).reduceRows(this::mapRowToUrlAlias).toArray(UrlAlias[]::new));
            return new LocalizedUrlAliases(resultset);
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("created", "lastPublished", "\"primary\"", "slug", "targetLanguage"));
    }

    private String getAssignmentsForUpdate() {
        return PROPERTY_COLUMN_MAPPING.entrySet().stream().filter(e -> !((String)e.getKey()).equals("created") && !((String)e.getKey()).equals("uuid")).map(e -> String.format("%s = :%s", ((String)e.getValue()).equals("primary") ? "\"primary\"" : e.getValue(), e.getKey())).collect(Collectors.joining(", "));
    }

    public UrlAlias getByUuid(UUID uuid) throws UrlAliasRepositoryException {
        if (uuid == null) {
            return null;
        }
        StringBuilder sql = new StringBuilder("SELECT " + UrlAliasRepositoryImpl.getSelectFields(true) + " FROM " + this.tableName + " AS " + this.tableAlias + WEBSITESJOIN);
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        this.addFiltering(Filtering.builder().add(FilterCriterion.builder().withExpression("uuid").isEquals((Object)uuid).build()).build(), sql, bindings);
        try {
            return (UrlAlias)this.dbi.withHandle(h -> ((Query)h.createQuery(sql.toString()).bindMap(bindings)).reduceRows(this::mapRowToUrlAlias).findFirst().orElse(null));
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    @Override
    public String getColumnName(String modelProperty) {
        return this.tableAlias + "." + PROPERTY_COLUMN_MAPPING.get(modelProperty);
    }

    private String getColumnsForInsert() {
        return PROPERTY_COLUMN_MAPPING.values().stream().map(col -> col.equals("primary") ? "\"primary\"" : col).collect(Collectors.joining(", "));
    }

    private String getPlaceholdersForInsert() {
        return PROPERTY_COLUMN_MAPPING.keySet().stream().map(prop -> ":" + prop).collect(Collectors.joining(", "));
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    public boolean hasUrlAlias(String slug, UUID websiteUuid, Locale targetLanguage) throws UrlAliasRepositoryException {
        if (!StringUtils.hasText((String)slug)) {
            throw new UrlAliasRepositoryException("UrlAliasRepository.hasUrlAlias: Parameter 'slug' must not be null or empty.");
        }
        StringBuilder sql = new StringBuilder("SELECT uuid FROM " + this.tableName + " AS " + this.tableAlias);
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("websiteUuid").isEquals((Object)websiteUuid).build()).build();
        filtering.add(FilterCriterion.builder().withExpression("targetLanguage").isEquals((Object)targetLanguage.getLanguage()).build());
        filtering.add(FilterCriterion.builder().withExpression("slug").isEquals((Object)slug).build());
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        this.addFiltering(filtering, sql, bindings);
        try {
            return 0 < (Integer)this.dbi.withHandle(h -> (Integer)((Query)h.createQuery(sql.toString()).bindMap(bindings)).reduceRows((Object)0, (count, row) -> {
                count = count + 1;
                return count;
            }));
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    private void mapRowToUrlAlias(Map<UUID, UrlAlias> map, RowView row) {
        UrlAlias alias = map.compute((UUID)row.getColumn(this.mappingPrefix + "_uuid", UUID.class), (uuid, urlAlias) -> urlAlias != null ? urlAlias : (UrlAlias)row.getRow(UrlAlias.class));
        if (alias != null && row.getColumn("webs_uuid", UUID.class) != null) {
            Website website = new Website((URL)row.getColumn("webs_url", URL.class));
            website.setUuid((UUID)row.getColumn("webs_uuid", UUID.class));
            website.setLabel((LocalizedText)row.getColumn("webs_label", LocalizedText.class));
            alias.setWebsite(website);
        }
    }

    public UrlAlias save(UrlAlias urlAlias) throws UrlAliasRepositoryException {
        if (urlAlias == null) {
            return null;
        }
        if (urlAlias.getUuid() == null) {
            urlAlias.setUuid(UUID.randomUUID());
        }
        if (urlAlias.getCreated() == null) {
            urlAlias.setCreated(LocalDateTime.now());
        }
        String sql = "INSERT INTO " + this.tableName + " (" + this.getColumnsForInsert() + ") VALUES (" + this.getPlaceholdersForInsert() + ") RETURNING uuid;";
        try {
            UUID newUuid = (UUID)this.dbi.withHandle(h -> ((Query)((Query)((Query)h.createQuery(sql).bindBean((Object)urlAlias)).bind("websiteUuid", this.extractWebsiteUuid(urlAlias))).bind("targetLanguage", urlAlias.getTargetLanguage().getLanguage())).mapTo(UUID.class).findOne().orElse(null));
            return this.getByUuid(newUuid);
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        return false;
    }

    public UrlAlias update(UrlAlias urlAlias) throws UrlAliasRepositoryException {
        if (urlAlias == null) {
            return null;
        }
        String sql = "UPDATE " + this.tableName + " SET " + this.getAssignmentsForUpdate() + " WHERE uuid = :uuid;";
        try {
            int affected = (Integer)this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(sql).bindBean((Object)urlAlias)).bind("websiteUuid", this.extractWebsiteUuid(urlAlias))).bind("targetLanguage", urlAlias.getTargetLanguage().getLanguage())).execute());
            if (affected != 1) {
                throw new UrlAliasRepositoryException(String.format("Update of '%s' went wrong. Affected rows: %d", urlAlias.getUuid(), affected));
            }
            return this.getByUuid(urlAlias.getUuid());
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new UrlAliasRepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new UrlAliasRepositoryException((Throwable)e);
        }
    }

    static {
        WEBSITESJOIN = String.format(" LEFT JOIN websites %1$s ON %1$s.uuid = %2$s.website_uuid ", WEBSITESALIAS, "ua");
        PROPERTY_COLUMN_MAPPING = new LinkedHashMap<String, String>(10);
        PROPERTY_COLUMN_MAPPING.put("created", "created");
        PROPERTY_COLUMN_MAPPING.put("lastPublished", "last_published");
        PROPERTY_COLUMN_MAPPING.put("primary", "primary");
        PROPERTY_COLUMN_MAPPING.put("slug", "slug");
        PROPERTY_COLUMN_MAPPING.put("targetIdentifiableObjectType", "target_identifiable_objecttype");
        PROPERTY_COLUMN_MAPPING.put("targetIdentifiableType", "target_identifiable_type");
        PROPERTY_COLUMN_MAPPING.put("targetLanguage", "target_language");
        PROPERTY_COLUMN_MAPPING.put("targetUuid", "target_uuid");
        PROPERTY_COLUMN_MAPPING.put("uuid", "uuid");
        PROPERTY_COLUMN_MAPPING.put("websiteUuid", "website_uuid");
    }
}

