/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.DigitalObjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.CollectionRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.ProjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.CorporateBodyRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.PersonRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.geo.location.GeoLocationRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.ItemRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.ImageFileResourceRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.LinkedDataFileResourceRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.production.CreationInfo;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class DigitalObjectRepositoryImpl
extends EntityRepositoryImpl<DigitalObject>
implements DigitalObjectRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitalObjectRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "do";
    public static final String TABLE_ALIAS = "d";
    private static final String SQL_SELECT_ALL_FIELDS_JOINS = " LEFT JOIN licenses AS li ON d.license_uuid = li.uuid";
    public static final String TABLE_NAME = "digitalobjects";
    @Lazy
    @Autowired
    private EntityRepositoryImpl<Agent> agentEntityRepositoryImpl;
    @Lazy
    @Autowired
    private CollectionRepositoryImpl collectionRepositoryImpl;
    @Lazy
    @Autowired
    private CorporateBodyRepositoryImpl corporateBodyRepositoryImpl;
    @Lazy
    @Autowired
    private FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl;
    @Lazy
    @Autowired
    private GeoLocationRepositoryImpl geoLocationRepositoryImpl;
    @Lazy
    @Autowired
    private EntityRepositoryImpl<GeoLocation> geolocationEntityRepositoryImpl;
    @Lazy
    @Autowired
    private ImageFileResourceRepositoryImpl imageFileResourceRepositoryImpl;
    @Lazy
    @Autowired
    private ItemRepositoryImpl itemRepositoryImpl;
    @Lazy
    @Autowired
    private LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepositoryImpl;
    @Lazy
    @Autowired
    private PersonRepositoryImpl personRepositoryImpl;
    @Lazy
    @Autowired
    private ProjectRepositoryImpl projectRepositoryImpl;

    private static BiFunction<Map<UUID, DigitalObject>, RowView, Map<UUID, DigitalObject>> createAdditionalReduceRowsBiFunction() {
        return (map, rowView) -> {
            Integer numberOfBinaryResources;
            DigitalObject digitalObject = (DigitalObject)map.get(rowView.getColumn("do_uuid", UUID.class));
            License license = (License)rowView.getRow(License.class);
            if (license.getUuid() != null) {
                digitalObject.setLicense(license);
            }
            UUID creationCreatorUuid = (UUID)rowView.getColumn("do_creation_creator_uuid", UUID.class);
            LocalDate creationDate = (LocalDate)rowView.getColumn("do_creation_date", LocalDate.class);
            UUID creationGeolocationUuid = (UUID)rowView.getColumn("do_creation_geolocation_uuid", UUID.class);
            if (creationCreatorUuid != null || creationDate != null || creationGeolocationUuid != null) {
                CreationInfo creationInfo = new CreationInfo();
                if (creationCreatorUuid != null) {
                    creationInfo.setCreator(((Agent.AgentBuilder)Agent.builder().uuid(creationCreatorUuid)).build());
                }
                if (creationDate != null) {
                    creationInfo.setDate(creationDate);
                }
                if (creationGeolocationUuid != null) {
                    creationInfo.setGeoLocation(((GeoLocation.GeoLocationBuilder)GeoLocation.builder().uuid(creationGeolocationUuid)).build());
                }
                digitalObject.setCreationInfo(creationInfo);
            }
            digitalObject.setNumberOfBinaryResources((numberOfBinaryResources = (Integer)rowView.getColumn("do_number_binaryresources", Integer.class)) != null ? numberOfBinaryResources : 0);
            return map;
        };
    }

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", creation_geolocation_uuid, creation_date, creation_creator_uuid, item_uuid, license_uuid, number_binaryresources, parent_uuid";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :creationInfo?.geoLocation?.uuid, :creationInfo?.date, :creationInfo?.creator?.uuid, :item?.uuid, :license?.uuid, :numberOfBinaryResources, :parent?.uuid";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return DigitalObjectRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", li.uuid l_uuid, li.label l_label, li.url l_url, li.acronym l_acronym, " + tableAlias + ".creation_creator_uuid " + mappingPrefix + "_creation_creator_uuid, " + tableAlias + ".creation_date " + mappingPrefix + "_creation_date, " + tableAlias + ".creation_geolocation_uuid " + mappingPrefix + "_creation_geolocation_uuid, " + tableAlias + ".number_binaryresources " + mappingPrefix + "_number_binaryresources";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".parent_uuid " + mappingPrefix + "_parent_uuid";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", creation_geolocation_uuid=:creationInfo?.geoLocation?.uuid, creation_date=:creationInfo?.date, creation_creator_uuid=:creationInfo?.creator?.uuid, item_uuid=:item?.uuid, license_uuid=:license?.uuid, number_binaryresources=:numberOfBinaryResources, parent_uuid=:parent?.uuid";
    }

    @Autowired
    public DigitalObjectRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class)DigitalObject.class, DigitalObjectRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), DigitalObjectRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), DigitalObjectRepositoryImpl.getSqlInsertFields(), DigitalObjectRepositoryImpl.getSqlInsertValues(), DigitalObjectRepositoryImpl.getSqlUpdateFieldValues(), SQL_SELECT_ALL_FIELDS_JOINS, DigitalObjectRepositoryImpl.createAdditionalReduceRowsBiFunction(), cudamiConfig.getOffsetForAlternativePaging());
    }

    public void deleteFileResources(UUID digitalObjectUuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
    }

    @Override
    protected void extendReducedIdentifiable(Identifiable identifiable, RowView rowView) {
        super.extendReducedIdentifiable(identifiable, rowView);
        if (!(identifiable instanceof DigitalObject)) {
            return;
        }
        UUID parentUuid = (UUID)rowView.getColumn("do_parent_uuid", UUID.class);
        if (parentUuid != null) {
            ((DigitalObject)identifiable).setParent(((DigitalObject.DigitalObjectBuilder)DigitalObject.builder().uuid(parentUuid)).build());
        }
    }

    private void fillAttributes(DigitalObject digitalObject) {
        CreationInfo creationInfo;
        UUID previewImageUuid;
        if (digitalObject == null) {
            return;
        }
        UUID uUID = previewImageUuid = digitalObject.getPreviewImage() != null ? digitalObject.getPreviewImage().getUuid() : null;
        if (previewImageUuid != null) {
            digitalObject.setPreviewImage((ImageFileResource)this.imageFileResourceRepositoryImpl.getByUuid(previewImageUuid));
        }
        if ((creationInfo = digitalObject.getCreationInfo()) != null) {
            DigitalObject parent;
            UUID parentUuid;
            GeoLocation geolocationEntity;
            UUID geolocationUuid;
            Agent creatorEntity;
            UUID creatorUuid;
            UUID uUID2 = creatorUuid = creationInfo.getCreator() != null ? creationInfo.getCreator().getUuid() : null;
            if (creatorUuid != null && (creatorEntity = (Agent)this.agentEntityRepositoryImpl.getByUuid(creatorUuid)) != null) {
                switch (creatorEntity.getEntityType()) {
                    case CORPORATE_BODY: {
                        creationInfo.setCreator((Agent)this.corporateBodyRepositoryImpl.getByUuid(creatorUuid));
                        break;
                    }
                    case PERSON: {
                        creationInfo.setCreator((Agent)this.personRepositoryImpl.getByUuid(creatorUuid));
                        break;
                    }
                    default: {
                        creationInfo.setCreator(creatorEntity);
                    }
                }
            }
            UUID uUID3 = geolocationUuid = creationInfo.getGeoLocation() != null ? creationInfo.getGeoLocation().getUuid() : null;
            if (geolocationUuid != null && (geolocationEntity = (GeoLocation)this.geolocationEntityRepositoryImpl.getByUuid(geolocationUuid)) != null) {
                switch (geolocationEntity.getEntityType()) {
                    default: 
                }
                creationInfo.setGeoLocation((GeoLocation)this.geoLocationRepositoryImpl.getByUuid(geolocationUuid));
            }
            UUID uUID4 = parentUuid = digitalObject.getParent() != null ? digitalObject.getParent().getUuid() : null;
            if (parentUuid != null && (parent = (DigitalObject)this.getByUuid(parentUuid)) != null) {
                digitalObject.setParent(parent);
            }
        }
    }

    public PageResponse<Collection> findCollections(UUID digitalObjectUuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        String collectionTableAlias = this.collectionRepositoryImpl.getTableAlias();
        String collectionTableName = this.collectionRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + collectionTableName + " AS " + collectionTableAlias + " INNER JOIN collection_digitalobjects AS xtable ON " + collectionTableAlias + ".uuid = xtable.collection_uuid WHERE xtable.digitalobject_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", digitalObjectUuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.collectionRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.collectionRepositoryImpl.retrieveList(this.collectionRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public PageResponse<Project> findProjects(UUID digitalObjectUuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        String prTableAlias = this.projectRepositoryImpl.getTableAlias();
        String prTableName = this.projectRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + prTableName + " AS " + prTableAlias + " INNER JOIN project_digitalobjects AS xtable ON " + prTableAlias + ".uuid = xtable.project_uuid WHERE xtable.digitalobject_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", digitalObjectUuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.projectRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.projectRepositoryImpl.retrieveList(this.projectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    @Override
    public DigitalObject getByIdentifier(Identifier identifier) {
        DigitalObject digitalObject = (DigitalObject)super.getByIdentifier(identifier);
        this.fillAttributes(digitalObject);
        return digitalObject;
    }

    @Override
    public DigitalObject getByUuidAndFiltering(UUID uuid, Filtering filtering) {
        DigitalObject digitalObject = (DigitalObject)super.getByUuidAndFiltering(uuid, filtering);
        this.fillAttributes(digitalObject);
        return digitalObject;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "parent.uuid": {
                return this.tableAlias + ".parent_uuid";
            }
        }
        return null;
    }

    public List<FileResource> getFileResources(UUID digitalObjectUuid) {
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        String fieldsSql = this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields();
        StringBuilder innerQuery = new StringBuilder("SELECT df.sortindex AS idx, * FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        List<FileResource> fileResources = this.fileResourceMetadataRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return fileResources;
    }

    public List<ImageFileResource> getImageFileResources(UUID digitalObjectUuid) {
        String frTableAlias = this.imageFileResourceRepositoryImpl.getTableAlias();
        String frTableName = this.imageFileResourceRepositoryImpl.getTableName();
        String fieldsSql = this.imageFileResourceRepositoryImpl.getSqlSelectAllFields();
        StringBuilder innerQuery = new StringBuilder("SELECT df.sortindex AS idx, * FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN digitalobject_fileresources AS df ON " + frTableAlias + ".uuid = df.fileresource_uuid WHERE df.digitalobject_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", digitalObjectUuid);
        List<ImageFileResource> fileResources = this.imageFileResourceRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return fileResources;
    }

    public Item getItem(UUID digitalObjectUuid) {
        String itTableAlias = this.itemRepositoryImpl.getTableAlias();
        String sqlAdditionalJoins = " LEFT JOIN item_digitalobjects AS ido ON " + itTableAlias + ".uuid = ido.item_uuid";
        Filtering filtering = Filtering.builder().add(FilterCriterion.nativeBuilder().withExpression("ido.digitalobject_uuid").isEquals((Object)digitalObjectUuid).build()).build();
        Item result = (Item)this.itemRepositoryImpl.retrieveOne(this.itemRepositoryImpl.getSqlSelectReducedFields(), sqlAdditionalJoins, filtering);
        return result;
    }

    public List<Locale> getLanguagesOfCollections(UUID uuid) {
        String collectionTable = this.collectionRepositoryImpl.getTableName();
        String collectionAlias = this.collectionRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + collectionAlias + ".label) as languages FROM " + collectionTable + " AS " + collectionAlias + " INNER JOIN collection_digitalobjects AS cd ON " + collectionAlias + ".uuid = cd.collection_uuid WHERE cd.digitalobject_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public List<Locale> getLanguagesOfProjects(UUID uuid) {
        String projectTable = this.projectRepositoryImpl.getTableName();
        String projectAlias = this.projectRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + projectAlias + ".label) as languages FROM " + projectTable + " AS " + projectAlias + " INNER JOIN project_digitalobjects AS pd ON " + projectAlias + ".uuid = pd.project_uuid WHERE pd.digitalobject_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public DigitalObject save(DigitalObject digitalObject) {
        super.save((Identifiable)digitalObject);
        DigitalObject result = (DigitalObject)this.getByUuid(digitalObject.getUuid());
        return result;
    }

    public void setAgentEntityRepository(EntityRepositoryImpl<Agent> agentEntityRepositoryImpl) {
        this.agentEntityRepositoryImpl = agentEntityRepositoryImpl;
    }

    public void setCollectionRepository(CollectionRepositoryImpl collectionRepositoryImpl) {
        this.collectionRepositoryImpl = collectionRepositoryImpl;
    }

    public void setCorporateBodyRepository(CorporateBodyRepositoryImpl corporateBodyRepositoryImpl) {
        this.corporateBodyRepositoryImpl = corporateBodyRepositoryImpl;
    }

    public void setFileResourceMetadataRepository(FileResourceMetadataRepositoryImpl<FileResource> fileResourceMetadataRepositoryImpl) {
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    public List<FileResource> setFileResources(UUID digitalObjectUuid, List<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM digitalobject_fileresources WHERE digitalobject_uuid = :uuid").bind("uuid", digitalObjectUuid)).execute());
        if (fileResources != null) {
            for (FileResource fileResource : fileResources) {
                if (fileResource.getUuid() != null) continue;
                this.fileResourceMetadataRepositoryImpl.save(fileResource);
            }
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO digitalobject_fileresources(digitalobject_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", digitalObjectUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(digitalObjectUuid);
    }

    public void setGeoLocationRepositoryImpl(GeoLocationRepositoryImpl geoLocationRepositoryImpl) {
        this.geoLocationRepositoryImpl = geoLocationRepositoryImpl;
    }

    public void setGeolocationEntityRepositoryImpl(EntityRepositoryImpl<GeoLocation> geolocationEntityRepositoryImpl) {
        this.geolocationEntityRepositoryImpl = geolocationEntityRepositoryImpl;
    }

    public void setLinkedDataFileResourceRepository(LinkedDataFileResourceRepositoryImpl linkedDataFileResourceRepositoryImpl) {
        this.linkedDataFileResourceRepositoryImpl = linkedDataFileResourceRepositoryImpl;
    }

    public void setPersonRepository(PersonRepositoryImpl personRepositoryImpl) {
        this.personRepositoryImpl = personRepositoryImpl;
    }

    public DigitalObject update(DigitalObject digitalObject) {
        super.update((Identifiable)digitalObject);
        DigitalObject result = (DigitalObject)this.getByUuid(digitalObject.getUuid());
        return result;
    }
}

