/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.work.ItemRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.AgentRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.WorkRepositoryImpl;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.entity.work.Manifestation;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class ItemRepositoryImpl
extends EntityRepositoryImpl<Item>
implements ItemRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "it";
    public static final String TABLE_ALIAS = "i";
    public static final String TABLE_NAME = "items";
    public static final String SQL_SELECT_ALL_FIELDS_JOINS = String.format(" LEFT JOIN %1$s %2$s ON %2$s.uuid = ANY(%3$s.holder_uuids) ", "agents", "holdertable", "i");
    private final DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;
    private final WorkRepositoryImpl workRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", exemplifies_manifestation, manifestation, holder_uuids, part_of_item";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :exemplifiesManifestation, :manifestation?.uuid, :holder_uuids::UUID[], :partOfItem?.uuid";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return ItemRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".exemplifies_manifestation " + mappingPrefix + "_exemplifies_manifestation";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".part_of_item " + mappingPrefix + "_part_of_item_uuid, " + tableAlias + ".manifestation " + mappingPrefix + "_manifestation_uuid, " + AgentRepositoryImpl.getSqlSelectReducedFields("holdertable", "ag");
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", exemplifies_manifestation=:exemplifiesManifestation, manifestation=:manifestation?.uuid, holder_uuids=:holder_uuids, part_of_item=:partOfItem?.uuid";
    }

    @Autowired
    public ItemRepositoryImpl(Jdbi dbi, @Lazy DigitalObjectRepositoryImpl digitalObjectRepositoryImpl, @Lazy WorkRepositoryImpl workRepositoryImpl, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Item.class, ItemRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), ItemRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), ItemRepositoryImpl.getSqlInsertFields(), ItemRepositoryImpl.getSqlInsertValues(), ItemRepositoryImpl.getSqlUpdateFieldValues(), SQL_SELECT_ALL_FIELDS_JOINS, cudamiConfig.getOffsetForAlternativePaging());
        this.digitalObjectRepositoryImpl = digitalObjectRepositoryImpl;
        this.workRepositoryImpl = workRepositoryImpl;
    }

    public boolean addWork(UUID itemUuid, UUID workUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "item_works", "item_uuid", itemUuid);
        String query = "INSERT INTO item_works (item_uuid, work_uuid, sortindex) VALUES (:itemUuid, :workUuid, :nextSortIndex)";
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate(query).bind("itemUuid", itemUuid)).bind("workUuid", workUuid)).bind("nextSortIndex", nextSortIndex)).execute());
        return true;
    }

    @Override
    protected void extendReducedIdentifiable(Item identifiable, RowView rowView) {
        super.extendReducedIdentifiable(identifiable, rowView);
        Agent holder = null;
        if (rowView.getColumn("ag_uuid", UUID.class) != null) {
            holder = (Agent)rowView.getRow(Agent.class);
        }
        UUID partOfItemUuid = (UUID)rowView.getColumn("it_part_of_item_uuid", UUID.class);
        UUID manifestationUuid = (UUID)rowView.getColumn("it_manifestation_uuid", UUID.class);
        if (identifiable.getHolders() == null) {
            identifiable.setHolders(new ArrayList());
        }
        if (holder != null && !identifiable.getHolders().contains(holder)) {
            identifiable.getHolders().add(holder);
        }
        if (partOfItemUuid != null && identifiable.getPartOfItem() == null) {
            identifiable.setPartOfItem(((Item.ItemBuilder)Item.builder().uuid(partOfItemUuid)).build());
        }
        if (manifestationUuid != null && identifiable.getManifestation() == null) {
            identifiable.setManifestation(((Manifestation.ManifestationBuilder)Manifestation.builder().uuid(manifestationUuid)).build());
        }
    }

    private UUID[] extractHolderUuids(Item item) {
        if (item == null || item.getHolders() == null || item.getHolders().isEmpty()) {
            return null;
        }
        return item.getHolders().stream().collect(ArrayList::new, (result, holder) -> result.add(holder.getUuid()), ArrayList::addAll).toArray(new UUID[1]);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID itemUuid, PageRequest pageRequest) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + doTableName + " AS " + doTableAlias + " WHERE " + doTableAlias + ".item_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", itemUuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.digitalObjectRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT * " + commonSql);
        this.addPageRequestParams(pageRequest, innerQuery);
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "part_of_item.uuid": {
                return this.tableAlias + ".part_of_item";
            }
        }
        return super.getColumnName(modelProperty);
    }

    public List<Locale> getLanguagesOfDigitalObjects(UUID uuid) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + doTableAlias + ".label) as languages FROM " + doTableName + " AS " + doTableAlias + String.format(" WHERE %s.item_uuid = :uuid;", doTableAlias);
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapTo(Locale.class).list());
    }

    public Set<Work> getWorks(UUID itemUuid) {
        String wTableAlias = this.workRepositoryImpl.getTableAlias();
        String wTableName = this.workRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT iw.sortindex AS idx, * FROM " + wTableName + " AS " + wTableAlias + " LEFT JOIN item_works AS iw ON " + wTableAlias + ".uuid = iw.work_uuid WHERE iw.item_uuid = :uuid ORDER BY iw.sortindex ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", itemUuid);
        List result = this.workRepositoryImpl.retrieveList(this.workRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, "ORDER BY idx ASC");
        return result.stream().map(w -> {
            List<Agent> creators = this.workRepositoryImpl.getCreators(w.getUuid());
            w.setCreators(creators);
            return w;
        }).collect(Collectors.toSet());
    }

    public Item save(Item item) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("holder_uuids", this.extractHolderUuids(item));
        super.save(item, (Map<String, Object>)bindings);
        Item result = (Item)this.getByUuid(item.getUuid());
        return result;
    }

    public Item update(Item item) {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("holder_uuids", this.extractHolderUuids(item));
        super.update(item, (Map<String, Object>)bindings);
        Item result = (Item)this.getByUuid(item.getUuid());
        return result;
    }
}

