/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.legal;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.legal.LicenseRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.model.legal.License;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class LicenseRepositoryImpl
extends JdbiRepositoryImpl
implements LicenseRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "l";
    public static final String SQL_INSERT_FIELDS = " uuid, acronym, created, label, last_modified, url";
    public static final String SQL_INSERT_VALUES = " :uuid, :acronym, :created, :label::JSONB, :lastModified, :url";
    public static final String SQL_REDUCED_FIELDS_LI = " li.uuid, li.acronym, li.created, li.label, li.last_modified, li.url";
    public static final String SQL_FULL_FIELDS_LI = " li.uuid, li.acronym, li.created, li.label, li.last_modified, li.url";
    public static final String TABLE_ALIAS = "li";
    public static final String TABLE_NAME = "licenses";

    @Autowired
    public LicenseRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, cudamiConfig.getOffsetForAlternativePaging());
        this.dbi.registerRowMapper(BeanMapper.factory(License.class, (String)MAPPING_PREFIX));
    }

    public void deleteByUrl(URL url) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE url = :url").bind("url", url)).execute());
    }

    public void deleteByUuid(UUID uuid) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid = :uuid").bind("uuid", uuid)).execute());
    }

    public void deleteByUuids(List<UUID> uuids) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
    }

    public PageResponse<License> find(PageRequest pageRequest) {
        return this.find(pageRequest, null, null);
    }

    protected PageResponse<License> find(PageRequest pageRequest, String commonSql, Map<String, Object> argumentMappings) {
        if (argumentMappings == null) {
            argumentMappings = new HashMap<String, Object>(0);
        }
        if (commonSql == null) {
            commonSql = " FROM " + this.tableName + " AS " + this.tableAlias;
        }
        StringBuilder commonSqlBuilder = new StringBuilder((String)commonSql);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSqlBuilder, argumentMappings);
        this.addFiltering(pageRequest, commonSqlBuilder, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".*" + commonSqlBuilder);
        this.addPageRequestParams(pageRequest, innerQuery);
        Object orderBy = this.getOrderBy(pageRequest.getSorting());
        if (StringUtils.hasText((String)orderBy)) {
            orderBy = " ORDER BY " + (String)orderBy;
        }
        List<License> result = this.retrieveList(" li.uuid, li.acronym, li.created, li.label, li.last_modified, li.url", innerQuery, argumentMappings, (String)orderBy);
        StringBuilder sqlCount = new StringBuilder("SELECT count(*)" + commonSqlBuilder);
        long total = this.retrieveCount(sqlCount, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public List<License> getAll() {
        return this.retrieveList(" li.uuid, li.acronym, li.created, li.label, li.last_modified, li.url", null, null);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("acronym", "created", "label", "lastModified", "url"));
    }

    public License getByUrl(URL url) {
        String query = "SELECT * FROM " + this.tableName + " WHERE url=:url";
        return (License)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("url", url)).mapToBean(License.class).findOne().orElse(null));
    }

    public License getByUuid(UUID uuid) {
        String query = "SELECT * FROM " + this.tableName + " WHERE uuid=:uuid";
        return (License)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", uuid)).mapToBean(License.class).findOne().orElse(null));
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "acronym": {
                return this.tableAlias + ".acronym";
            }
            case "created": {
                return this.tableAlias + ".created";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "url": {
                return this.tableAlias + ".url";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    @Override
    protected List<String> getSearchTermTemplates(String tableAlias, String originalSearchTerm) {
        return new ArrayList<String>(Arrays.asList(SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tableAlias, "url")));
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    public long retrieveCount(StringBuilder sqlCount, Map<String, Object> argumentMappings) {
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return total;
    }

    public List<License> retrieveList(String fieldsSql, StringBuilder innerQuery, String orderBy) {
        String sql = "SELECT " + fieldsSql + " FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (String)(orderBy != null ? " " + orderBy : "");
        List result = (List)this.dbi.withHandle(handle -> (List)handle.createQuery(sql).mapToBean(License.class).collect(Collectors.toList()));
        return result;
    }

    private List<License> retrieveList(String fieldsSql, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) {
        String sql = "SELECT " + fieldsSql + " FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (String)(orderBy != null ? " " + orderBy : "");
        List result = (List)this.dbi.withHandle(handle -> (List)((Query)handle.createQuery(sql).bindMap(argumentMappings)).mapToBean(License.class).collect(Collectors.toList()));
        return result;
    }

    public License save(License license) {
        if (license.getUuid() == null) {
            license.setUuid(UUID.randomUUID());
        }
        license.setCreated(LocalDateTime.now());
        license.setLastModified(LocalDateTime.now());
        String sql = "INSERT INTO " + this.tableName + "( uuid, acronym, created, label, last_modified, url) VALUES ( :uuid, :acronym, :created, :label::JSONB, :lastModified, :url)";
        this.dbi.withHandle(h -> ((Update)h.createUpdate(sql).bindBean((Object)license)).execute());
        return license;
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "acronym": 
            case "label": {
                return true;
            }
        }
        return false;
    }

    public License update(License license) {
        String query = "UPDATE " + this.tableName + " SET acronym=:acronym, label=:label::JSONB, last_modified=:lastModified, url=:url WHERE uuid=:uuid RETURNING *";
        return (License)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bindBean((Object)license)).mapToBean(License.class).findOne().orElse(null));
    }
}

