/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.TopicRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.resource.FileResourceMetadataRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import de.digitalcollections.model.view.BreadcrumbNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TopicRepositoryImpl
extends EntityRepositoryImpl<Topic>
implements TopicRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(TopicRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "to";
    public static final String TABLE_ALIAS = "t";
    public static final String TABLE_NAME = "topics";
    private final EntityRepositoryImpl<Entity> entityRepositoryImpl;
    private final FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields();
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues();
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return TopicRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues();
    }

    @Autowired
    public TopicRepositoryImpl(Jdbi dbi, EntityRepositoryImpl entityRepositoryImpl, FileResourceMetadataRepositoryImpl fileResourceMetadataRepositoryImpl, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Topic.class, TopicRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), TopicRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), TopicRepositoryImpl.getSqlInsertFields(), TopicRepositoryImpl.getSqlInsertValues(), TopicRepositoryImpl.getSqlUpdateFieldValues(), cudamiConfig.getOffsetForAlternativePaging());
        this.entityRepositoryImpl = entityRepositoryImpl;
        this.fileResourceMetadataRepositoryImpl = fileResourceMetadataRepositoryImpl;
    }

    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        if (parentUuid == null || childrenUuids == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "topic_topics", "parent_topic_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_topics(parent_topic_uuid, child_topic_uuid, sortIndex) VALUES (:parentTopicUuid, :childTopicUuid, :sortIndex) ON CONFLICT (parent_topic_uuid, child_topic_uuid) DO NOTHING");
            childrenUuids.forEach(childUuid -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentTopicUuid", parentUuid)).bind("childTopicUuid", childUuid)).bind("sortIndex", nextSortIndex + this.getIndex(childrenUuids, (UUID)childUuid))).add());
            preparedBatch.execute();
        });
        return true;
    }

    public PageResponse<Topic> findChildren(UUID uuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_topics AS xtable ON " + this.tableAlias + ".uuid = xtable.child_topic_uuid WHERE xtable.parent_topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public PageResponse<Entity> findEntities(UUID topicUuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        String entityTableAlias = this.entityRepositoryImpl.getTableAlias();
        String entityTableName = this.entityRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + entityTableName + " AS " + entityTableAlias + " INNER JOIN topic_entities AS xtable ON " + entityTableAlias + ".uuid = xtable.entity_uuid WHERE xtable.topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", topicUuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.entityRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.entityRepositoryImpl.retrieveList(this.entityRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public PageResponse<FileResource> findFileResources(UUID topicUuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        String frTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String frTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + frTableName + " AS " + frTableAlias + " INNER JOIN topic_fileresources AS xtable ON " + frTableAlias + ".uuid = xtable.fileresource_uuid WHERE xtable.topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", topicUuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.fileResourceMetadataRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.fileResourceMetadataRepositoryImpl.retrieveList(this.fileResourceMetadataRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public PageResponse<Topic> findRootNodes(PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM topic_topics WHERE child_topic_uuid = " + this.tableAlias + ".uuid)";
        return this.find(pageRequest, commonSql);
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("WITH recursive breadcrumb (uuid,label,refId,parentId,depth) AS (        SELECT t.uuid AS uuid, t.label AS label, t.refid AS refId, tt.parent_topic_uuid AS parentId, 99 AS depth        FROM topics t, topic_topics tt        WHERE uuid= :uuid and tt.child_topic_uuid = t.uuid        UNION ALL        SELECT t.uuid AS uuid, t.label AS label, t.refid AS refID, tt.parent_topic_uuid AS parentId, depth-1 AS depth        FROM topics t, topic_topics tt, breadcrumb b        WHERE b.uuid = tt.child_topic_uuid AND tt.parent_topic_uuid = t.uuid AND tt.parent_topic_uuid IS NOT null    ) SELECT cast(refId AS VARCHAR) as targetId, label, depth FROM breadcrumb ORDER BY depth ASC").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT cast(refId AS VARCHAR) as targetId, label AS label FROM topics WHERE uuid= :uuid").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        }
        return new BreadcrumbNavigation(result);
    }

    @Override
    public Topic getByIdentifier(Identifier identifier) {
        Topic topic = (Topic)super.getByIdentifier(identifier);
        if (topic != null) {
            topic.setChildren(this.getChildren((Identifiable)topic));
        }
        return topic;
    }

    @Override
    public Topic getByUuidAndFiltering(UUID uuid, Filtering filtering) {
        Topic topic = (Topic)super.getByUuidAndFiltering(uuid, filtering);
        if (topic != null) {
            topic.setChildren(this.getChildren((Identifiable)topic));
        }
        return topic;
    }

    public List<Topic> getChildren(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT tt.sortindex AS idx, * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_topics tt ON " + this.tableAlias + ".uuid = tt.child_topic_uuid WHERE tt.parent_topic_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Topic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return result;
    }

    public List<Entity> getEntities(UUID topicUuid) {
        String entityTableAlias = this.entityRepositoryImpl.getTableAlias();
        String entityTableName = this.entityRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT te.sortindex AS idx, * FROM " + entityTableName + " AS " + entityTableAlias + " INNER JOIN topic_entities te ON " + entityTableAlias + ".uuid = te.entity_uuid WHERE te.topic_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", topicUuid);
        List<Entity> result = this.entityRepositoryImpl.retrieveList(this.entityRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, "ORDER BY idx ASC").stream().collect(Collectors.toList());
        return result;
    }

    public List<FileResource> getFileResources(UUID topicUuid) {
        PageResponse<FileResource> response;
        PageRequest request = new PageRequest(0, 100);
        HashSet fileResources = new HashSet();
        while ((response = this.findFileResources(topicUuid, request)) != null && response.hasContent()) {
            fileResources.addAll(response.getContent());
            request = response.nextPageRequest();
            if (request != null) continue;
        }
        return new ArrayList<FileResource>(fileResources);
    }

    public List<Locale> getLanguagesOfEntities(UUID topicUuid) {
        String entityTableName = this.entityRepositoryImpl.getTableName();
        String entityTableAlias = this.entityRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + entityTableAlias + ".label) AS languages FROM " + entityTableName + " AS " + entityTableAlias + " INNER JOIN topic_entities te ON " + entityTableAlias + ".uuid = te.entity_uuid WHERE te.topic_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", topicUuid)).mapTo(Locale.class).list());
    }

    public List<Locale> getLanguagesOfFileResources(UUID topicUuid) {
        String fileResourceTableName = this.fileResourceMetadataRepositoryImpl.getTableName();
        String fileResourceTableAlias = this.fileResourceMetadataRepositoryImpl.getTableAlias();
        String sql = "SELECT DISTINCT jsonb_object_keys(" + fileResourceTableAlias + ".label) AS languages FROM " + fileResourceTableName + " AS " + fileResourceTableAlias + " INNER JOIN topic_fileresources tf ON " + fileResourceTableAlias + ".uuid = tf.fileresource_uuid WHERE tf.topic_uuid = :uuid";
        return (List)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", topicUuid)).mapTo(Locale.class).list());
    }

    public Topic getParent(UUID nodeUuid) {
        String sqlAdditionalJoins = " INNER JOIN topic_topics tt ON " + this.tableAlias + ".uuid = tt.parent_topic_uuid";
        Filtering filtering = Filtering.builder().add(FilterCriterion.nativeBuilder().withExpression("tt.child_topic_uuid").isEquals((Object)nodeUuid).build()).build();
        Topic result = (Topic)this.retrieveOne(this.sqlSelectReducedFields, sqlAdditionalJoins, filtering);
        return result;
    }

    public List<Topic> getParents(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_topics tt ON " + this.tableAlias + ".uuid = tt.parent_topic_uuid WHERE tt.child_topic_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Topic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, null);
        return result;
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) AS languages FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM topic_topics WHERE child_topic_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Topic> getTopicsOfEntity(UUID entityUuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_entities te ON " + this.tableAlias + ".uuid = te.topic_uuid WHERE te.entity_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", entityUuid);
        List<Topic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, null);
        return result;
    }

    public List<Topic> getTopicsOfFileResource(UUID fileResourceUuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN topic_fileresources tf ON " + this.tableAlias + ".uuid = tf.topic_uuid WHERE tf.fileresource_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", fileResourceUuid);
        List<Topic> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, null);
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String sql = "DELETE FROM topic_topics WHERE parent_topic_uuid=:parentTopicUuid AND child_topic_uuid=:childTopicUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM topic_topics WHERE parent_topic_uuid=:parentTopicUuid AND child_topic_uuid=:childTopicUuid").bind("parentTopicUuid", parentUuid)).bind("childTopicUuid", childUuid)).execute());
        return true;
    }

    public Topic save(Topic topic) {
        super.save((Identifiable)topic);
        Topic result = (Topic)this.getByUuid(topic.getUuid());
        return result;
    }

    public Topic saveWithParent(UUID childUuid, UUID parentUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "topic_topics", "parent_topic_uuid", parentUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO topic_topics(parent_topic_uuid, child_topic_uuid, sortindex) VALUES (:parentTopicUuid, :childTopicUuid, :sortIndex)").bind("parentTopicUuid", parentUuid)).bind("childTopicUuid", childUuid)).bind("sortIndex", nextSortIndex)).execute());
        return (Topic)this.getByUuid(childUuid);
    }

    public List<Entity> setEntities(UUID topicUuid, List<Entity> entities) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM topic_entities WHERE topic_uuid = :uuid").bind("uuid", topicUuid)).execute());
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_entities(topic_uuid, entity_uuid, sortIndex) VALUES(:uuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", topicUuid)).bind("entityUuid", entity.getUuid())).bind("sortIndex", this.getIndex(entities, (Identifiable)entity))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getEntities(topicUuid);
    }

    public List<FileResource> setFileResources(UUID topicUuid, List<FileResource> fileResources) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM topic_fileresources WHERE topic_uuid = :uuid").bind("uuid", topicUuid)).execute());
        if (fileResources != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO topic_fileresources(topic_uuid, fileresource_uuid, sortIndex) VALUES(:uuid, :fileResourceUuid, :sortIndex)");
                for (FileResource fileResource : fileResources) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", topicUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getFileResources(topicUuid);
    }

    public Topic update(Topic topic) {
        super.update((Identifiable)topic);
        Topic result = (Topic)this.getByUuid(topic.getUuid());
        return result;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<Topic> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        String query = "UPDATE topic_topics SET sortindex = :idx WHERE child_topic_uuid = :childUuid AND parent_topic_uuid = :parentUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Topic child : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childUuid", child.getUuid())).bind("parentUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

