/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.view;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.view.RenderingTemplateRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.RenderingTemplate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.springframework.stereotype.Repository;

@Repository
public class RenderingTemplateRepositoryImpl
extends JdbiRepositoryImpl
implements RenderingTemplateRepository {
    public static final String MAPPING_PREFIX = "rt";
    public static final String SQL_INSERT_FIELDS = " uuid, created, label, description, name, last_modified";
    public static final String SQL_INSERT_VALUES = " :uuid, :created, :label::JSONB, :description::JSONB, :name, :lastModified";
    public static final String TABLE_ALIAS = "rt";
    public static final String SQL_REDUCED_FIELDS_RT;
    public static final String SQL_FULL_FIELDS_RT;
    public static final String TABLE_NAME = "rendering_templates";

    public RenderingTemplateRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "rt", "rt", cudamiConfig.getOffsetForAlternativePaging());
    }

    public PageResponse<RenderingTemplate> find(PageRequest pageRequest) {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT " + SQL_REDUCED_FIELDS_RT + commonSql);
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bindMap(argumentMappings)).mapToBean(RenderingTemplate.class).list());
        long total = this.count(commonSql.toString(), argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("label", "name"));
    }

    public RenderingTemplate getByUuid(UUID uuid) {
        String query = "SELECT " + SQL_FULL_FIELDS_RT + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE uuid=:uuid";
        return (RenderingTemplate)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("uuid", uuid)).mapToBean(RenderingTemplate.class).findOne().orElse(null));
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "name": {
                return this.tableAlias + ".name";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    @Override
    protected List<String> getSearchTermTemplates(String tableAlias, String originalSearchTerm) {
        return new ArrayList<String>(Arrays.asList(SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tableAlias, "name"), SearchTermTemplates.JSONB_PATH.renderTemplate(tableAlias, "label", "**")));
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    public RenderingTemplate save(RenderingTemplate template) {
        template.setUuid(UUID.randomUUID());
        template.setCreated(LocalDateTime.now());
        template.setLastModified(LocalDateTime.now());
        String query = "INSERT INTO " + this.tableName + "( uuid, created, label, description, name, last_modified) VALUES ( :uuid, :created, :label::JSONB, :description::JSONB, :name, :lastModified) RETURNING *";
        return (RenderingTemplate)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bindBean((Object)template)).mapToBean(RenderingTemplate.class).findOne().orElse(null));
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "label": {
                return true;
            }
        }
        return false;
    }

    public RenderingTemplate update(RenderingTemplate template) {
        template.setLastModified(LocalDateTime.now());
        String query = "UPDATE " + this.tableName + " SET description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, name=:name WHERE uuid=:uuid RETURNING *";
        return (RenderingTemplate)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bindBean((Object)template)).mapToBean(RenderingTemplate.class).findOne().orElse(null));
    }

    static {
        SQL_FULL_FIELDS_RT = SQL_REDUCED_FIELDS_RT = String.format(" %1$s.uuid, %1$s.created, %1$s.label, %1$s.name, %1$s.last_modified, %1$s.description", "rt");
    }
}

