/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifiableRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.IdentifierRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.alias.UrlAliasRepositoryImpl;
import de.digitalcollections.model.file.MimeType;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import de.digitalcollections.model.text.LocalizedText;
import java.net.URI;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.util.StringUtils;

@Repository
public class IdentifiableRepositoryImpl<I extends Identifiable>
extends JdbiRepositoryImpl
implements IdentifiableRepository<I> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentifiableRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "idf";
    public static final String TABLE_ALIAS = "i";
    public static final String TABLE_NAME = "identifiables";
    public BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> additionalReduceRowsBiFunction = (map, rowView) -> map;
    public final BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> basicReduceRowsBiFunction;
    public final BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> fullReduceRowsBiFunction;
    protected final Class identifiableImplClass;
    private final String sqlInsertFields;
    private final String sqlInsertValues;
    protected String sqlSelectAllFields;
    protected final String sqlSelectAllFieldsJoins;
    protected String sqlSelectReducedFields;
    private final String sqlUpdateFieldValues;

    public static String getSqlInsertFields() {
        return " uuid, created, description, identifiable_objecttype, identifiable_type, label, last_modified, previewfileresource, preview_hints, split_label";
    }

    public static String getSqlInsertValues() {
        return " :uuid, :created, :description::JSONB, :identifiableObjectType, :type, :label::JSONB, :lastModified, :previewFileResource, :previewImageRenderingHints::JSONB, :split_label::TEXT[]";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return IdentifiableRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return " " + tableAlias + ".uuid " + mappingPrefix + "_uuid, " + tableAlias + ".created " + mappingPrefix + "_created, " + tableAlias + ".description " + mappingPrefix + "_description, " + tableAlias + ".identifiable_objecttype " + mappingPrefix + "_identifiableObjectType, " + tableAlias + ".identifiable_type " + mappingPrefix + "_type, " + tableAlias + ".label " + mappingPrefix + "_label, " + tableAlias + ".last_modified " + mappingPrefix + "_lastModified, " + tableAlias + ".preview_hints " + mappingPrefix + "_previewImageRenderingHints";
    }

    public static String getSqlUpdateFieldValues() {
        return " description=:description::JSONB, label=:label::JSONB, last_modified=:lastModified, previewfileresource=:previewFileResource, preview_hints=:previewImageRenderingHints::JSONB, split_label=:split_label::TEXT[]";
    }

    @Autowired
    protected IdentifiableRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        this(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Identifiable.class, IdentifiableRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), IdentifiableRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), IdentifiableRepositoryImpl.getSqlInsertFields(), IdentifiableRepositoryImpl.getSqlInsertValues(), IdentifiableRepositoryImpl.getSqlUpdateFieldValues(), cudamiConfig.getOffsetForAlternativePaging());
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, int offsetForAlternativePaging) {
        this(dbi, tableName, tableAlias, mappingPrefix, identifiableImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, null, offsetForAlternativePaging);
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins, int offsetForAlternativePaging) {
        this(dbi, tableName, tableAlias, mappingPrefix, identifiableImplClass, sqlSelectAllFields, sqlSelectReducedFields, sqlInsertFields, sqlInsertValues, sqlUpdateFieldValues, sqlSelectAllFieldsJoins, null, offsetForAlternativePaging);
    }

    protected IdentifiableRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, Class identifiableImplClass, String sqlSelectAllFields, String sqlSelectReducedFields, String sqlInsertFields, String sqlInsertValues, String sqlUpdateFieldValues, String sqlSelectAllFieldsJoins, BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> additionalReduceRowsBiFunction, int offsetForAlternativePaging) {
        super(dbi, tableName, tableAlias, mappingPrefix, offsetForAlternativePaging);
        dbi.registerRowMapper(BeanMapper.factory((Class)identifiableImplClass, (String)mappingPrefix));
        dbi.registerRowMapper(BeanMapper.factory(UrlAlias.class, (String)"ua"));
        this.basicReduceRowsBiFunction = this.createReduceRowsBiFunction(true, true);
        this.fullReduceRowsBiFunction = this.createReduceRowsBiFunction(true, true);
        if (additionalReduceRowsBiFunction != null) {
            this.additionalReduceRowsBiFunction = additionalReduceRowsBiFunction;
        }
        this.identifiableImplClass = identifiableImplClass;
        this.sqlInsertFields = sqlInsertFields;
        this.sqlInsertValues = sqlInsertValues;
        this.sqlSelectAllFields = sqlSelectAllFields;
        this.sqlSelectAllFieldsJoins = sqlSelectAllFieldsJoins;
        this.sqlSelectReducedFields = sqlSelectReducedFields;
        this.sqlUpdateFieldValues = sqlUpdateFieldValues;
    }

    protected String addCrossTablePageRequestParams(PageRequest pageRequest, StringBuilder innerQuery, String crossTableAlias) {
        String orderBy = this.getOrderBy(pageRequest.getSorting());
        if (!StringUtils.hasText((String)orderBy)) {
            orderBy = "ORDER BY idx ASC";
            innerQuery.append(" ORDER BY " + crossTableAlias + ".sortindex");
        }
        this.addPageRequestParams(pageRequest, innerQuery);
        return orderBy;
    }

    public void addRelatedEntity(UUID identifiableUuid, UUID entityUuid) {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_identifiable_entities", "identifiable_uuid", identifiableUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_identifiable_entities(identifiable_uuid, entity_uuid, sortindex) VALUES (:identifiableUuid, :entityUuid, :sortindex)").bind("identifiableUuid", identifiableUuid)).bind("entityUuid", entityUuid)).bind("sortindex", sortIndex)).execute());
    }

    public void addRelatedFileresource(UUID identifiableUuid, UUID fileResourceUuid) {
        Integer sortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "rel_identifiable_fileresources", "identifiable_uuid", identifiableUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO rel_identifiable_fileresources(identifiable_uuid, fileresource_uuid, sortindex) VALUES (:identifiableUuid, :fileresourceUuid, :sortindex)").bind("identifiableUuid", identifiableUuid)).bind("fileresourceUuid", fileResourceUuid)).bind("sortindex", sortIndex)).execute());
    }

    @Override
    protected String addSearchTermMappings(String searchTerm, Map<String, Object> argumentMappings) {
        argumentMappings.put(SearchTermTemplates.ARRAY_CONTAINS.placeholder, IdentifiableRepository.splitToArray((String)searchTerm));
        return super.addSearchTermMappings(searchTerm, argumentMappings);
    }

    private BiFunction<Map<UUID, I>, RowView, Map<UUID, I>> createReduceRowsBiFunction(boolean withIdentifiers, boolean withPreviewImage) {
        return (map, rowView) -> {
            Identifiable identifiable = map.computeIfAbsent((UUID)rowView.getColumn(this.mappingPrefix + "_uuid", UUID.class), fn -> (Identifiable)rowView.getRow(this.identifiableImplClass));
            if (withPreviewImage && rowView.getColumn("pi_uuid", UUID.class) != null) {
                ImageFileResource previewImage = new ImageFileResource();
                previewImage.setUuid((UUID)rowView.getColumn("pi_uuid", UUID.class));
                previewImage.setFilename((String)rowView.getColumn("pi_filename", String.class));
                previewImage.setHttpBaseUrl((URL)rowView.getColumn("pi_httpBaseUrl", URL.class));
                previewImage.setMimeType((MimeType)rowView.getColumn("pi_mimeType", MimeType.class));
                previewImage.setUri((URI)rowView.getColumn("pi_uri", URI.class));
                identifiable.setPreviewImage(previewImage);
            }
            if (withIdentifiers && rowView.getColumn("id_uuid", UUID.class) != null) {
                Identifier dbIdentifier = (Identifier)rowView.getRow(Identifier.class);
                identifiable.addIdentifier(dbIdentifier);
            }
            if (rowView.getColumn("ua_uuid", UUID.class) != null) {
                UrlAlias urlAlias = (UrlAlias)rowView.getRow(UrlAlias.class);
                UUID websiteUuid = (UUID)rowView.getColumn("webs_uuid", UUID.class);
                if (websiteUuid != null) {
                    Website website = new Website((URL)rowView.getColumn("webs_url", URL.class));
                    website.setUuid(websiteUuid);
                    website.setLabel((LocalizedText)rowView.getColumn("webs_label", LocalizedText.class));
                    urlAlias.setWebsite(website);
                }
                if (identifiable.getLocalizedUrlAliases() == null) {
                    identifiable.setLocalizedUrlAliases(new LocalizedUrlAliases(new UrlAlias[]{urlAlias}));
                } else {
                    identifiable.getLocalizedUrlAliases().add(new UrlAlias[]{urlAlias});
                }
            }
            this.extendReducedIdentifiable((I)identifiable, (RowView)rowView);
            return map;
        };
    }

    public boolean delete(List<UUID> uuids) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
        return true;
    }

    protected void extendReducedIdentifiable(I identifiable, RowView rowView) {
    }

    protected PageResponse<I> find(PageRequest pageRequest, Map<String, Object> argumentMappings) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias;
        return this.find(pageRequest, commonSql, argumentMappings);
    }

    protected PageResponse<I> find(PageRequest pageRequest, String commonSql, Map<String, Object> argumentMappings) {
        if (argumentMappings == null) {
            argumentMappings = new HashMap<String, Object>(0);
        }
        StringBuilder commonSqlBuilder = new StringBuilder(commonSql);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSqlBuilder, argumentMappings);
        this.addFiltering(pageRequest, commonSqlBuilder, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".* " + commonSqlBuilder);
        this.addPageRequestParams(pageRequest, innerQuery);
        List<I> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSqlBuilder);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    protected PageResponse<I> find(PageRequest pageRequest, String commonSql) {
        return this.find(pageRequest, commonSql, null);
    }

    public PageResponse<I> find(PageRequest pageRequest) {
        return this.find(pageRequest, (Map<String, Object>)null);
    }

    @Deprecated
    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) {
        Filtering filtering = pageRequest.getFiltering();
        if (filtering == null) {
            filtering = Filtering.builder().build();
            pageRequest.setFiltering(filtering);
        }
        Filtering initialFiltering = Filtering.builder().add(FilterCriterion.builder().withExpression(this.tableAlias + ".label ->> :language").startsWith((Object)":initial").build()).build();
        filtering.add(initialFiltering);
        Sorting sorting = pageRequest.getSorting();
        Sorting labelSorting = Sorting.builder().order(Order.builder().property("label").subProperty(language).direction(Direction.ASC).build()).build();
        if (sorting == null) {
            sorting = labelSorting;
        } else {
            sorting.and(labelSorting);
        }
        pageRequest.setSorting(sorting);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(2);
        argumentMappings.put("language", language);
        argumentMappings.put("initial", initial);
        return this.find(pageRequest, argumentMappings);
    }

    public List<I> getAllFull() {
        return this.retrieveList(this.sqlSelectAllFields, null, null, null);
    }

    public List<I> getAllReduced() {
        return this.retrieveList(this.sqlSelectReducedFields, null, null, null);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("created", "identifiableObjectType", "label", "lastModified", "type"));
    }

    public I getByIdentifier(Identifier identifier) {
        if (identifier.getIdentifiable() != null) {
            return (I)this.getByUuid(identifier.getIdentifiable());
        }
        String namespace = identifier.getNamespace();
        String identifierId = identifier.getId();
        StringBuilder innerSelect = new StringBuilder(String.format("(SELECT %2$s.* FROM %1$s %2$s INNER JOIN %3$s %4$s ON %4$s.identifiable = %2$s.uuid ", this.tableName, this.tableAlias, "identifiers", "id"));
        Filtering filtering = Filtering.builder().add(FilterCriterion.nativeBuilder().withExpression("id.identifier").isEquals((Object)identifierId).build()).add(FilterCriterion.nativeBuilder().withExpression("id.namespace").isEquals((Object)namespace).build()).build();
        HashMap<String, Object> arguments = new HashMap<String, Object>(0);
        this.addFiltering(filtering, innerSelect, arguments);
        innerSelect.append(")");
        I result = this.retrieveOne(this.sqlSelectAllFields, this.sqlSelectAllFieldsJoins, null, arguments, innerSelect.toString());
        return result;
    }

    public I getByUuidAndFiltering(UUID uuid, Filtering filtering) {
        if (filtering == null) {
            filtering = Filtering.builder().build();
        }
        filtering.add(FilterCriterion.builder().withExpression("uuid").isEquals((Object)uuid).build());
        I result = this.retrieveOne(this.sqlSelectAllFields, this.sqlSelectAllFieldsJoins, filtering);
        return result;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "description": {
                return this.tableAlias + ".description";
            }
            case "identifiableObjectType": {
                return this.tableAlias + ".identifiable_objecttype";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "previewImage": {
                return this.tableAlias + ".previewfileresource";
            }
            case "type": {
                return this.tableAlias + ".identifiable_type";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    public int getIndex(List<? extends Identifiable> list, Identifiable identifiable) {
        int pos = -1;
        for (Identifiable identifiable2 : list) {
            ++pos;
            if (!identifiable2.getUuid().equals(identifiable.getUuid())) continue;
            return pos;
        }
        return -1;
    }

    public int getIndex(List<UUID> list, UUID uuid) {
        int pos = -1;
        for (UUID u : list) {
            ++pos;
            if (!u.equals(uuid)) continue;
            return pos;
        }
        return -1;
    }

    public List<Locale> getLanguages() {
        String query = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) as languages FROM " + this.tableName + " AS " + this.tableAlias;
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Entity> getRelatedEntities(UUID identifiableUuid) {
        String query = "SELECT * FROM entities e INNER JOIN rel_identifiable_entities ref ON e.uuid=ref.entity_uuid WHERE ref.identifiable_uuid = :identifiableUuid ORDER BY ref.sortindex";
        List list = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("identifiableUuid", identifiableUuid)).mapToBean(Entity.class).list());
        return list;
    }

    public List<FileResource> getRelatedFileResources(UUID identifiableUuid) {
        String query = "SELECT * FROM fileresources f INNER JOIN rel_identifiable_fileresources ref ON f.uuid=ref.fileresource_uuid WHERE ref.identifiable_uuid = :identifiableUuid ORDER BY ref.sortindex";
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query).bind("identifiableUuid", identifiableUuid)).mapToBean(FileResource.class).list());
        return result;
    }

    @Override
    protected List<String> getSearchTermTemplates(String tableAlias, String originalSearchTerm) {
        if (originalSearchTerm == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> templates = new ArrayList<String>(2);
        if (originalSearchTerm.matches("\".+\"")) {
            templates.add(SearchTermTemplates.JSONB_PATH.renderTemplate(tableAlias, "label", "**"));
        } else {
            templates.add(SearchTermTemplates.ARRAY_CONTAINS.renderTemplate(tableAlias, "split_label"));
        }
        templates.add(SearchTermTemplates.JSONB_PATH.renderTemplate(tableAlias, "description", "**"));
        return templates;
    }

    public String getSqlSelectAllFields() {
        return this.sqlSelectAllFields;
    }

    public String getSqlSelectReducedFields() {
        return this.sqlSelectReducedFields;
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    @Override
    protected String getWhereClause(FilterCriterion<?> fc, Map<String, Object> argumentMappings, int criterionCount) throws IllegalArgumentException, UnsupportedOperationException {
        if (fc.getExpression().startsWith("label")) {
            if (!(fc.getValue() instanceof String)) {
                throw new IllegalArgumentException("Value of label must be a string!");
            }
            String value = (String)fc.getValue();
            switch (fc.getOperation()) {
                case CONTAINS: {
                    argumentMappings.put(SearchTermTemplates.ARRAY_CONTAINS.placeholder, IdentifiableRepository.splitToArray((String)value));
                    return SearchTermTemplates.ARRAY_CONTAINS.renderTemplate(this.tableAlias, "split_label");
                }
                case EQUALS: {
                    Matcher matchLanguage = Pattern.compile("\\.(\\w{1,3})$").matcher(fc.getExpression());
                    String language = matchLanguage.find() ? matchLanguage.group(1) : "**";
                    argumentMappings.put(SearchTermTemplates.JSONB_PATH.placeholder, this.escapeTermForJsonpath(value));
                    return SearchTermTemplates.JSONB_PATH.renderTemplate(this.tableAlias, "label", language);
                }
            }
            throw new UnsupportedOperationException("Filtering by label only supports CONTAINS (to be preferred) or EQUALS operator!");
        }
        return super.getWhereClause(fc, argumentMappings, criterionCount);
    }

    public long retrieveCount(StringBuilder sqlCount, Map<String, Object> argumentMappings) {
        long total = (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sqlCount.toString()).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
        return total;
    }

    public List<I> retrieveList(String fieldsSql, StringBuilder innerQuery, Map<String, Object> argumentMappings, String orderBy) {
        String sql = "SELECT " + fieldsSql + "," + IdentifierRepositoryImpl.SQL_FULL_FIELDS_ID + ", file.uuid pi_uuid, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl, " + UrlAliasRepositoryImpl.getSelectFields(true) + " FROM " + (String)(innerQuery != null ? "(" + innerQuery + ")" : this.tableName) + " AS " + this.tableAlias + (this.sqlSelectAllFieldsJoins != null ? this.sqlSelectAllFieldsJoins : "") + " LEFT JOIN identifiers AS id ON " + this.tableAlias + ".uuid = id.identifiable LEFT JOIN fileresources_image AS file ON " + this.tableAlias + ".previewfileresource = file.uuid LEFT JOIN url_aliases AS ua ON " + this.tableAlias + ".uuid = ua.target_uuid" + UrlAliasRepositoryImpl.WEBSITESJOIN + (String)(orderBy != null && orderBy.matches("(?iu)^\\s*order by.+") ? " " + orderBy : (StringUtils.hasText((String)orderBy) ? " ORDER BY " + orderBy : ""));
        List result = (List)this.dbi.withHandle(handle -> ((Query)handle.createQuery(sql).bindMap(argumentMappings)).reduceRows((map, rowView) -> this.basicReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView)).collect(Collectors.toList()));
        return result;
    }

    public I retrieveOne(String fieldsSql, String sqlSelectAllFieldsJoins, Filtering filtering) {
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        return this.retrieveOne(fieldsSql, sqlSelectAllFieldsJoins, filtering, argumentMappings);
    }

    public I retrieveOne(String fieldsSql, String sqlSelectAllFieldsJoins, Filtering filtering, Map<String, Object> argumentMappings) {
        return this.retrieveOne(fieldsSql, sqlSelectAllFieldsJoins, filtering, argumentMappings, null);
    }

    public I retrieveOne(String fieldsSql, String sqlSelectAllFieldsJoins, Filtering filtering, Map<String, Object> argumentMappings, String innerSelect) {
        StringBuilder sql = new StringBuilder("SELECT" + fieldsSql + "," + IdentifierRepositoryImpl.SQL_FULL_FIELDS_ID + ", file.uuid pi_uuid, file.filename pi_filename, file.mimetype pi_mimeType, file.uri pi_uri, file.http_base_url pi_httpBaseUrl, " + UrlAliasRepositoryImpl.getSelectFields(true) + " FROM " + (StringUtils.hasText((String)innerSelect) ? innerSelect : this.tableName) + " AS " + this.tableAlias + (sqlSelectAllFieldsJoins != null ? sqlSelectAllFieldsJoins : "") + " LEFT JOIN identifiers AS id ON " + this.tableAlias + ".uuid = id.identifiable LEFT JOIN fileresources_image AS file ON " + this.tableAlias + ".previewfileresource = file.uuid LEFT JOIN url_aliases AS ua ON " + this.tableAlias + ".uuid = ua.target_uuid" + UrlAliasRepositoryImpl.WEBSITESJOIN);
        if (argumentMappings == null) {
            argumentMappings = new HashMap<String, Object>(0);
        }
        this.addFiltering(filtering, sql, argumentMappings);
        Map<String, Object> bindMap = Map.copyOf(argumentMappings);
        Identifiable result = ((Stream)this.dbi.withHandle(h -> ((Query)h.createQuery(sql.toString()).bindMap(bindMap)).reduceRows((map, rowView) -> {
            this.fullReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView);
            this.additionalReduceRowsBiFunction.apply((Map<UUID, I>)map, (RowView)rowView);
        }))).findFirst().orElse(null);
        return (I)result;
    }

    public I save(I identifiable, Map<String, Object> bindings) {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        bindings.put("split_label", this.splitToArray(identifiable.getLabel()));
        HashMap<String, Object> finalBindings = new HashMap<String, Object>(bindings);
        if (identifiable.getUuid() == null) {
            identifiable.setUuid(UUID.randomUUID());
        }
        if (identifiable.getCreated() == null) {
            identifiable.setCreated(LocalDateTime.now());
        }
        if (identifiable.getLastModified() == null) {
            identifiable.setLastModified(LocalDateTime.now());
        }
        String sql = "INSERT INTO " + this.tableName + "(" + this.sqlInsertFields + ") VALUES (" + this.sqlInsertValues + ")";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(sql).bindMap(finalBindings)).bindBean(identifiable)).execute());
        return identifiable;
    }

    public List<Entity> setRelatedEntities(UUID identifiableUuid, List<Entity> entities) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_identifiable_entities WHERE identifiable_uuid = :identifiableUuid").bind("identifiableUuid", identifiableUuid)).execute());
        if (entities != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_identifiable_entities(identifiable_uuid, entity_uuid, sortIndex) VALUES(:identifiableUuid, :entityUuid, :sortIndex)");
                for (Entity entity : entities) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("identifiableUuid", identifiableUuid)).bind("entityUuid", entity.getUuid())).bind("sortIndex", this.getIndex(entities, (Identifiable)entity))).add();
                }
                preparedBatch.execute();
            });
        }
        return this.getRelatedEntities(identifiableUuid);
    }

    public List<FileResource> setRelatedFileResources(UUID identifiableUuid, List<FileResource> fileResources) {
        if (fileResources == null) {
            return null;
        }
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM rel_identifiable_fileresources WHERE identifiable_uuid = :identifiableUuid").bind("identifiableUuid", identifiableUuid)).execute());
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO rel_entity_fileresources(identifiable_uuid, fileresource_uuid, sortIndex) VALUES(:identifiableUuid, :fileResourceUuid, :sortIndex)");
            for (FileResource fileResource : fileResources) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("identifiableUuid", identifiableUuid)).bind("fileResourceUuid", fileResource.getUuid())).bind("sortIndex", this.getIndex(fileResources, (Identifiable)fileResource))).add();
            }
            preparedBatch.execute();
        });
        return this.getRelatedFileResources(identifiableUuid);
    }

    protected String[] splitToArray(LocalizedText localizedText) {
        List<String> splitLabels = localizedText.values().stream().map(text -> IdentifiableRepository.splitToArray((String)text)).flatMap(Arrays::stream).collect(Collectors.toList());
        return splitLabels.toArray(new String[splitLabels.size()]);
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "label": {
                return true;
            }
        }
        return false;
    }

    public I update(I identifiable, Map<String, Object> bindings) {
        if (bindings == null) {
            bindings = new HashMap<String, Object>(0);
        }
        UUID previewImageUuid = identifiable.getPreviewImage() == null ? null : identifiable.getPreviewImage().getUuid();
        bindings.put("previewFileResource", previewImageUuid);
        bindings.put("split_label", this.splitToArray(identifiable.getLabel()));
        HashMap<String, Object> finalBindings = new HashMap<String, Object>(bindings);
        identifiable.setLastModified(LocalDateTime.now());
        String sql = "UPDATE " + this.tableName + " SET" + this.sqlUpdateFieldValues + " WHERE uuid=:uuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate(sql).bindMap(finalBindings)).bindBean(identifiable)).execute());
        return identifiable;
    }
}

