/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierTypeRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.JdbiRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.SearchTermTemplates;
import de.digitalcollections.model.identifiable.IdentifierType;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.StatementException;
import org.jdbi.v3.core.statement.Update;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class IdentifierTypeRepositoryImpl
extends JdbiRepositoryImpl
implements IdentifierTypeRepository {
    public static final String MAPPING_PREFIX = "idt";
    public static final String SQL_INSERT_FIELDS = " uuid, created, label, namespace, pattern, last_modified";
    public static final String SQL_INSERT_VALUES = " :uuid, :created, :label, :namespace, :pattern, :lastModified";
    public static final String TABLE_ALIAS = "idt";
    public static final String SQL_REDUCED_FIELDS_IDT;
    public static final String SQL_FULL_FIELDS_IDT;
    public static final String TABLE_NAME = "identifiertypes";

    @Autowired
    public IdentifierTypeRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, "idt", "idt", cudamiConfig.getOffsetForAlternativePaging());
    }

    public void delete(List<UUID> uuids) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM " + this.tableName + " WHERE uuid in (<uuids>)").bindList("uuids", (Iterable)uuids)).execute());
    }

    public PageResponse<IdentifierType> find(PageRequest pageRequest) {
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias);
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        StringBuilder query = new StringBuilder("SELECT " + SQL_REDUCED_FIELDS_IDT + commonSql);
        this.addPageRequestParams(pageRequest, query);
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery(query.toString()).bindMap(argumentMappings)).mapToBean(IdentifierType.class).list());
        long total = this.count(commonSql.toString(), argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public List<IdentifierType> findAll() throws RepositoryException {
        String query = "SELECT " + SQL_REDUCED_FIELDS_IDT + " FROM " + this.tableName + " AS " + this.tableAlias;
        try {
            return (List)this.dbi.withHandle(h -> h.createQuery(query).mapToBean(IdentifierType.class).list());
        }
        catch (StatementException e) {
            String detailMessage = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
            throw new RepositoryException(String.format("The SQL statement is defective: %s", detailMessage), (Throwable)e);
        }
        catch (JdbiException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        return new ArrayList<String>(Arrays.asList("label", "namespace", "pattern"));
    }

    public IdentifierType getByNamespace(String namespace) {
        String sql = "SELECT * FROM " + this.tableName + " WHERE namespace = :namespace";
        IdentifierType identifierType = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("namespace", namespace)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return identifierType;
    }

    public IdentifierType getByUuid(UUID uuid) {
        String sql = "SELECT " + SQL_FULL_FIELDS_IDT + " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE uuid = :uuid";
        IdentifierType identifierType = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bind("uuid", uuid)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return identifierType;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "created": {
                return this.tableAlias + ".created";
            }
            case "label": {
                return this.tableAlias + ".label";
            }
            case "lastModified": {
                return this.tableAlias + ".last_modified";
            }
            case "namespace": {
                return this.tableAlias + ".namespace";
            }
            case "pattern": {
                return this.tableAlias + ".pattern";
            }
            case "uuid": {
                return this.tableAlias + ".uuid";
            }
        }
        return null;
    }

    @Override
    protected List<String> getSearchTermTemplates(String tableAlias, String originalSearchTerm) {
        return new ArrayList<String>(Arrays.asList(SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tableAlias, "label"), SearchTermTemplates.ILIKE_SEARCH.renderTemplate(tableAlias, "namespace")));
    }

    @Override
    protected String getUniqueField() {
        return "uuid";
    }

    public IdentifierType save(IdentifierType identifierType) {
        identifierType.setUuid(UUID.randomUUID());
        identifierType.setCreated(LocalDateTime.now());
        identifierType.setLastModified(LocalDateTime.now());
        String sql = "INSERT INTO " + this.tableName + "( uuid, created, label, namespace, pattern, last_modified) VALUES ( :uuid, :created, :label, :namespace, :pattern, :lastModified) RETURNING *";
        IdentifierType result = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)identifierType)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return result;
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        switch (modelProperty) {
            case "label": {
                return true;
            }
        }
        return false;
    }

    public IdentifierType update(IdentifierType identifierType) {
        identifierType.setLastModified(LocalDateTime.now());
        String sql = "UPDATE " + this.tableName + " SET label=:label, last_modified=:lastModified, namespace=:namespace, pattern=:pattern WHERE uuid=:uuid RETURNING *";
        IdentifierType result = (IdentifierType)this.dbi.withHandle(h -> ((Query)h.createQuery(sql).bindBean((Object)identifierType)).mapToBean(IdentifierType.class).findOne().orElse(null));
        return result;
    }

    static {
        SQL_FULL_FIELDS_IDT = SQL_REDUCED_FIELDS_IDT = String.format(" %1$s.uuid, %1$s.created, %1$s.label, %1$s.namespace, %1$s.pattern, %1$s.last_modified", "idt");
    }
}

