/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi;

import de.digitalcollections.cudami.server.backend.impl.database.AbstractPagingAndSortingRepositoryImpl;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class JdbiRepositoryImpl
extends AbstractPagingAndSortingRepositoryImpl {
    private static final String KEY_PREFIX_FILTERVALUE = "filtervalue_";
    private static final Logger LOGGER = LoggerFactory.getLogger(JdbiRepositoryImpl.class);
    protected final Jdbi dbi;
    protected final String mappingPrefix;
    protected final String tableAlias;
    protected final String tableName;

    public JdbiRepositoryImpl(Jdbi dbi, String tableName, String tableAlias, String mappingPrefix, int offsetForAlternativePaging) {
        this.dbi = dbi;
        this.mappingPrefix = mappingPrefix;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
        this.offsetForAlternativePaging = offsetForAlternativePaging;
    }

    public void addFiltering(PageRequest pageRequest, StringBuilder sqlQuery, Map<String, Object> argumentMappings) {
        if (pageRequest != null) {
            this.addFiltering(pageRequest.getFiltering(), sqlQuery, argumentMappings);
        }
    }

    public void addFiltering(Filtering filtering, StringBuilder sqlQuery, Map<String, Object> argumentMappings) {
        String filterClauses;
        if (filtering != null && !(filterClauses = this.getFilterClauses(filtering, argumentMappings)).isEmpty()) {
            String sqlQueryStr = sqlQuery.toString();
            if (sqlQueryStr.toUpperCase().contains(" WHERE ")) {
                sqlQuery.append(" AND ");
            } else {
                sqlQuery.append(" WHERE ");
            }
            sqlQuery.append(filterClauses);
        }
    }

    protected String addSearchTerm(PageRequest pageRequest, StringBuilder innerQuery, Map<String, Object> argumentMappings) {
        String searchTerm = pageRequest.getSearchTerm();
        String executedSearchTerm = null;
        String commonSearchSql = this.getCommonSearchSql(this.tableAlias, searchTerm);
        if (StringUtils.hasText((String)commonSearchSql) && StringUtils.hasText((String)searchTerm)) {
            String commonSql = innerQuery.toString();
            if (commonSql.toUpperCase().contains(" WHERE ") || commonSql.toUpperCase().contains(" WHERE(")) {
                innerQuery.append(" AND ");
            } else {
                innerQuery.append(" WHERE ");
            }
            innerQuery.append(commonSearchSql);
            executedSearchTerm = this.addSearchTermMappings(searchTerm, argumentMappings);
        }
        return executedSearchTerm;
    }

    protected String addSearchTermMappings(String searchTerm, Map<String, Object> argumentMappings) {
        String executedSearchTerm = this.escapeTermForJsonpath(searchTerm);
        argumentMappings.put("searchTerm", executedSearchTerm);
        return executedSearchTerm;
    }

    public long count() {
        String sql = "SELECT count(*) FROM " + this.tableName;
        long count = (Long)this.dbi.withHandle(h -> (Long)h.createQuery(sql).mapTo(Long.class).findOne().get());
        return count;
    }

    public long count(String commonSql, Map<String, Object> argumentMappings) {
        String sql = "SELECT count(*) " + commonSql;
        return (Long)this.dbi.withHandle(h -> (Long)((Query)h.createQuery(sql).bindMap(argumentMappings)).mapTo(Long.class).findOne().get());
    }

    protected final String escapeTermForJsonpath(String term) {
        if (term == null) {
            return null;
        }
        if (term.startsWith("\"") && term.endsWith("\"")) {
            term = term.replaceAll("^\"(.+)\"$", "$1");
        }
        if (term.contains("\"")) {
            term = term.replaceAll("\"", "\\\\\"");
        }
        return term;
    }

    public String getCommonSearchSql(String tblAlias, String originalSearchTerm) {
        List<String> searchTermTemplates = this.getSearchTermTemplates(tblAlias, originalSearchTerm);
        return searchTermTemplates.isEmpty() ? "" : "(" + searchTermTemplates.stream().collect(Collectors.joining(" OR ")) + ")";
    }

    protected String getFilterClauses(Filtering filtering, Map<String, Object> argumentMappings) {
        if (filtering == null || filtering.getFilterCriteria().isEmpty()) {
            return "";
        }
        ArrayList<String> whereClauses = new ArrayList<String>();
        List filterCriteria = filtering.getFilterCriteria();
        int criterionCount = argumentMappings.size() + 1;
        for (FilterCriterion filterCriterion : filterCriteria) {
            String whereClause = this.getWhereClause(filterCriterion, argumentMappings, criterionCount);
            whereClauses.add(whereClause);
            ++criterionCount;
        }
        String filterClauses = whereClauses.stream().collect(Collectors.joining(" AND "));
        return filterClauses;
    }

    public String getMappingPrefix() {
        return this.mappingPrefix;
    }

    protected List<String> getSearchTermTemplates(String tableAlias, String originalSearchTerm) {
        return Collections.EMPTY_LIST;
    }

    public String getTableAlias() {
        return this.tableAlias;
    }

    public String getTableName() {
        return this.tableName;
    }

    protected String getWhereClause(FilterCriterion<?> fc, Map<String, Object> argumentMappings, int criterionCount) throws IllegalArgumentException, UnsupportedOperationException {
        StringBuilder query = new StringBuilder();
        if (fc != null) {
            String expression;
            FilterOperation filterOperation = fc.getOperation();
            String givenExpression = fc.getExpression();
            if (fc.isNativeExpression()) {
                expression = givenExpression;
            } else {
                expression = this.getColumnName(givenExpression);
                if (expression == null) {
                    throw new IllegalArgumentException(String.format("Given expression '%s' is invalid / can not be mapped.", givenExpression));
                }
            }
            String criterionKey = KEY_PREFIX_FILTERVALUE + criterionCount;
            switch (filterOperation) {
                case BETWEEN: {
                    if (fc.getMinValue() == null || fc.getMaxValue() == null) {
                        throw new IllegalArgumentException("For 'BETWEEN' operation two values are expected");
                    }
                    String keyMin = criterionKey + "_min";
                    String keyMax = criterionKey + "_max";
                    query.append("(").append(expression).append(" BETWEEN ").append(":").append(keyMin).append(" AND ").append(":").append(keyMax).append(")");
                    argumentMappings.put(keyMin, fc.getMinValue());
                    argumentMappings.put(keyMax, fc.getMaxValue());
                    break;
                }
                case IN: 
                case NOT_IN: {
                    if (fc.getValues() == null || fc.getValues().isEmpty()) {
                        throw new IllegalArgumentException("For 'IN/NOT_IN' operation at least one value is expected");
                    }
                    query.append("(").append(expression);
                    if (filterOperation == FilterOperation.NOT_IN) {
                        query.append(" NOT");
                    }
                    query.append(" IN (");
                    ArrayList values = new ArrayList();
                    AtomicInteger valueCounter = new AtomicInteger(0);
                    fc.getValues().forEach(v -> {
                        String key = criterionKey + "_" + valueCounter.incrementAndGet();
                        values.add(":" + key);
                        argumentMappings.put(key, v);
                    });
                    query.append(values.stream().collect(Collectors.joining(",")));
                    query.append("))");
                    break;
                }
                case CONTAINS: {
                    query.append("(").append(expression).append(" ILIKE '%' || ").append(":").append(criterionKey).append(" || '%')");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case STARTS_WITH: {
                    query.append("(").append(expression).append(" ILIKE ").append(":").append(criterionKey).append(" || '%')");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case EQUALS: {
                    query.append("(").append(expression).append(" = ").append(":").append(criterionKey).append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case NOT_EQUALS: {
                    query.append("(").append(expression).append(" != ").append(":").append(criterionKey).append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case GREATER_THAN: {
                    query.append("(").append(expression).append(" > ").append(":").append(criterionKey).append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case GREATER_THAN_OR_NOT_SET: {
                    query.append("(").append(expression).append(" > ").append(":").append(criterionKey).append(" OR ").append(expression).append(" IS NULL").append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case GREATER_THAN_OR_EQUAL_TO: {
                    query.append("(").append(expression).append(" >= ").append(":").append(criterionKey).append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case LESS_THAN: {
                    query.append("(").append(expression).append(" < ").append(":").append(criterionKey).append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case LESS_THAN_AND_SET: {
                    query.append("(").append(expression).append(" < ").append(":").append(criterionKey).append(" AND ").append(expression).append(" IS NOT NULL").append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO: {
                    query.append("(").append(expression).append(" <= ").append(":").append(criterionKey).append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO_AND_SET: {
                    query.append("(").append(expression).append(" <= ").append(":").append(criterionKey).append(" AND ").append(expression).append(" IS NOT NULL").append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case LESS_THAN_OR_EQUAL_TO_OR_NOT_SET: {
                    query.append("(").append(expression).append(" <= ").append(":").append(criterionKey).append(" OR ").append(expression).append(" IS NULL").append(")");
                    argumentMappings.put(criterionKey, fc.getValue());
                    break;
                }
                case SET: {
                    query.append("(").append(expression).append(" IS NOT NULL").append(")");
                    break;
                }
                case NOT_SET: {
                    query.append("(").append(expression).append(" IS NULL").append(")");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(filterOperation + " not supported yet");
                }
            }
        }
        return query.toString();
    }

    protected void mapFilterExpressionsToOtherTableColumnNames(Filtering filtering, AbstractPagingAndSortingRepositoryImpl otherRepository) {
        if (filtering != null) {
            List filterCriteria = filtering.getFilterCriteria().stream().map(fc -> {
                fc.setExpression(otherRepository.getColumnName(fc.getExpression()));
                fc.setNativeExpression(true);
                return fc;
            }).collect(Collectors.toList());
            filtering.setFilterCriteria(filterCriteria);
        }
    }

    protected Integer retrieveNextSortIndexForParentChildren(Jdbi dbi, String tableName, String columNameParentUuid, UUID parentUuid) {
        Integer sortIndex = (Integer)dbi.withHandle(h -> ((Query)h.createQuery("SELECT MAX(sortIndex) + 1 FROM " + tableName + " WHERE " + columNameParentUuid + " = :parent_uuid").bind("parent_uuid", parentUuid)).mapTo(Integer.class).findOne().orElse(null));
        if (sortIndex == null) {
            return 0;
        }
        return sortIndex;
    }
}

