/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database;

import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.Sorting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractPagingAndSortingRepositoryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractPagingAndSortingRepositoryImpl.class);
    private static Pattern SELECT_STMT_SPLITTER;
    protected int offsetForAlternativePaging;

    private void addLimit(PageRequest pageRequest, StringBuilder sqlQuery) {
        int pageSize;
        if (pageRequest != null && (pageSize = pageRequest.getPageSize()) > 0) {
            sqlQuery.append(" ").append("LIMIT").append(" ").append(pageSize);
        }
    }

    private void addOffset(PageRequest pageRequest, StringBuilder sqlQuery) {
        int offset;
        if (pageRequest != null && (offset = pageRequest.getOffset()) >= 0) {
            sqlQuery.append(" ").append("OFFSET").append(" ").append(offset);
        }
    }

    protected void addOrderBy(PageRequest pageRequest, StringBuilder sqlQuery) {
        Sorting sorting;
        String orderBy;
        if (pageRequest != null && StringUtils.hasText((String)(orderBy = this.getOrderBy(sorting = pageRequest.getSorting())))) {
            if (!sqlQuery.toString().matches("(?i).* order by .*")) {
                sqlQuery.append(" ORDER BY ");
            } else {
                sqlQuery.append(", ");
            }
            sqlQuery.append(orderBy);
        }
    }

    public void addPageRequestParams(PageRequest pageRequest, StringBuilder sqlQuery) {
        if (pageRequest != null) {
            if (pageRequest.getOffset() < this.offsetForAlternativePaging) {
                this.buildPageRequestSqlUsingOffsetAndLimit(pageRequest, sqlQuery);
            } else {
                this.buildPageRequestSqlUsingWindowFunction(pageRequest, sqlQuery);
            }
        }
    }

    private void buildPageRequestSqlUsingOffsetAndLimit(PageRequest pageRequest, StringBuilder sqlQuery) {
        this.addOrderBy(pageRequest, sqlQuery);
        this.addLimit(pageRequest, sqlQuery);
        this.addOffset(pageRequest, sqlQuery);
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_STATIC"}, justification="Spotbugs complains about l. 95 - ignore it")
    private void buildPageRequestSqlUsingWindowFunction(PageRequest pageRequest, StringBuilder innerSql) {
        Matcher selectStmtMatcher;
        if (pageRequest == null || innerSql == null) {
            return;
        }
        if (SELECT_STMT_SPLITTER == null) {
            SELECT_STMT_SPLITTER = Pattern.compile("(?iu)^\\s*(SELECT\\s+(?<fields>.+)\\s+)?FROM\\s+(?<fromwhere>(?<table>\\w+\\b)(\\s+AS\\s+(?<tablealias>\\w+))?.*?(\\sWHERE.+?)?)(\\sORDER BY\\s+(?<orderings>.+))?\\s*$");
        }
        if (!(selectStmtMatcher = SELECT_STMT_SPLITTER.matcher(innerSql.toString())).find()) {
            LOGGER.warn("Regex 'selectStmtSplitter' did not match on << {} >>", (Object)innerSql.toString());
            this.buildPageRequestSqlUsingOffsetAndLimit(pageRequest, innerSql);
            return;
        }
        String fields = selectStmtMatcher.group("fields");
        String fromWherePart = selectStmtMatcher.group("fromwhere");
        String table = selectStmtMatcher.group("table").strip();
        String tableAlias = selectStmtMatcher.group("tablealias");
        String orderings = selectStmtMatcher.group("orderings");
        String pageRequestOrderings = this.getOrderBy(pageRequest.getSorting());
        if (!StringUtils.hasText((String)orderings) && StringUtils.hasText((String)pageRequestOrderings)) {
            orderings = pageRequestOrderings.strip();
        } else if (StringUtils.hasText((String)orderings) && StringUtils.hasText((String)pageRequestOrderings)) {
            orderings = String.format("%s, %s", orderings.strip(), pageRequestOrderings.strip());
        }
        int offset = pageRequest.getOffset();
        int pageSize = pageRequest.getPageSize();
        innerSql.delete(0, innerSql.length());
        innerSql.append("SELECT * FROM (");
        if (fields != null && fields.contains("*")) {
            fields = fields.replaceFirst("(\\w+[.])?[*]", String.format("%s.%s rnsetid", tableAlias != null ? tableAlias : table, this.getUniqueField()));
        } else if (fields == null) {
            fields = String.format("%s.%s rnsetid", tableAlias != null ? tableAlias : table, this.getUniqueField());
        }
        innerSql.append("SELECT row_number() OVER (").append(StringUtils.hasText((String)orderings) ? String.format("ORDER BY %s", orderings.strip()) : "").append(") rn, ").append(fields);
        innerSql.append(String.format(" FROM %s", fromWherePart));
        innerSql.append(") innerselect_rownumber ");
        if (fields.contains("rnsetid")) {
            innerSql.append("INNER JOIN ").append(table).append(String.format(" ON %s.%s = innerselect_rownumber.rnsetid ", table, this.getUniqueField()));
        }
        innerSql.append(String.format("WHERE '(%d,%d]'::int8range @> innerselect_rownumber.rn", offset, offset + pageSize));
    }

    protected abstract List<String> getAllowedOrderByFields();

    public abstract String getColumnName(String var1);

    public String getOrderBy(Sorting sorting) {
        if (sorting == null) {
            return null;
        }
        List<String> allowedOrderByFields = this.getAllowedOrderByFields();
        if (this.getUniqueField() != null && !allowedOrderByFields.contains(this.getUniqueField())) {
            allowedOrderByFields.add(this.getUniqueField());
        }
        String orderBy = Optional.ofNullable(sorting.getOrders()).orElse(Collections.emptyList()).stream().filter(o -> {
            boolean allowedSortField;
            String sortField = o.getProperty();
            boolean bl = allowedSortField = sortField != null && allowedOrderByFields != null && allowedOrderByFields.contains(sortField);
            if (!allowedSortField) {
                LOGGER.warn("'" + sortField + "' not in allowed sort fields! Ignoring it.");
            }
            return allowedSortField;
        }).map(o -> {
            String sortDirection = null;
            Direction direction = o.getDirection();
            sortDirection = direction != null && direction.isDescending() ? "DESC" : "ASC";
            String sortField = o.getProperty();
            Optional subSortField = o.getSubProperty();
            String fullQualifiedColumnName = this.getColumnName(sortField);
            if (subSortField.isEmpty()) {
                String formatString = this.supportsCaseSensitivityForProperty(sortField) && o.isIgnoreCase() ? "lower(%s) %s" : "%s %s";
                return String.format(formatString, fullQualifiedColumnName, sortDirection);
            }
            String formatString = o.isIgnoreCase() ? "lower(COALESCE(%1$s->>'%2$s', %1$s->>'')) COLLATE \"ucs_basic\" %3$s" : "COALESCE(%1$s->>'%2$s', %1$s->>'') COLLATE \"ucs_basic\" %3$s";
            return String.format(formatString, fullQualifiedColumnName, subSortField.get(), sortDirection);
        }).collect(Collectors.joining(", "));
        return orderBy;
    }

    protected abstract String getUniqueField();

    protected abstract boolean supportsCaseSensitivityForProperty(String var1);
}

