/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.CollectionRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent.CorporateBodyRepositoryImpl;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import de.digitalcollections.model.view.BreadcrumbNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Query;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Repository;

@Repository
public class CollectionRepositoryImpl
extends EntityRepositoryImpl<Collection>
implements CollectionRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "col";
    public static final String TABLE_ALIAS = "c";
    public static final String TABLE_NAME = "collections";
    @Lazy
    @Autowired
    private CorporateBodyRepositoryImpl corporateBodyRepositoryImpl;
    @Lazy
    @Autowired
    private DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", publication_end, publication_start, text";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :publicationEnd, :publicationStart, :text::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return CollectionRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".publication_start " + mappingPrefix + "_publicationStart, " + tableAlias + ".publication_end " + mappingPrefix + "_publicationEnd";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", publication_end=:publicationEnd, publication_start=:publicationStart, text=:text::JSONB";
    }

    @Autowired
    public CollectionRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, Collection.class, CollectionRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), CollectionRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), CollectionRepositoryImpl.getSqlInsertFields(), CollectionRepositoryImpl.getSqlInsertValues(), CollectionRepositoryImpl.getSqlUpdateFieldValues(), cudamiConfig.getOffsetForAlternativePaging());
    }

    public boolean addChildren(UUID parentUuid, List<UUID> childrenUuids) {
        if (parentUuid == null || childrenUuids == null) {
            return false;
        }
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.useHandle(handle -> {
            PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortIndex) VALUES (:parentCollectionUuid, :childCollectionUuid, :sortIndex) ON CONFLICT (parent_collection_uuid, child_collection_uuid) DO NOTHING");
            childrenUuids.forEach(childUuid -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("parentCollectionUuid", parentUuid)).bind("childCollectionUuid", childUuid)).bind("sortIndex", nextSortIndex + this.getIndex(childrenUuids, (UUID)childUuid))).add());
            preparedBatch.execute();
        });
        return true;
    }

    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        if (collectionUuid != null && digitalObjects != null) {
            Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_digitalobjects", "collection_uuid", collectionUuid);
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex) ON CONFLICT (collection_uuid, digitalobject_uuid) DO NOTHING");
                digitalObjects.forEach(digitalObject -> ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", collectionUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", nextSortIndex + this.getIndex(digitalObjects, (Identifiable)digitalObject))).add());
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public PageResponse<Collection> findChildren(UUID uuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        StringBuilder commonSql = new StringBuilder(" FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections AS xtable ON " + this.tableAlias + ".uuid = xtable.child_collection_uuid WHERE xtable.parent_collection_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", uuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(" + this.tableAlias + ".uuid)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID collectionUuid, PageRequest pageRequest) {
        String crossTableAlias = "xtable";
        String digitalObjectTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String digitalObjectTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder commonSql = new StringBuilder(" FROM " + digitalObjectTableName + " AS " + digitalObjectTableAlias + " INNER JOIN collection_digitalobjects AS xtable ON " + digitalObjectTableAlias + ".uuid = xtable.digitalobject_uuid WHERE xtable.collection_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        argumentMappings.put("uuid", collectionUuid);
        String executedSearchTerm = this.addSearchTerm(pageRequest, commonSql, argumentMappings);
        Filtering filtering = pageRequest.getFiltering();
        this.mapFilterExpressionsToOtherTableColumnNames(filtering, this.digitalObjectRepositoryImpl);
        this.addFiltering(pageRequest, commonSql, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT xtable.sortindex AS idx, * " + commonSql);
        String orderBy = this.addCrossTablePageRequestParams(pageRequest, innerQuery, "xtable");
        List result = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, orderBy);
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSql);
        long total = this.retrieveCount(countQuery, argumentMappings);
        return new PageResponse(result, pageRequest, total, executedSearchTerm);
    }

    public List<CorporateBody> findRelatedCorporateBodies(UUID uuid, Filtering filtering) {
        String cbTableAlias = this.corporateBodyRepositoryImpl.getTableAlias();
        String cbTableName = this.corporateBodyRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + cbTableName + " AS " + cbTableAlias + " LEFT JOIN rel_entity_entities AS r ON " + cbTableAlias + ".uuid = r.object_uuid LEFT JOIN rel_entity_entities AS rel ON r.subject_uuid = rel.subject_uuid WHERE rel.object_uuid = :uuid AND rel.predicate = 'is_part_of'");
        FilterCriterion predicate = filtering.getFilterCriterionFor("predicate");
        if (predicate != null) {
            String predicateFilter = String.format(" AND r.predicate = '%s'", predicate.getValue());
            innerQuery.append(predicateFilter);
        }
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<CorporateBody> result = this.corporateBodyRepositoryImpl.retrieveList(this.corporateBodyRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return result;
    }

    public PageResponse<Collection> findRootNodes(PageRequest pageRequest) {
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " WHERE ( NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = " + this.tableAlias + ".uuid))";
        return this.find(pageRequest, commonSql);
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("publicationEnd", "publicationStart"));
        return allowedOrderByFields;
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID nodeUuid) {
        List result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("WITH recursive breadcrumb (uuid,label,refId,parentId,depth) AS (        SELECT c.uuid AS uuid, c.label AS label, c.refid AS refId, cc.parent_collection_uuid AS parentId, 99 AS depth        FROM collections c, collection_collections cc        WHERE uuid= :uuid and cc.child_collection_uuid = c.uuid        UNION ALL        SELECT c.uuid AS uuid, c.label AS label, c.refid AS refID, cc.parent_collection_uuid AS parentId, depth-1 AS depth        FROM collections c, collection_collections cc, breadcrumb b        WHERE b.uuid = cc.child_collection_uuid AND cc.parent_collection_uuid = c.uuid AND cc.parent_collection_uuid IS NOT null    ) SELECT cast(refId AS VARCHAR) as targetId, label, depth FROM breadcrumb ORDER BY depth ASC").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        if (result.isEmpty()) {
            result = (List)this.dbi.withHandle(h -> ((Query)h.createQuery("SELECT cast(refId AS VARCHAR) as targetId, label AS label FROM collections WHERE uuid= :uuid").bind("uuid", nodeUuid)).mapTo(BreadcrumbNode.class).list());
        }
        return new BreadcrumbNavigation(result);
    }

    @Override
    public Collection getByIdentifier(Identifier identifier) {
        Collection collection = (Collection)super.getByIdentifier(identifier);
        if (collection != null) {
            collection.setChildren(this.getChildren((Identifiable)collection));
        }
        return collection;
    }

    @Override
    public Collection getByRefId(long refId) {
        Collection collection = (Collection)super.getByRefId(refId);
        if (collection != null) {
            collection.setChildren(this.getChildren((Identifiable)collection));
        }
        return collection;
    }

    @Override
    public Collection getByUuidAndFiltering(UUID uuid, Filtering filtering) {
        Collection collection = (Collection)super.getByUuidAndFiltering(uuid, filtering);
        if (collection != null) {
            collection.setChildren(this.getChildren((Identifiable)collection));
        }
        return collection;
    }

    public List<Collection> getChildren(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT cc.sortindex AS idx, * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.child_collection_uuid WHERE cc.parent_collection_uuid = :uuid ORDER BY cc.sortindex ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Collection> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, "ORDER BY idx ASC");
        return result;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "publicationEnd": {
                return this.tableAlias + ".publication_end";
            }
            case "publicationStart": {
                return this.tableAlias + ".publication_start";
            }
        }
        return null;
    }

    public Collection getParent(UUID uuid) {
        String sqlAdditionalJoins = " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.parent_collection_uuid";
        Filtering filtering = Filtering.builder().add(FilterCriterion.nativeBuilder().withExpression("cc.child_collection_uuid").isEquals((Object)uuid).build()).build();
        Collection result = (Collection)this.retrieveOne(this.sqlSelectReducedFields, sqlAdditionalJoins, filtering);
        return result;
    }

    public List<Collection> getParents(UUID uuid) {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " AS " + this.tableAlias + " INNER JOIN collection_collections cc ON " + this.tableAlias + ".uuid = cc.parent_collection_uuid WHERE cc.child_collection_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuid);
        List<Collection> result = this.retrieveList(this.sqlSelectReducedFields, innerQuery, argumentMappings, null);
        return result;
    }

    public List<Locale> getRootNodesLanguages() {
        String query = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) AS languages FROM " + this.tableName + " AS " + this.tableAlias + " WHERE NOT EXISTS (SELECT FROM collection_collections WHERE child_collection_uuid = " + this.tableAlias + ".uuid)";
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) {
        if (parentUuid == null || childUuid == null) {
            return false;
        }
        String sql = "DELETE FROM collection_collections WHERE parent_collection_uuid=:parentCollectionUuid AND child_collection_uuid=:childCollectionUuid";
        this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM collection_collections WHERE parent_collection_uuid=:parentCollectionUuid AND child_collection_uuid=:childCollectionUuid").bind("parentCollectionUuid", parentUuid)).bind("childCollectionUuid", childUuid)).execute());
        return true;
    }

    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) {
        if (collectionUuid != null && digitalObjectUuid != null) {
            String sql = "DELETE FROM collection_digitalobjects WHERE collection_uuid=:collectionUuid AND digitalobject_uuid=:digitalObjectUuid";
            this.dbi.withHandle(h -> ((Update)((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE collection_uuid=:collectionUuid AND digitalobject_uuid=:digitalObjectUuid").bind("collectionUuid", collectionUuid)).bind("digitalObjectUuid", digitalObjectUuid)).execute());
            return true;
        }
        return false;
    }

    public boolean removeDigitalObjectFromAllCollections(DigitalObject digitalObject) {
        if (digitalObject == null) {
            return false;
        }
        String sql = "DELETE FROM collection_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid";
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE digitalobject_uuid=:digitalObjectUuid").bind("digitalObjectUuid", digitalObject.getUuid())).execute());
        return true;
    }

    public Collection save(Collection collection) {
        super.save((Identifiable)collection);
        Collection result = (Collection)this.getByUuid(collection.getUuid());
        return result;
    }

    public Collection saveWithParent(UUID childUuid, UUID parentUuid) {
        Integer nextSortIndex = this.retrieveNextSortIndexForParentChildren(this.dbi, "collection_collections", "parent_collection_uuid", parentUuid);
        this.dbi.withHandle(h -> ((Update)((Update)((Update)h.createUpdate("INSERT INTO collection_collections(parent_collection_uuid, child_collection_uuid, sortindex) VALUES (:parent_collection_uuid, :child_collection_uuid, :sortindex)").bind("parent_collection_uuid", parentUuid)).bind("child_collection_uuid", childUuid)).bind("sortindex", nextSortIndex)).execute());
        return (Collection)this.getByUuid(childUuid);
    }

    public boolean setDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) {
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM collection_digitalobjects WHERE collection_uuid = :uuid").bind("uuid", collectionUuid)).execute());
        if (digitalObjects != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO collection_digitalobjects(collection_uuid, digitalobject_uuid, sortIndex) VALUES (:uuid, :digitalObjectUuid, :sortIndex)");
                for (DigitalObject digitalObject : digitalObjects) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", collectionUuid)).bind("digitalObjectUuid", digitalObject.getUuid())).bind("sortIndex", this.getIndex(digitalObjects, (Identifiable)digitalObject))).add();
                }
                preparedBatch.execute();
            });
            return true;
        }
        return false;
    }

    public Collection update(Collection collection) {
        super.update((Identifiable)collection);
        Collection result = (Collection)this.getByUuid(collection.getUuid());
        return result;
    }

    public boolean updateChildrenOrder(UUID parentUuid, List<Collection> children) {
        if (parentUuid == null || children == null) {
            return false;
        }
        String query = "UPDATE collection_collections SET sortindex = :idx WHERE child_collection_uuid = :childUuid AND parent_collection_uuid = :parentUuid;";
        this.dbi.withHandle(h -> {
            PreparedBatch batch = h.prepareBatch(query);
            int idx = 0;
            for (Collection collection : children) {
                ((PreparedBatch)((PreparedBatch)((PreparedBatch)batch.bind("idx", idx++)).bind("childUuid", collection.getUuid())).bind("parentUuid", parentUuid)).add();
            }
            return batch.execute();
        });
        return true;
    }
}

