/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.agent;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.agent.PersonRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.agent.FamilyNameRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.agent.GivenNameRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.DigitalObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.work.WorkRepositoryImpl;
import de.digitalcollections.model.identifiable.agent.FamilyName;
import de.digitalcollections.model.identifiable.agent.GivenName;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocation;
import de.digitalcollections.model.identifiable.entity.geo.location.GeoLocationType;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.text.LocalizedText;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PersonRepositoryImpl
extends EntityRepositoryImpl<Person>
implements PersonRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersonRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "pe";
    public static final String TABLE_ALIAS = "p";
    private static final String SQL_FULL_FIELDS_JOINS = " LEFT JOIN geolocations AS glbirth ON glbirth.uuid = p.locationofbirth LEFT JOIN geolocations AS gldeath ON gldeath.uuid = p.locationofdeath LEFT JOIN person_familynames AS pf ON pf.person_uuid = p.uuid LEFT JOIN familynames AS fn ON fn.uuid = pf.familyname_uuid LEFT JOIN person_givennames AS pg ON pg.person_uuid = p.uuid LEFT JOIN givennames AS gn ON gn.uuid = pg.givenname_uuid";
    public static final String TABLE_NAME = "persons";
    private final DigitalObjectRepositoryImpl digitalObjectRepositoryImpl;
    private final FamilyNameRepositoryImpl familyNameRepositoryImpl;
    private final GivenNameRepositoryImpl givenNameRepositoryImpl;
    private final WorkRepositoryImpl workRepositoryImpl;

    private static BiFunction<Map<UUID, Person>, RowView, Map<UUID, Person>> createAdditionalReduceRowsBiFunction() {
        return (map, rowView) -> {
            GeoLocationType geoLocationType;
            LocalizedText label;
            Long glRefId;
            Person person = (Person)map.get(rowView.getColumn("pe_uuid", UUID.class));
            if (rowView.getColumn("glbirth_uuid", UUID.class) != null) {
                UUID glBirthUuid = (UUID)rowView.getColumn("glbirth_uuid", UUID.class);
                glRefId = (Long)rowView.getColumn("glbirth_refid", Long.class);
                label = (LocalizedText)rowView.getColumn("glbirth_label", LocalizedText.class);
                geoLocationType = (GeoLocationType)rowView.getColumn("glbirth_geoLocationType", GeoLocationType.class);
                GeoLocation placeOfBirth = new GeoLocation();
                placeOfBirth.setUuid(glBirthUuid);
                placeOfBirth.setRefId(glRefId.longValue());
                placeOfBirth.setLabel(label);
                placeOfBirth.setGeoLocationType(geoLocationType);
                person.setPlaceOfBirth(placeOfBirth);
            }
            if (rowView.getColumn("gldeath_uuid", UUID.class) != null) {
                UUID glDeathUuid = (UUID)rowView.getColumn("gldeath_uuid", UUID.class);
                glRefId = (Long)rowView.getColumn("gldeath_refid", Long.class);
                label = (LocalizedText)rowView.getColumn("gldeath_label", LocalizedText.class);
                geoLocationType = (GeoLocationType)rowView.getColumn("gldeath_geoLocationType", GeoLocationType.class);
                GeoLocation placeOfDeath = new GeoLocation();
                placeOfDeath.setUuid(glDeathUuid);
                placeOfDeath.setRefId(glRefId.longValue());
                placeOfDeath.setLabel(label);
                placeOfDeath.setGeoLocationType(geoLocationType);
                person.setPlaceOfDeath(placeOfDeath);
            }
            try {
                if (rowView.getColumn("fn_uuid", UUID.class) != null) {
                    person.getFamilyNames().add((FamilyName)rowView.getRow(FamilyName.class));
                }
                if (rowView.getColumn("gn_uuid", UUID.class) != null) {
                    person.getGivenNames().add((GivenName)rowView.getRow(GivenName.class));
                }
            }
            catch (Exception e) {
                LOGGER.debug("No family name or given name in rowview. Skipping.");
            }
            return map;
        };
    }

    public static String getSqlInsertFields() {
        return EntityRepositoryImpl.getSqlInsertFields() + ", dateofbirth, dateofdeath, gender, locationofbirth, locationofdeath, timevalueofbirth, timevalueofdeath";
    }

    public static String getSqlInsertValues() {
        return EntityRepositoryImpl.getSqlInsertValues() + ", :dateOfBirth, :dateOfDeath, :gender, :locationOfBirth, :locationOfDeath, :timeValueOfBirth::JSONB, :timeValueOfDeath::JSONB";
    }

    public static String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        String familyNameMappingPrefix = "fn";
        String givenNameMappingPrefix = "gn";
        return PersonRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", glbirth.uuid glbirth_uuid, glbirth.refId glbirth_refid, glbirth.label glbirth_label, glbirth.geolocation_type glbirth_geoLocationType, gldeath.uuid gldeath_uuid, gldeath.refId gldeath_refid, gldeath.label gldeath_label, gldeath.geolocation_type gldeath_geoLocationType, fn.uuid fn_uuid, fn.label fn_label, gn.uuid gn_uuid, gn.label gn_label";
    }

    public static String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return EntityRepositoryImpl.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".dateofbirth " + mappingPrefix + "_dateOfBirth, " + tableAlias + ".dateofdeath " + mappingPrefix + "_dateOfDeath, " + tableAlias + ".gender " + mappingPrefix + "_gender, " + tableAlias + ".timevalueofbirth " + mappingPrefix + "_timeValueOfBirth, " + tableAlias + ".timevalueofdeath " + mappingPrefix + "_timeValueOfDeath";
    }

    public static String getSqlUpdateFieldValues() {
        return EntityRepositoryImpl.getSqlUpdateFieldValues() + ", dateofbirth=:dateOfBirth, dateofdeath=:dateOfDeath, gender=:gender, locationofbirth=:locationOfBirth, locationofdeath=:locationOfDeath, timevalueofbirth=:timeValueOfBirth::JSONB, timevalueofdeath=:timeValueOfDeath::JSONB";
    }

    @Autowired
    public PersonRepositoryImpl(Jdbi dbi, DigitalObjectRepositoryImpl digitalObjectRepositoryImpl, FamilyNameRepositoryImpl familyNameRepositoryImpl, GivenNameRepositoryImpl givenNameRepositoryImpl, WorkRepositoryImpl workRepositoryImpl, CudamiConfig cudamiConfig) {
        super(dbi, TABLE_NAME, TABLE_ALIAS, MAPPING_PREFIX, (Class)Person.class, PersonRepositoryImpl.getSqlSelectAllFields(TABLE_ALIAS, MAPPING_PREFIX), PersonRepositoryImpl.getSqlSelectReducedFields(TABLE_ALIAS, MAPPING_PREFIX), PersonRepositoryImpl.getSqlInsertFields(), PersonRepositoryImpl.getSqlInsertValues(), PersonRepositoryImpl.getSqlUpdateFieldValues(), SQL_FULL_FIELDS_JOINS, PersonRepositoryImpl.createAdditionalReduceRowsBiFunction(), cudamiConfig.getOffsetForAlternativePaging());
        this.digitalObjectRepositoryImpl = digitalObjectRepositoryImpl;
        this.familyNameRepositoryImpl = familyNameRepositoryImpl;
        this.givenNameRepositoryImpl = givenNameRepositoryImpl;
        this.workRepositoryImpl = workRepositoryImpl;
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        if (super.getColumnName(modelProperty) != null) {
            return super.getColumnName(modelProperty);
        }
        switch (modelProperty) {
            case "dateOfBirth": {
                return this.tableAlias + ".dateofbirth";
            }
            case "dateOfDeath": {
                return this.tableAlias + ".dateofdeath";
            }
            case "gender": {
                return this.tableAlias + ".gender";
            }
            case "placeOfBirth": {
                return this.tableAlias + ".locationofbirth";
            }
            case "placeOfDeath": {
                return this.tableAlias + ".locationofdeath";
            }
            case "timeValueOfBirth": {
                return this.tableAlias + ".timevalueofbirth";
            }
            case "timeValueOfDeath": {
                return this.tableAlias + ".timevalueofdeath";
            }
        }
        return null;
    }

    public Set<DigitalObject> getDigitalObjects(UUID uuidPerson) {
        String doTableAlias = this.digitalObjectRepositoryImpl.getTableAlias();
        String doTableName = this.digitalObjectRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + doTableName + " AS " + doTableAlias + " LEFT JOIN item_digitalobjects AS itdi ON " + doTableAlias + ".uuid = itdi.digitalobject_uuid LEFT JOIN item_works AS itwo ON itdi.item_uuid = itwo.item_uuid LEFT JOIN work_creators AS wocr ON itwo.work_uuid = wocr.work_uuid WHERE wocr.agent_uuid = :uuid");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuidPerson);
        List list = this.digitalObjectRepositoryImpl.retrieveList(this.digitalObjectRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, null);
        return list.stream().collect(Collectors.toSet());
    }

    public Set<Work> getWorks(UUID uuidPerson) {
        String wTableAlias = this.workRepositoryImpl.getTableAlias();
        String wTableName = this.workRepositoryImpl.getTableName();
        StringBuilder innerQuery = new StringBuilder("SELECT wc.sortindex AS idx, * FROM " + wTableName + " AS " + wTableAlias + " LEFT JOIN work_creators AS wc ON " + wTableAlias + ".uuid = wc.work_uuid WHERE wc.agent_uuid = :uuid ORDER BY idx ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", uuidPerson);
        List list = this.workRepositoryImpl.retrieveList(this.workRepositoryImpl.getSqlSelectReducedFields(), innerQuery, argumentMappings, "ORDER BY idx ASC");
        return list.stream().collect(Collectors.toSet());
    }

    public Person save(Person person) {
        UUID locationOfBirthUuid = person.getPlaceOfBirth() == null ? null : person.getPlaceOfBirth().getUuid();
        UUID locationOfDeathUuid = person.getPlaceOfDeath() == null ? null : person.getPlaceOfDeath().getUuid();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("locationOfBirth", locationOfBirthUuid);
        bindings.put("locationOfDeath", locationOfDeathUuid);
        super.save(person, (Map<String, Object>)bindings);
        List givenNames = person.getGivenNames();
        this.setRelatedGivenNames(givenNames, person);
        List familyNames = person.getFamilyNames();
        this.setRelatedFamilyNames(familyNames, person);
        Person result = (Person)this.getByUuid(person.getUuid());
        return result;
    }

    private void setRelatedFamilyNames(List<FamilyName> familyNames, Person person) {
        if (familyNames != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO person_familynames(person_uuid, familyname_uuid, sortIndex) VALUES(:uuid, :familynameUuid, :sortIndex)");
                int i = 0;
                for (FamilyName familyName : familyNames) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", person.getUuid())).bind("familynameUuid", familyName.getUuid())).bind("sortIndex", i)).add();
                    ++i;
                }
                preparedBatch.execute();
            });
        }
    }

    private void setRelatedGivenNames(List<GivenName> givenNames, Person person) {
        if (givenNames != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO person_givennames(person_uuid, givenname_uuid, sortIndex) VALUES(:uuid, :givennameUuid, :sortIndex)");
                int i = 0;
                for (GivenName givenName : givenNames) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", person.getUuid())).bind("givennameUuid", givenName.getUuid())).bind("sortIndex", i)).add();
                    ++i;
                }
                preparedBatch.execute();
            });
        }
    }

    public Person update(Person person) {
        UUID locationOfBirthUuid = person.getPlaceOfBirth() == null ? null : person.getPlaceOfBirth().getUuid();
        UUID locationOfDeathUuid = person.getPlaceOfDeath() == null ? null : person.getPlaceOfDeath().getUuid();
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        bindings.put("locationOfBirth", locationOfBirthUuid);
        bindings.put("locationOfDeath", locationOfDeathUuid);
        super.update(person, (Map<String, Object>)bindings);
        List givenNames = person.getGivenNames();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM person_givennames WHERE person_uuid = :uuid").bind("uuid", person.getUuid())).execute());
        this.setRelatedGivenNames(givenNames, person);
        List familyNames = person.getFamilyNames();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM person_familynames WHERE person_uuid = :uuid").bind("uuid", person.getUuid())).execute());
        this.setRelatedFamilyNames(familyNames, person);
        Person result = (Person)this.getByUuid(person.getUuid());
        return result;
    }
}

