/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.database.migration;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.openjson.JSONObject;
import de.digitalcollections.commons.web.SlugGenerator;
import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.config.SpringUtility;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.IdentifiableType;
import de.digitalcollections.model.identifiable.alias.UrlAlias;
import de.digitalcollections.model.identifiable.entity.EntityType;
import de.digitalcollections.model.identifiable.entity.Website;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.flywaydb.core.api.migration.BaseJavaMigration;
import org.flywaydb.core.api.migration.Context;
import org.flywaydb.core.internal.jdbc.JdbcTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.SingleConnectionDataSource;

public class V9_02_02__DML_Fill_urlaliases
extends BaseJavaMigration {
    private static final Map<String, Pair<String, EntityType>> ENTITY_MIGRATION_TABLES = new LinkedHashMap<String, Pair<String, EntityType>>();
    private static final Logger LOGGER;
    private final SlugGenerator slugGenerator = new SlugGenerator();
    private CudamiConfig cudamiConfig = (CudamiConfig)SpringUtility.getBean(CudamiConfig.class);

    public void migrate(Context context) throws Exception {
        SingleConnectionDataSource connectionDataSource = new SingleConnectionDataSource(context.getConnection(), true);
        this.slugGenerator.setMaxLength(this.cudamiConfig.getUrlAlias().getMaxLength());
        JdbcTemplate jdbcTemplate = new JdbcTemplate(connectionDataSource.getConnection());
        if (jdbcTemplate.queryForInt("SELECT count(*) from url_aliases", new String[0]) > 0) {
            LOGGER.info("UrlAliases already existing, so nothing to do...");
            return;
        }
        this.migrateWebpages(jdbcTemplate);
        this.removeEntitiesNotToMigrate();
        ENTITY_MIGRATION_TABLES.forEach((className, attrs) -> {
            if (attrs != null) {
                try {
                    this.migrateEntities(jdbcTemplate, (String)attrs.getLeft(), (EntityType)attrs.getRight());
                }
                catch (SQLException e) {
                    throw new RuntimeException("Cannot migrate " + attrs.getRight() + ": " + e, e);
                }
            }
        });
    }

    private void removeEntitiesNotToMigrate() {
        if (this.cudamiConfig.getUrlAlias() != null && this.cudamiConfig.getUrlAlias().getGenerationExcludes() != null) {
            List excludedEntities = this.cudamiConfig.getUrlAlias().getGenerationExcludes();
            LOGGER.info("Excluding UrlAlias generation for " + excludedEntities);
            excludedEntities.forEach(ENTITY_MIGRATION_TABLES::remove);
        }
        LOGGER.info("To migrate=" + ENTITY_MIGRATION_TABLES.entrySet().stream().filter(e -> e.getValue() != null).map(Map.Entry::getKey).collect(Collectors.toList()));
    }

    private void migrateWebpages(JdbcTemplate jdbcTemplate) throws SQLException {
        String selectQuery = "SELECT w.uuid AS w_uuid, w.label AS label, ww.website_uuid AS ws_uuid FROM webpages w, website_webpages ww WHERE ww.webpage_uuid=w.uuid ORDER BY ws_uuid,w_uuid";
        List webpages = jdbcTemplate.queryForList(selectQuery, new Object[0]);
        if (webpages.isEmpty()) {
            LOGGER.info("No UrlAliases to add for webpages");
            return;
        }
        LOGGER.info("Migrating webpages");
        webpages.forEach(w -> {
            JSONObject jsonObject = new JSONObject(w.toString());
            UUID uuid = UUID.fromString(jsonObject.getString("w_uuid"));
            UUID websiteUuid = UUID.fromString(jsonObject.getString("ws_uuid"));
            this.createUrlAliasAndMigrateSubpages(jdbcTemplate, jsonObject, uuid, websiteUuid);
        });
        LOGGER.info("Successfully added {} UrlAliases for webpages", (Object)webpages.size());
    }

    private void migrateSubpages(JdbcTemplate jdbcTemplate, UUID websiteUuid, UUID parentWebpageUuid) throws SQLException {
        String selectQuery = "SELECT w.uuid AS w_uuid, w.label AS label FROM webpages w INNER JOIN webpage_webpages ww ON ww.child_webpage_uuid=w.uuid WHERE ww.parent_webpage_uuid = '" + parentWebpageUuid + "'";
        List webpages = jdbcTemplate.queryForList(selectQuery, new Object[0]);
        if (webpages.isEmpty()) {
            return;
        }
        webpages.forEach(w -> {
            JSONObject jsonObject = new JSONObject(w.toString());
            UUID uuid = UUID.fromString(jsonObject.getString("w_uuid"));
            this.createUrlAliasAndMigrateSubpages(jdbcTemplate, jsonObject, uuid, websiteUuid);
        });
    }

    private void createUrlAliasAndMigrateSubpages(JdbcTemplate jdbcTemplate, JSONObject jsonObject, UUID uuid, UUID websiteUuid) {
        try {
            Map labels = (Map)new ObjectMapper().readValue(jsonObject.getString("label"), HashMap.class);
            labels.forEach((language, label) -> {
                UrlAlias urlAlias = this.buildUrlAlias(jdbcTemplate, null, IdentifiableType.RESOURCE, uuid, (String)language, (String)label, websiteUuid);
                try {
                    this.saveUrlAlias(jdbcTemplate, urlAlias);
                }
                catch (SQLException e) {
                    throw new RuntimeException("Cannot save urlAlias " + urlAlias + ": " + e, e);
                }
            });
            try {
                this.migrateSubpages(jdbcTemplate, websiteUuid, uuid);
            }
            catch (SQLException e) {
                throw new RuntimeException("Cannot migrate subpages for websiteUuid=" + websiteUuid + ", uuid=" + uuid + ": " + e, e);
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Cannot parse " + jsonObject + ": " + e, e);
        }
    }

    private void migrateEntities(JdbcTemplate jdbcTemplate, String tableName, EntityType entityType) throws SQLException {
        String selectQuery = String.format("SELECT uuid,label FROM %s", tableName);
        List entities = jdbcTemplate.queryForList(selectQuery, new Object[0]);
        if (entities.isEmpty()) {
            LOGGER.info("No UrlAliases to add for {}", (Object)tableName);
            return;
        }
        LOGGER.info("Migrating {}", (Object)tableName);
        entities.forEach(w -> {
            JSONObject jsonObject = new JSONObject(w.toString());
            UUID uuid = UUID.fromString(jsonObject.getString("uuid"));
            try {
                Map labels = (Map)new ObjectMapper().readValue(jsonObject.getString("label"), HashMap.class);
                labels.forEach((language, label) -> {
                    UrlAlias urlAlias = this.buildUrlAlias(jdbcTemplate, entityType, IdentifiableType.ENTITY, uuid, (String)language, (String)label, null);
                    try {
                        this.saveUrlAlias(jdbcTemplate, urlAlias);
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Cannot save urlAlias " + urlAlias + ": " + e, e);
                    }
                });
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException("Cannot parse " + w + ": " + e, e);
            }
        });
        LOGGER.info("Successfully added {} UrlAliases for {}", (Object)entities.size(), (Object)tableName);
    }

    private UrlAlias buildUrlAlias(JdbcTemplate jdbcTemplate, EntityType entityType, IdentifiableType identifiableType, UUID uuid, String language, String label, UUID websiteUuid) {
        String baseSlug;
        Locale locale = Locale.forLanguageTag(language);
        String slug = baseSlug = this.slugGenerator.generateSlug(label);
        int suffix = 0;
        while (true) {
            try {
                if (!this.hasUrlAlias(jdbcTemplate, slug, uuid, locale, websiteUuid)) {
                    break;
                }
            }
            catch (SQLException e) {
                throw new RuntimeException("Cannot check availability of URLAlias for uuid=" + uuid + ", locale=" + locale + ", slug=" + slug + ": " + e, e);
            }
            slug = String.format("%s-%d", baseSlug, ++suffix);
        }
        if (!slug.equals(baseSlug)) {
            LOGGER.warn("{}: Building slug with suffix={}", entityType != null ? entityType : "WEBPAGE", (Object)slug);
        }
        UrlAlias urlAlias = new UrlAlias();
        urlAlias.setUuid(UUID.randomUUID());
        urlAlias.setTargetLanguage(locale);
        urlAlias.setPrimary(true);
        Identifiable target = ((Identifiable.IdentifiableBuilder)Identifiable.builder().uuid(uuid)).type(identifiableType).build();
        urlAlias.setTarget(target);
        urlAlias.setSlug(slug);
        if (websiteUuid != null) {
            Website website = new Website();
            website.setUuid(websiteUuid);
            urlAlias.setWebsite(website);
        }
        return urlAlias;
    }

    private void saveUrlAlias(JdbcTemplate jdbcTemplate, UrlAlias urlAlias) throws SQLException {
        String updateQuery = "INSERT INTO url_aliases (uuid,created,last_published,\"primary\",slug,target_identifiable_type,target_language,target_uuid,website_uuid) VALUES(?::uuid,CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,?,?,?,?,?,?::uuid,?::uuid);";
        try {
            jdbcTemplate.update(updateQuery, new Object[]{urlAlias.getUuid().toString(), urlAlias.isPrimary(), urlAlias.getSlug(), urlAlias.getTarget().getType().toString(), urlAlias.getTargetLanguage().toString(), urlAlias.getTarget().getUuid().toString(), urlAlias.getWebsite() != null ? urlAlias.getWebsite().getUuid().toString() : null});
        }
        catch (SQLException e) {
            throw new SQLException("Cannot insert " + urlAlias + ":" + e, e);
        }
    }

    private boolean hasUrlAlias(JdbcTemplate jdbcTemplate, String slug, UUID uuid, Locale locale, UUID websiteUuid) throws SQLException {
        if (websiteUuid == null) {
            return jdbcTemplate.queryForInt("SELECT count(*) FROM url_aliases WHERE website_uuid IS NULL AND slug=? AND target_language=?", new String[]{slug, locale.getLanguage()}) > 0;
        }
        return jdbcTemplate.queryForInt("SELECT count(*) FROM url_aliases WHERE slug=? AND target_language=? AND website_uuid=uuid(?)", new String[]{slug, locale.getLanguage(), websiteUuid.toString()}) > 0;
    }

    static {
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.AGENT.toString(), null);
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.ARTICLE.toString(), (Pair<String, EntityType>)Pair.of((Object)"articles", (Object)EntityType.ARTICLE));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.COLLECTION.toString(), (Pair<String, EntityType>)Pair.of((Object)"collections", (Object)EntityType.COLLECTION));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.CORPORATE_BODY.toString(), (Pair<String, EntityType>)Pair.of((Object)"corporatebodies", (Object)EntityType.CORPORATE_BODY));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.DIGITAL_OBJECT.toString(), (Pair<String, EntityType>)Pair.of((Object)"digitalobjects", (Object)EntityType.DIGITAL_OBJECT));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.ENTITY.toString(), null);
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.FAMILY.toString(), null);
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.GEO_LOCATION.toString(), (Pair<String, EntityType>)Pair.of((Object)"geolocations", (Object)EntityType.GEOLOCATION));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.HEADWORD_ENTRY.toString(), null);
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.ITEM.toString(), (Pair<String, EntityType>)Pair.of((Object)"items", (Object)EntityType.ITEM));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.MANIFESTATION.toString(), null);
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.PERSON.toString(), (Pair<String, EntityType>)Pair.of((Object)"persons", (Object)EntityType.PERSON));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.PROJECT.toString(), (Pair<String, EntityType>)Pair.of((Object)"projects", (Object)EntityType.PROJECT));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.TOPIC.toString(), (Pair<String, EntityType>)Pair.of((Object)"topics", (Object)EntityType.TOPIC));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.WEBSITE.toString(), (Pair<String, EntityType>)Pair.of((Object)"websites", (Object)EntityType.WEBSITE));
        ENTITY_MIGRATION_TABLES.put(IdentifiableObjectType.WORK.toString(), (Pair<String, EntityType>)Pair.of((Object)"works", (Object)EntityType.WORK));
        LOGGER = LoggerFactory.getLogger(V9_02_02__DML_Fill_urlaliases.class);
    }
}

