/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.IdentifierRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.alias.UrlAliasRepository;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.entity.HeadwordEntryRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.entity.EntityRepositoryImpl;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.HeadwordEntry;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.agent.Family;
import de.digitalcollections.model.identifiable.entity.agent.Person;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.semantic.Headword;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.result.RowView;
import org.jdbi.v3.core.statement.PreparedBatch;
import org.jdbi.v3.core.statement.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Repository;

@Repository
public class HeadwordEntryRepositoryImpl
extends EntityRepositoryImpl<HeadwordEntry>
implements HeadwordEntryRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(HeadwordEntryRepositoryImpl.class);
    public static final String MAPPING_PREFIX = "he";
    public static final String TABLE_ALIAS = "he";
    public static final String TABLE_NAME = "headwordentries";
    private final EntityRepositoryImpl<Entity> entityRepositoryImpl;

    public HeadwordEntryRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, @Qualifier(value="entityRepositoryImpl") EntityRepositoryImpl<Entity> entityRepositoryImpl, IdentifierRepository identifierRepository, UrlAliasRepository urlAliasRepository) {
        super(dbi, TABLE_NAME, "he", "he", (Class<? extends Entity>)HeadwordEntry.class, cudamiConfig.getOffsetForAlternativePaging(), identifierRepository, urlAliasRepository);
        this.entityRepositoryImpl = entityRepositoryImpl;
    }

    @Override
    public HeadwordEntry create() throws RepositoryException {
        return new HeadwordEntry();
    }

    @Override
    protected BiConsumer<Map<UUID, HeadwordEntry>, RowView> createAdditionalReduceRowsBiConsumer() {
        return (map, rowView) -> {
            HeadwordEntry headwordEntry = (HeadwordEntry)map.get(rowView.getColumn("he_uuid", UUID.class));
            if (rowView.getColumn("hw_uuid", UUID.class) != null) {
                UUID headwordUuid = (UUID)rowView.getColumn("hw_uuid", UUID.class);
                String label = (String)rowView.getColumn("hw_label", String.class);
                Headword headword = new Headword();
                headword.setUuid(headwordUuid);
                headword.setLabel(label);
                headwordEntry.setHeadword(headword);
            }
        };
    }

    public List<HeadwordEntry> getByHeadword(UUID headwordUuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT * FROM " + this.tableName + " WHERE headword = :uuid ORDER BY date_published ASC");
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", headwordUuid);
        List<HeadwordEntry> result = this.retrieveList(this.getSqlSelectAllFields(), this.getSqlSelectAllFieldsJoins(), innerQuery, argumentMappings, "ORDER BY " + this.tableAlias + ".date_published ASC");
        return result;
    }

    public HeadwordEntry getByIdentifier(Identifier identifier) throws RepositoryException {
        HeadwordEntry headwordEntry = (HeadwordEntry)super.getByIdentifier(identifier);
        if (headwordEntry != null) {
            headwordEntry.setCreators(this.getCreators(headwordEntry.getUuid()));
        }
        return headwordEntry;
    }

    @Override
    public HeadwordEntry getByRefId(long refId) throws RepositoryException {
        HeadwordEntry headwordEntry = (HeadwordEntry)super.getByRefId(refId);
        if (headwordEntry != null) {
            headwordEntry.setCreators(this.getCreators(headwordEntry.getUuid()));
        }
        return headwordEntry;
    }

    @Override
    public HeadwordEntry getByUuidAndFiltering(UUID uuid, Filtering filtering) throws RepositoryException {
        HeadwordEntry headwordEntry = (HeadwordEntry)super.getByUuidAndFiltering(uuid, filtering);
        if (headwordEntry != null) {
            List<Agent> creators = this.getCreators(uuid);
            headwordEntry.setCreators(creators);
        }
        return headwordEntry;
    }

    public List<Agent> getCreators(UUID headwordEntryUuid) throws RepositoryException {
        StringBuilder innerQuery = new StringBuilder("SELECT hec.sortindex AS idx, * FROM entities AS e LEFT JOIN headwordentry_creators AS hec ON e.uuid = hec.agent_uuid WHERE hec.headwordentry_uuid = :uuid ORDER BY hec.sortindex ASC");
        String fieldsSql = this.entityRepositoryImpl.getSqlSelectReducedFields();
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>();
        argumentMappings.put("uuid", headwordEntryUuid);
        List entityList = this.entityRepositoryImpl.retrieveList(fieldsSql, innerQuery, argumentMappings, "ORDER BY idx ASC");
        List agents = null;
        if (entityList != null) {
            agents = entityList.stream().map(entity -> {
                IdentifiableObjectType type = entity.getIdentifiableObjectType();
                switch (type) {
                    case CORPORATE_BODY: {
                        CorporateBody corporateBody = new CorporateBody();
                        corporateBody.setLabel(entity.getLabel());
                        corporateBody.setRefId(entity.getRefId());
                        corporateBody.setUuid(entity.getUuid());
                        return corporateBody;
                    }
                    case FAMILY: {
                        Family family = new Family();
                        family.setLabel(entity.getLabel());
                        family.setRefId(entity.getRefId());
                        family.setUuid(entity.getUuid());
                        return family;
                    }
                    case PERSON: {
                        Person person = new Person();
                        person.setLabel(entity.getLabel());
                        person.setRefId(entity.getRefId());
                        person.setUuid(entity.getUuid());
                        return person;
                    }
                }
                return null;
            }).collect(Collectors.toList());
        }
        return agents;
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", date_published, text, timevalue_published, headword";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :datePublished, :text::JSONB, :timeValuePublished::JSONB, :headword";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectAllFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".text " + mappingPrefix + "_text, hw.uuid hw_uuid, hw.label hw_label";
    }

    @Override
    protected String getSqlSelectAllFieldsJoins() {
        return super.getSqlSelectAllFieldsJoins() + " LEFT JOIN headwords AS hw ON hw.uuid = he.headword";
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return super.getSqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".date_published " + mappingPrefix + "_datePublished, " + tableAlias + ".timevalue_published " + mappingPrefix + "_timeValuePublished";
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", date_published=:datePublished, text=:text::JSONB, timevalue_published=:timeValuePublished::JSONB, headword=:headword";
    }

    public void save(HeadwordEntry headwordEntry) throws RepositoryException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        UUID headwordUuid = null;
        if (headwordEntry.getHeadword() != null) {
            headwordUuid = headwordEntry.getHeadword().getUuid();
        }
        bindings.put("headword", headwordUuid);
        super.save(headwordEntry, bindings);
        List creators = headwordEntry.getCreators();
        this.setCreatorsList(headwordEntry, creators);
    }

    private void setCreatorsList(HeadwordEntry headwordEntry, List<Agent> creators) {
        UUID headwordEntryUuid = headwordEntry.getUuid();
        this.dbi.withHandle(h -> ((Update)h.createUpdate("DELETE FROM headwordentry_creators WHERE headwordentry_uuid = :uuid").bind("uuid", headwordEntryUuid)).execute());
        if (creators != null) {
            this.dbi.useHandle(handle -> {
                PreparedBatch preparedBatch = handle.prepareBatch("INSERT INTO headwordentry_creators(headwordentry_uuid, agent_uuid, sortIndex) VALUES(:uuid, :agentUuid, :sortIndex)");
                for (Agent agent : creators) {
                    ((PreparedBatch)((PreparedBatch)((PreparedBatch)preparedBatch.bind("uuid", headwordEntryUuid)).bind("agentUuid", agent.getUuid())).bind("sortIndex", this.getIndex(creators, (UniqueObject)agent))).add();
                }
                preparedBatch.execute();
            });
        }
    }

    public void update(HeadwordEntry headwordEntry) throws RepositoryException {
        HashMap<String, Object> bindings = new HashMap<String, Object>();
        UUID headwordUuid = null;
        if (headwordEntry.getHeadword() != null) {
            headwordUuid = headwordEntry.getHeadword().getUuid();
        }
        bindings.put("headword", headwordUuid);
        super.update(headwordEntry, (Map<String, Object>)bindings);
        List creators = headwordEntry.getCreators();
        this.setCreatorsList(headwordEntry, creators);
    }
}

