/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.server.backend.impl.jdbi.identifiable.semantic;

import de.digitalcollections.cudami.model.config.CudamiConfig;
import de.digitalcollections.cudami.server.backend.api.repository.exceptions.RepositoryException;
import de.digitalcollections.cudami.server.backend.api.repository.identifiable.semantic.SubjectRepository;
import de.digitalcollections.cudami.server.backend.impl.jdbi.UniqueObjectRepositoryImpl;
import de.digitalcollections.cudami.server.backend.impl.jdbi.type.DbIdentifierMapper;
import de.digitalcollections.model.identifiable.Identifier;
import de.digitalcollections.model.identifiable.semantic.Subject;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.array.SqlArrayType;
import org.jdbi.v3.core.mapper.ColumnMapper;
import org.jdbi.v3.core.mapper.reflect.BeanMapper;
import org.jdbi.v3.core.statement.Query;
import org.springframework.stereotype.Repository;

@Repository
public class SubjectRepositoryImpl
extends UniqueObjectRepositoryImpl<Subject>
implements SubjectRepository {
    public static final String MAPPING_PREFIX = "subj";
    public static final String TABLE_ALIAS = "subj";
    public static final String TABLE_NAME = "subjects";

    public static String sqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return SubjectRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    public static String sqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return UniqueObjectRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix) + ", " + tableAlias + ".identifiers " + mappingPrefix + "_identifiers, " + tableAlias + ".label " + mappingPrefix + "_label, " + tableAlias + ".type " + mappingPrefix + "_subjectType";
    }

    public SubjectRepositoryImpl(Jdbi dbi, CudamiConfig cudamiConfig, DbIdentifierMapper dbIdentifierMapper) {
        super(dbi, TABLE_NAME, "subj", "subj", Subject.class, cudamiConfig.getOffsetForAlternativePaging());
        dbi.registerRowMapper(BeanMapper.factory(Subject.class, (String)"subj"));
        this.dbi.registerArrayType((SqlArrayType)dbIdentifierMapper);
        this.dbi.registerColumnMapper(Identifier.class, (ColumnMapper)dbIdentifierMapper);
    }

    public Subject create() throws RepositoryException {
        return new Subject();
    }

    @Override
    public PageResponse<Subject> find(PageRequest pageRequest) throws RepositoryException {
        HashMap<String, Object> argumentMappings = new HashMap<String, Object>(0);
        String commonSql = " FROM " + this.tableName + " AS " + this.tableAlias + " left join unnest(subj.identifiers) as " + this.tableAlias + "_identifier on true";
        StringBuilder commonSqlBuilder = new StringBuilder(commonSql);
        this.addFiltering(pageRequest, commonSqlBuilder, argumentMappings);
        StringBuilder innerQuery = new StringBuilder("SELECT " + this.tableAlias + ".* " + commonSqlBuilder);
        this.addPagingAndSorting(pageRequest, innerQuery);
        List result = this.retrieveList(this.getSqlSelectReducedFields(), innerQuery, argumentMappings, this.getOrderBy(pageRequest.getSorting()));
        StringBuilder countQuery = new StringBuilder("SELECT count(*)" + commonSqlBuilder);
        long total = this.retrieveCount(countQuery, argumentMappings);
        PageResponse pageResponse = new PageResponse(result, pageRequest, total);
        this.filterByLocalizedTextFields(pageRequest, pageResponse, this.getJsonbFields());
        return pageResponse;
    }

    @Override
    protected List<String> getAllowedOrderByFields() {
        List<String> allowedOrderByFields = super.getAllowedOrderByFields();
        allowedOrderByFields.addAll(Arrays.asList("label", "subjectType"));
        return allowedOrderByFields;
    }

    public Subject getByTypeAndIdentifier(String subjectType, String namespace, String id) throws RepositoryException {
        String sql = "SELECT " + this.getSqlSelectAllFields() + " FROM " + this.tableName + " " + this.tableAlias + " left join UNNEST(" + this.tableAlias + ".identifiers) subjids on true " + String.format(" WHERE %s.type = :subjectType", this.tableAlias) + " AND subjids.namespace = :namespace AND subjids.id = :id";
        return (Subject)this.dbi.withHandle(h -> ((Query)((Query)((Query)h.createQuery(sql).bind("subjectType", subjectType)).bind("namespace", namespace)).bind("id", id)).mapTo(Subject.class).findOne().orElse(null));
    }

    @Override
    public String getColumnName(String modelProperty) {
        if (modelProperty == null) {
            return null;
        }
        switch (modelProperty) {
            case "label": {
                return this.tableAlias + ".label";
            }
            case "subjectType": {
                return this.tableAlias + ".type";
            }
        }
        return super.getColumnName(modelProperty);
    }

    @Override
    protected LinkedHashMap<String, Function<Subject, Optional<Object>>> getJsonbFields() {
        LinkedHashMap<String, Function<Subject, Optional<Object>>> linkedHashMap = super.getJsonbFields();
        linkedHashMap.put("label", i -> Optional.ofNullable(i.getLabel()));
        return linkedHashMap;
    }

    public List<Locale> getLanguages() throws RepositoryException {
        String query = "SELECT DISTINCT jsonb_object_keys(" + this.tableAlias + ".label) as languages FROM " + this.tableName + " AS " + this.tableAlias;
        List result = (List)this.dbi.withHandle(h -> h.createQuery(query).mapTo(Locale.class).list());
        return result;
    }

    public List<Subject> getRandom(int count) throws RepositoryException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getSqlInsertFields() {
        return super.getSqlInsertFields() + ", identifiers, label, split_label, type";
    }

    @Override
    protected String getSqlInsertValues() {
        return super.getSqlInsertValues() + ", :identifiers, :label::JSONB, :split_label, :subjectType";
    }

    @Override
    public String getSqlSelectAllFields(String tableAlias, String mappingPrefix) {
        return SubjectRepositoryImpl.sqlSelectAllFields(tableAlias, mappingPrefix);
    }

    @Override
    public String getSqlSelectReducedFields(String tableAlias, String mappingPrefix) {
        return SubjectRepositoryImpl.sqlSelectReducedFields(tableAlias, mappingPrefix);
    }

    @Override
    protected String getSqlUpdateFieldValues() {
        return super.getSqlUpdateFieldValues() + ", identifiers=:identifiers, label=:label::JSONB, split_label=:split_label, type=:subjectType";
    }

    @Override
    protected String getTargetExpression(FilterCriterion<?> fc) throws IllegalArgumentException {
        String givenExpression = fc.getExpression();
        if (fc.isNativeExpression()) {
            return this.getTableAlias() + "_" + givenExpression;
        }
        return super.getTargetExpression(fc);
    }

    @Override
    protected boolean hasSplitColumn(String propertyName) {
        return switch (propertyName) {
            case "label" -> true;
            default -> super.hasSplitColumn(propertyName);
        };
    }

    public void save(Subject subject) throws RepositoryException {
        HashMap<String, Object> bindings = new HashMap<String, Object>(0);
        bindings.put("split_label", this.splitToArray(subject.getLabel()));
        super.save(subject, bindings);
    }

    @Override
    protected boolean supportsCaseSensitivityForProperty(String modelProperty) {
        if (modelProperty == null) {
            return false;
        }
        switch (modelProperty) {
            case "identifiers_namespace": 
            case "subjectType": {
                return true;
            }
        }
        return false;
    }

    public void update(Subject subject) throws RepositoryException {
        HashMap<String, Object> bindings = new HashMap<String, Object>(0);
        bindings.put("split_label", this.splitToArray(subject.getLabel()));
        super.update(subject, bindings);
    }
}

